/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.Crash;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.PerformanceInfo;
import io.embrace.android.embracesdk.Stacktraces;
import io.embrace.android.embracesdk.TelephonyInfo;
import io.embrace.android.embracesdk.UserInfo;

final class EventMessage {
    @SerializedName(value="et")
    private final Event event;
    @SerializedName(value="cr")
    private final Crash crash;
    @SerializedName(value="d")
    private final DeviceInfo deviceInfo;
    @SerializedName(value="tl")
    private final TelephonyInfo telephonyInfo;
    @SerializedName(value="a")
    private final AppInfo appInfo;
    @SerializedName(value="u")
    private final UserInfo userInfo;
    @SerializedName(value="p")
    private final PerformanceInfo performanceInfo;
    @SerializedName(value="sk")
    private final Stacktraces stacktraces;
    @SerializedName(value="jsk")
    private final String javascriptStacktrace;
    @SerializedName(value="v")
    private final int version = 13;

    private EventMessage(Builder builder) {
        this.event = builder.event;
        this.crash = builder.crash;
        this.deviceInfo = builder.deviceInfo;
        this.telephonyInfo = builder.telephonyInfo;
        this.appInfo = builder.appInfo;
        this.userInfo = builder.userInfo;
        this.performanceInfo = builder.performanceInfo;
        this.stacktraces = builder.stacktraces;
        this.javascriptStacktrace = builder.javascriptStacktrace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Event getEvent() {
        return this.event;
    }

    public Crash getCrash() {
        return this.crash;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public TelephonyInfo getTelephonyInfo() {
        return this.telephonyInfo;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public PerformanceInfo getPerformanceInfo() {
        return this.performanceInfo;
    }

    public Stacktraces getStacktraces() {
        return this.stacktraces;
    }

    public String getJavascriptStacktrace() {
        return this.javascriptStacktrace;
    }

    public static final class Builder {
        private Event event;
        private Crash crash;
        private DeviceInfo deviceInfo;
        private TelephonyInfo telephonyInfo;
        private AppInfo appInfo;
        private UserInfo userInfo;
        private PerformanceInfo performanceInfo;
        private Stacktraces stacktraces;
        private String javascriptStacktrace;

        private Builder() {
        }

        public Builder withEvent(Event event) {
            this.event = event;
            return this;
        }

        public Builder withCrash(Crash crash) {
            this.crash = crash;
            return this;
        }

        public Builder withDeviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder withTelephonyInfo(TelephonyInfo telephonyInfo) {
            this.telephonyInfo = telephonyInfo;
            return this;
        }

        public Builder withAppInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
            return this;
        }

        public Builder withUserInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public Builder withPerformanceInfo(PerformanceInfo performanceInfo) {
            this.performanceInfo = performanceInfo;
            return this;
        }

        public Builder withStacktraces(Stacktraces stacktraces) {
            this.stacktraces = stacktraces;
            return this;
        }

        public Builder withJavascriptStacktrace(String javascriptStacktrace) {
            this.javascriptStacktrace = javascriptStacktrace;
            return this;
        }

        public EventMessage build() {
            return new EventMessage(this);
        }
    }
}

