/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.UserService;
import java.util.HashSet;
import java.util.regex.Pattern;

class EmbraceUserService
implements ActivityListener,
UserService {
    static final Pattern VALID_PERSONA = Pattern.compile("^[a-zA-Z0-9_]{1,32}$");
    private static final int PERSONA_LIMIT = 10;
    private final PreferencesService preferencesService;
    private volatile UserInfo userInfo;

    EmbraceUserService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
        this.userInfo = UserInfo.ofStored(preferencesService);
    }

    @Override
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserIdentifier(String userId) {
        UserInfo newUserInfo;
        this.userInfo = newUserInfo = UserInfo.newBuilder(this.userInfo).withUserId(userId).build();
        this.preferencesService.setUserIdentifier(userId);
    }

    @Override
    public void clearUserIdentifier() {
        this.setUserIdentifier(null);
    }

    @Override
    public void setUserEmail(String email) {
        UserInfo newUserInfo;
        this.userInfo = newUserInfo = UserInfo.newBuilder(this.userInfo).withEmail(email).build();
        this.preferencesService.setUserEmailAddress(email);
    }

    @Override
    public void clearUserEmail() {
        this.setUserEmail(null);
    }

    @Override
    public void setUserAsPayer() {
        this.setUserPersona("payer");
    }

    @Override
    public void clearUserAsPayer() {
        this.clearUserPersona("payer");
    }

    @Override
    public void setUserPersona(String persona) {
        UserInfo newUserInfo;
        if (!VALID_PERSONA.matcher(persona).matches()) {
            EmbraceLogger.logWarning("Ignoring persona " + persona + " as it does not match " + VALID_PERSONA.pattern());
            return;
        }
        if (this.userInfo.getPersonas().size() >= 10) {
            EmbraceLogger.logWarning("Cannot set persona as the limit of 10 has been reached");
            return;
        }
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (builder.getPersonas() != null) {
            personas.addAll(builder.getPersonas());
        }
        personas.add(persona);
        this.userInfo = newUserInfo = builder.withPersonas(personas).build();
        this.preferencesService.setUserPersonas(personas);
    }

    @Override
    public void clearUserPersona(String persona) {
        UserInfo newUserInfo;
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (builder.getPersonas() != null) {
            personas.addAll(builder.getPersonas());
        }
        personas.remove(persona);
        this.userInfo = newUserInfo = builder.withPersonas(personas).build();
        this.preferencesService.setUserPersonas(personas);
    }

    @Override
    public void clearAllUserPersonas() {
        UserInfo newUserInfo;
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (this.preferencesService.getUserPayer()) {
            personas.add("payer");
        }
        if (this.preferencesService.isUsersFirstDay()) {
            personas.add("first_day");
        }
        this.userInfo = newUserInfo = builder.withPersonas(personas).build();
    }

    @Override
    public void setUsername(String username) {
        UserInfo newUserInfo;
        this.userInfo = newUserInfo = UserInfo.newBuilder(this.userInfo).withUsername(username).build();
        this.preferencesService.setUsername(username);
    }

    @Override
    public void clearUsername() {
        this.setUsername(null);
    }
}

