/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.text.TextUtils;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.Uuid;
import java.util.HashMap;
import java.util.Map;
import java9.util.Maps;

abstract class CustomFlow {
    protected static final String PROP_MOMENT_ID = "moment-id";
    protected static final String PROP_MOMENT_NAME = "moment-name";
    protected static final String PROP_MESSAGE = "message";
    private static final String ERROR_BLANK_NAME = "Moment name is null or blank.";
    protected final Map<String, Map<String, Moment>> customMoments = new HashMap<String, Map<String, Moment>>();
    private EventService eventService = Embrace.getInstance().getEventService();
    private EmbraceRemoteLogger embraceRemoteLogger = Embrace.getInstance().getRemoteLogger();

    protected CustomFlow() {
    }

    public String momentStart(String momentName, boolean doesAllowScreenshot, Map<String, Object> properties) {
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError(ERROR_BLANK_NAME, false, null);
            return null;
        }
        if (momentName.startsWith("_")) {
            this.sendLogError("Moment name may not start with '_'.", false, null);
            return null;
        }
        Maps.putIfAbsent(this.customMoments, (Object)momentName, new HashMap());
        String momentId = Uuid.getEmbUuid();
        Map<String, Moment> moments = this.customMoments.get(momentName);
        this.sendMomentStartEvent(momentName, momentId, doesAllowScreenshot, PropertyUtils.sanitizeProperties(properties));
        moments.put(momentId, new Moment(momentName, momentId, doesAllowScreenshot, properties));
        return momentId;
    }

    public boolean momentComplete(String momentName) {
        return this.momentComplete(momentName, null);
    }

    public boolean momentComplete(String momentName, String momentId) {
        return this.momentComplete(momentName, momentId, null);
    }

    public boolean momentComplete(String momentName, String momentId, Map<String, Object> properties) {
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError(ERROR_BLANK_NAME, false, null);
            return false;
        }
        Map<String, Moment> moments = this.customMoments.get(momentName);
        if (moments == null) {
            EmbraceLogger.logError(String.format("Cannot fail %s because moment name is not recognized.", momentName));
            return false;
        }
        if (momentId == null) {
            for (Map.Entry<String, Moment> entry : moments.entrySet()) {
                this.sendMomentEndEvent(momentName, entry.getKey(), properties);
            }
            moments.clear();
        } else {
            Moment moment = moments.get(momentId);
            if (moment == null) {
                EmbraceLogger.logError(String.format("Cannot fail %s because moment identifier is not recognized.", momentName));
                return false;
            }
            this.sendMomentEndEvent(momentName, momentId, properties);
            moments.remove(momentId);
        }
        if (moments.isEmpty()) {
            this.customMoments.remove(momentName);
        }
        return true;
    }

    public boolean momentFail(String momentName, String msg) {
        return this.momentFail(momentName, null, msg);
    }

    public boolean momentFail(String momentName, String momentId, String msg, Map<String, Object> properties) {
        if (TextUtils.isEmpty((CharSequence)momentName)) {
            this.sendLogError(ERROR_BLANK_NAME, false, null);
            return false;
        }
        String errorLogMsg = TextUtils.isEmpty((CharSequence)msg) ? String.format("A failure occurred during the %s moment.", momentName) : String.format("A failure occurred during the %s moment: %s", momentName, msg);
        Map<String, Moment> moments = this.customMoments.get(momentName);
        if (moments == null) {
            EmbraceLogger.logError(String.format("Cannot fail %s because moment name is not recognized.", momentName));
            return false;
        }
        if (momentId == null) {
            for (Map.Entry<String, Moment> entry : moments.entrySet()) {
                Moment moment = entry.getValue();
                if (msg != null) {
                    moment.properties.put(PROP_MESSAGE, msg);
                }
                this.sendMomentEndEvent(momentName, entry.getKey(), properties);
                this.sendLogError(errorLogMsg, moment.doesAllowScreenshot, moment.properties);
            }
            moments.clear();
        } else {
            Moment moment = moments.get(momentId);
            if (moment == null) {
                EmbraceLogger.logError(String.format("Cannot fail %s because moment identifier is not recognized.", momentName));
                return false;
            }
            if (msg != null) {
                moment.properties.put(PROP_MESSAGE, msg);
            }
            this.sendMomentEndEvent(momentName, momentId, properties);
            this.sendLogError(errorLogMsg, moment.doesAllowScreenshot, moment.properties);
            moments.remove(momentId);
        }
        if (moments.isEmpty()) {
            this.customMoments.remove(momentName);
        }
        return true;
    }

    public boolean momentFail(String momentName, String momentId, String msg) {
        return this.momentFail(momentName, momentId, msg, null);
    }

    protected void sendMomentStartEvent(String momentName, String momentId, boolean doesAllowScreenshot, Map<String, Object> properties) {
        try {
            if (this.eventService == null) {
                throw new Exception("Event service is null. Embrace SDK might not be started.");
            }
            this.eventService.startEvent(momentName, momentId, doesAllowScreenshot, properties);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("An error occurred trying to start moment: %s - %s.", momentName, momentId), e);
        }
    }

    protected void sendMomentEndEvent(String momentName, String momentId, Map<String, Object> properties) {
        try {
            if (this.eventService == null) {
                throw new Exception("Event service is null. Embrace SDK might not be started.");
            }
            this.eventService.endEvent(momentName, momentId, properties);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("An error occurred trying to end moment: %s - %s.", momentName, momentId), e);
        }
    }

    protected void sendLogInfo(String msg, Map<String, Object> properties) {
        try {
            if (this.embraceRemoteLogger == null) {
                throw new Exception("Remote Logger is null. Embrace SDK might not be started.");
            }
            this.embraceRemoteLogger.log(msg, EmbraceEvent.Type.INFO_LOG, false, properties);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("An error occurred sending log info message: %s.", msg), e);
        }
    }

    protected void sendLogError(String msg, boolean doesAllowScreenshot, Map<String, Object> properties) {
        try {
            if (this.embraceRemoteLogger == null) {
                throw new Exception("Remote Logger is null. Embrace SDK might not be started.");
            }
            this.embraceRemoteLogger.log(msg, EmbraceEvent.Type.ERROR_LOG, doesAllowScreenshot, properties);
        }
        catch (Exception e) {
            EmbraceLogger.logError(String.format("An error occurred sending log error message: %s.", msg), e);
        }
    }

    private static class Moment {
        final String name;
        final String id;
        final boolean doesAllowScreenshot;
        final Map<String, Object> properties;

        Moment(String name, String id, boolean doesAllowScreenshot, Map<String, Object> properties) {
            this.name = name;
            this.id = id;
            this.doesAllowScreenshot = doesAllowScreenshot;
            this.properties = properties;
        }
    }
}

