package io.embrace.android.embracesdk;

import java.io.Closeable;

interface SessionService extends Closeable {

    /**
     * Starts a new session.
     *
     * @param coldStart whether this is a cold start of the application
     * @param startType the origin of the event that starts the session.
     */
    void startSession(boolean coldStart, Session.SessionLifeEventType startType);

    /**
     * This is responsible for the current session to be cached, ended and sent to the server and
     * immediately starting a new session after that.
     *
     * @param endType the origin of the event that ends the session.
     */
    void triggerStatelessSessionEnd(Session.SessionLifeEventType endType);

    /**
     * Based on the SDK STARTUP STATUS preference key , it analyzes if the startup failed during
     * last session.
     *
     * @return if the SDK startup failed last session.
     */
    boolean sdkStartupFailedLastSession();

    /**
     * Handles an uncaught exception, ending the session and saving the session to disk.
     */
    void handleCrash(String stacktrace);

}
