package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Represents an {@link Event} with metadata describing the device and user.
 */
final class EventMessage {
    @SerializedName("et")
    private final Event event;

    @SerializedName("cr")
    private final Crash crash;

    @SerializedName("d")
    private final DeviceInfo deviceInfo;

    @SerializedName("tl")
    private final TelephonyInfo telephonyInfo;

    @SerializedName("a")
    private final AppInfo appInfo;

    @SerializedName("u")
    private final UserInfo userInfo;

    @SerializedName("p")
    private final PerformanceInfo performanceInfo;

    @SerializedName("sk")
    private final Stacktraces stacktraces;

    @SerializedName("jsk")
    private final String javascriptStacktrace;

    @SerializedName("v")
    private final int version = ApiClient.MESSAGE_VERSION;

    private EventMessage(Builder builder) {
        event = builder.event;
        crash = builder.crash;
        deviceInfo = builder.deviceInfo;
        telephonyInfo = builder.telephonyInfo;
        appInfo = builder.appInfo;
        userInfo = builder.userInfo;
        performanceInfo = builder.performanceInfo;
        stacktraces = builder.stacktraces;
        javascriptStacktrace = builder.javascriptStacktrace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Event getEvent() {
        return event;
    }

    public Crash getCrash() {
        return crash;
    }

    public DeviceInfo getDeviceInfo() {
        return deviceInfo;
    }

    public TelephonyInfo getTelephonyInfo() {
        return telephonyInfo;
    }

    public AppInfo getAppInfo() {
        return appInfo;
    }

    public UserInfo getUserInfo() {
        return userInfo;
    }

    public PerformanceInfo getPerformanceInfo() {
        return performanceInfo;
    }

    public Stacktraces getStacktraces() {
        return stacktraces;
    }

    public String getJavascriptStacktrace() {
        return javascriptStacktrace;
    }

    public static final class Builder {
        private Event event;
        private Crash crash;
        private DeviceInfo deviceInfo;
        private TelephonyInfo telephonyInfo;
        private AppInfo appInfo;
        private UserInfo userInfo;
        private PerformanceInfo performanceInfo;
        private Stacktraces stacktraces;
        private String javascriptStacktrace;

        private Builder() {
        }

        public Builder withEvent(Event event) {
            this.event = event;
            return this;
        }

        public Builder withCrash(Crash crash) {
            this.crash = crash;
            return this;
        }

        public Builder withDeviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder withTelephonyInfo(TelephonyInfo telephonyInfo) {
            this.telephonyInfo = telephonyInfo;
            return this;
        }

        public Builder withAppInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
            return this;
        }

        public Builder withUserInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public Builder withPerformanceInfo(PerformanceInfo performanceInfo) {
            this.performanceInfo = performanceInfo;
            return this;
        }

        public Builder withStacktraces(Stacktraces stacktraces) {
            this.stacktraces = stacktraces;
            return this;
        }

        public Builder withJavascriptStacktrace(String javascriptStacktrace) {
            this.javascriptStacktrace = javascriptStacktrace;
            return this;
        }

        public EventMessage build() {
            return new EventMessage(this);
        }
    }
}
