/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.Stacktraces;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

class EmbraceRemoteLogger
implements MemoryCleanerListener {
    private final MetadataService metadataService;
    private final ScreenshotService screenshotService;
    private final ApiClient apiClient;
    private final UserService userService;
    private final ConfigService configService;
    private final NavigableMap<Long, String> infoLogIds = new ConcurrentSkipListMap<Long, String>();
    private final NavigableMap<Long, String> warningLogIds = new ConcurrentSkipListMap<Long, String>();
    private final NavigableMap<Long, String> errorLogIds = new ConcurrentSkipListMap<Long, String>();

    EmbraceRemoteLogger(MetadataService metadataService, ScreenshotService screenshotService, ApiClient apiClient, UserService userService, ConfigService configService, MemoryCleanerService memoryCleanerService) {
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.screenshotService = (ScreenshotService)Preconditions.checkNotNull((Object)screenshotService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
    }

    static Stacktraces getStackTraceForCurrentThread() {
        ArrayList<String> augmentedStackReturnAddresses = new ArrayList<String>();
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            augmentedStackReturnAddresses.add(element.toString());
        }
        Stacktraces stacktraces = new Stacktraces(augmentedStackReturnAddresses);
        return stacktraces;
    }

    void log(String message, EmbraceEvent.Type type, boolean takeScreenshot, Map<String, Object> properties) {
        if (this.configService.isLogMessageDisabled(message)) {
            EmbraceLogger.logWarning(String.format("Log message disabled. Ignoring log with message %s", message));
            return;
        }
        if (this.configService.isMessageTypeDisabled(MessageType.LOG)) {
            EmbraceLogger.logWarning("Log message disabled. Ignoring all Logs.");
            return;
        }
        String id = Uuid.getEmbUuid();
        long timestamp = System.currentTimeMillis();
        if (type.equals((Object)EmbraceEvent.Type.INFO_LOG)) {
            this.infoLogIds.put(timestamp, id);
        } else if (type.equals((Object)EmbraceEvent.Type.WARNING_LOG)) {
            this.warningLogIds.put(timestamp, id);
        } else if (type.equals((Object)EmbraceEvent.Type.ERROR_LOG)) {
            this.errorLogIds.put(timestamp, id);
        } else {
            EmbraceLogger.logWarning("Unknown log level " + type.toString());
            return;
        }
        Event.Builder builder = Event.newBuilder().withType(type).withName(message).withTimestamp(System.currentTimeMillis()).withAppState(this.metadataService.getAppState()).withMessageId(id).withCustomProperties(properties);
        Optional<String> optionalSessionId = this.metadataService.getActiveSessionId();
        if (optionalSessionId.isPresent()) {
            builder = builder.withSessionId((String)optionalSessionId.get());
        }
        if (takeScreenshot && !this.configService.isScreenshotDisabledForEvent(message)) {
            boolean screenshotTaken = this.screenshotService.takeScreenshotLogEvent(id);
            builder = builder.withScreenshotTaken(screenshotTaken);
        }
        Event event = builder.build();
        EventMessage eventMessage = EventMessage.newBuilder().withEvent(event).withStacktraces(EmbraceRemoteLogger.getStackTraceForCurrentThread()).withDeviceInfo(this.metadataService.getDeviceInfo()).withTelephonyInfo(this.metadataService.getTelephonyInfo()).withAppInfo(this.metadataService.getAppInfo()).withUserInfo(this.userService.getUserInfo()).build();
        this.apiClient.sendLogs(eventMessage);
    }

    List<String> findInfoLogIds(long startTime, long endTime) {
        return new ArrayList<String>(this.infoLogIds.subMap(startTime, endTime).values());
    }

    List<String> findWarningLogIds(long startTime, long endTime) {
        return new ArrayList<String>(this.warningLogIds.subMap(startTime, endTime).values());
    }

    List<String> findErrorLogIds(long startTime, long endTime) {
        return new ArrayList<String>(this.errorLogIds.subMap(startTime, endTime).values());
    }

    @Override
    public void cleanCollections() {
        this.infoLogIds.clear();
        this.warningLogIds.clear();
        this.errorLogIds.clear();
    }
}

