/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.ConnectionClassService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.NetworkCallV2;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.NetworkSessionV2;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java9.util.J8Arrays;
import java9.util.stream.Collectors;

class EmbraceNetworkLoggingService
implements NetworkLoggingService,
MemoryCleanerListener {
    public static final String DNS_PATTERN = "([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,63}[a-zA-Z0-9])?)(\\.[a-zA-Z]{1,63})(\\.[a-zA-Z]{1,2})?$";
    public static final String IPV4_PATTERN = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    public static final String IPV6_PATTERN = "(([a-fA-F0-9]{1,4}|):){1,7}([a-fA-F0-9]{1,4}|:)";
    private static final int DEFAULT_NETWORK_CALL_LIMIT = 1000;
    private final ConnectionClassService connectionClassService;
    private final ConfigService configService;
    private final NavigableMap<Long, NetworkCallV2> networkCalls;
    private final Map<String, DomainSettings> domainSettings;
    private final BuildInfo buildInfo;

    public EmbraceNetworkLoggingService(ConnectionClassService connectionClassService, ConfigService configService, BuildInfo buildInfo, MemoryCleanerService memoryCleanerService) {
        this.connectionClassService = (ConnectionClassService)Preconditions.checkNotNull((Object)connectionClassService, (Object)"connectionClassService must not be null");
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService, (Object)"configService must not be null");
        this.buildInfo = (BuildInfo)Preconditions.checkNotNull((Object)buildInfo, (Object)"buildInfo must not be null");
        this.networkCalls = new ConcurrentSkipListMap<Long, NetworkCallV2>();
        this.domainSettings = new ConcurrentHashMap<String, DomainSettings>();
        ((MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService)).addListener(this);
    }

    @Override
    public List<NetworkCallV2> getNetworkCalls(long startTime, long endTime) {
        return new ArrayList<NetworkCallV2>(this.networkCalls.subMap(startTime, endTime).values());
    }

    @Override
    public NetworkSessionV2 getNetworkSession(long startTime, long lastKnownTime) {
        List<NetworkCallV2> calls = this.getNetworkCalls(startTime, lastKnownTime);
        Optional<Integer> gradleLimit = Optional.absent();
        Optional<BuildInfo.Network> networkConfig = this.buildInfo.getNetworkConfig();
        if (networkConfig.isPresent()) {
            gradleLimit = ((BuildInfo.Network)networkConfig.get()).getDefaultCaptureLimit();
        }
        int defaultLimit = (Integer)this.configService.getConfig().getDefaultNetworkCallLimit().or(gradleLimit).or((Object)1000);
        HashMap<String, NetworkSessionV2.DomainCount> callsPerDomain = new HashMap<String, NetworkSessionV2.DomainCount>();
        ArrayList<NetworkCallV2> networkCalls = new ArrayList<NetworkCallV2>();
        int ipAddressCount = 0;
        for (NetworkCallV2 call : calls) {
            Optional<String> domain = EmbraceNetworkLoggingService.getDomain(call.getUrl());
            if (!domain.isPresent() || EmbraceNetworkLoggingService.isIpAddress((String)domain.get())) {
                if (ipAddressCount >= defaultLimit) continue;
                ++ipAddressCount;
                continue;
            }
            DomainSettings settings = this.domainSettings.get(domain.get());
            if (settings == null) {
                networkCalls.add(call);
                continue;
            }
            String suffix = settings.getSuffix();
            int limit = settings.getLimit();
            NetworkSessionV2.DomainCount count = (NetworkSessionV2.DomainCount)callsPerDomain.get(suffix);
            if (count == null) {
                count = new NetworkSessionV2.DomainCount(0, limit);
            }
            if (count.getRequestCount() < limit) {
                networkCalls.add(call);
            }
            callsPerDomain.put(suffix, new NetworkSessionV2.DomainCount(count.getRequestCount() + 1, limit));
        }
        HashMap<String, NetworkSessionV2.DomainCount> overLimit = new HashMap<String, NetworkSessionV2.DomainCount>();
        for (Map.Entry entry : callsPerDomain.entrySet()) {
            NetworkSessionV2.DomainCount value = (NetworkSessionV2.DomainCount)entry.getValue();
            if (value.getRequestCount() <= value.getCaptureLimit()) continue;
            overLimit.put((String)entry.getKey(), value);
        }
        return new NetworkSessionV2(networkCalls, overLimit);
    }

    @Override
    public void logNetworkCall(String url, String httpMethod, Integer statusCode, long startTime, long endTime, Long bytesSent, Long bytesReceived) {
        long duration = Math.max(endTime - startTime, 0L);
        NetworkCallV2 networkCall = NetworkCallV2.newBuilder().withUrl(EmbraceNetworkLoggingService.stripUrl(url)).withHttpMethod(httpMethod).withStartTime(startTime).withDuration(duration).withEndTime(endTime).withBytesSent(bytesSent).withBytesReceived(bytesReceived).withResponseCode(statusCode).build();
        this.networkCalls.put(startTime, networkCall);
        this.connectionClassService.logBandwidth(bytesReceived, duration);
        this.storeSettings(url);
    }

    @Override
    public void logNetworkError(String url, String httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        NetworkCallV2 networkCall = NetworkCallV2.newBuilder().withUrl(EmbraceNetworkLoggingService.stripUrl(url)).withHttpMethod(httpMethod).withStartTime(startTime).withEndTime(endTime).withDuration(Math.max(endTime - startTime, 0L)).withErrorType(errorType).build();
        this.networkCalls.put(startTime, networkCall);
        this.storeSettings(url);
    }

    private void storeSettings(String url) {
        try {
            Map<String, Integer> remoteLimits = this.configService.getConfig().getNetworkCallLimitsPerDomain();
            HashMap<String, Integer> mergedLimits = new HashMap<String, Integer>();
            if (this.buildInfo.getNetworkConfig().isPresent()) {
                for (BuildInfo.Network.Domain domain : ((BuildInfo.Network)this.buildInfo.getNetworkConfig().get()).getDomains()) {
                    mergedLimits.put(domain.getDomain(), domain.getLimit());
                }
            }
            mergedLimits.putAll(remoteLimits);
            Optional<String> domain = EmbraceNetworkLoggingService.getDomain(url);
            if (!domain.isPresent()) {
                return;
            }
            String domainString = (String)domain.get();
            if (this.domainSettings.containsKey(domainString)) {
                return;
            }
            for (Map.Entry entry : mergedLimits.entrySet()) {
                if (!domainString.endsWith((String)entry.getKey())) continue;
                this.domainSettings.put(domainString, new DomainSettings((Integer)entry.getValue(), (String)entry.getKey()));
                return;
            }
            int defaultLimit = (Integer)this.configService.getConfig().getDefaultNetworkCallLimit().or((Object)1000);
            this.domainSettings.put(domainString, new DomainSettings(defaultLimit, EmbraceNetworkLoggingService.trimDomain(domainString)));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to determine limits for URL: " + url, ex);
        }
    }

    private static String stripUrl(String url) {
        if (url == null) {
            return null;
        }
        int pathPos = url.lastIndexOf(47);
        String suffix = pathPos < 0 ? url : url.substring(pathPos);
        int queryPos = suffix.indexOf(63);
        int fragmentPos = suffix.indexOf(35);
        int terminalPos = Math.min(queryPos < 0 ? Integer.MAX_VALUE : queryPos, fragmentPos < 0 ? Integer.MAX_VALUE : fragmentPos);
        return url.substring(0, (pathPos < 0 ? 0 : pathPos) + Math.min(suffix.length(), terminalPos));
    }

    @Override
    public void cleanCollections() {
        this.networkCalls.clear();
        this.domainSettings.clear();
    }

    static String trimDomain(String domain) {
        Object[] parts = domain.split(".");
        if (parts.length > 2) {
            return (String)J8Arrays.stream((Object[])parts).skip(1L).collect(Collectors.joining((CharSequence)"."));
        }
        return domain;
    }

    static Optional<String> getDomain(String url) {
        Matcher matcher;
        if (!url.startsWith("http")) {
            url = String.format("http://%s", url);
        }
        Pattern pattern = Pattern.compile(String.format("%s|%s|%s", DNS_PATTERN, IPV4_PATTERN, IPV6_PATTERN));
        try {
            matcher = pattern.matcher(new URL(url).getHost());
        }
        catch (MalformedURLException ignored) {
            matcher = pattern.matcher(url);
        }
        if (matcher.find()) {
            return Optional.fromNullable((Object)matcher.group(0));
        }
        return Optional.absent();
    }

    static boolean isIpAddress(String domain) {
        return Pattern.compile(String.format("%s|%s", IPV4_PATTERN, IPV6_PATTERN)).matcher(domain).find();
    }

    class DomainSettings {
        private final int limit;
        private final String suffix;

        DomainSettings(int limit, String suffix) {
            this.limit = limit;
            this.suffix = suffix;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

