package io.embrace.android.embracesdk;

import java.util.List;

/**
 * Determine's the class of the current connection as one of {@link ConnectionQuality}. Listeners
 * can subscribe for updates when the connection quality changes, and network libraries can log
 * bandwidth usage to be factored into the connection quality measurement.
 */
interface ConnectionClassService {
    /**
     * Logs bandwidth usage.
     *
     * @param bytes the number of bytes used
     * @param timeMs the time in milliseconds it took.
     */
    void logBandwidth(long bytes, long timeMs);

    /**
     * Adds a listener for changes to the {@link ConnectionQuality}. The listeners will be notified
     * when the service detects a change in network quality.
     *
     * @param listener the listener to add
     */
    void addListener(ConnectionQualityListener listener);

    /**
     * Removes an existing listener, if it exists, from the {@link SignalQualityService} so that
     * it will no longer be notified of changes to the {@link ConnectionQuality}.
     *
     * @param listener the listener to remove
     */
    void removeListener(ConnectionQualityListener listener);

    /**
     * Gets the connection quality intervals within the specified time range, describing the network
     * quality and available bandwidth during particular periods of time.
     *
     * @param startTime the start of the time range
     * @param endTime the end of the time range
     * @return the list of connection quality intervals
     */
    List<ConnectionQualityInterval> getQualityIntervals(long startTime, long endTime);
}
