/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.Breadcrumbs;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionPerformanceInfo;
import io.embrace.android.embracesdk.UserInfo;

final class SessionMessage {
    @SerializedName(value="s")
    private final Session session;
    @SerializedName(value="u")
    private final UserInfo userInfo;
    @SerializedName(value="a")
    private final AppInfo appInfo;
    @SerializedName(value="d")
    private final DeviceInfo deviceInfo;
    @SerializedName(value="p")
    private final SessionPerformanceInfo performanceInfo;
    @SerializedName(value="br")
    private final Breadcrumbs breadcrumbs;
    @SerializedName(value="v")
    private final int version = 13;

    private SessionMessage(Builder builder) {
        this.session = builder.session;
        this.userInfo = builder.userInfo;
        this.appInfo = builder.appInfo;
        this.deviceInfo = builder.deviceInfo;
        this.performanceInfo = builder.performanceInfo;
        this.breadcrumbs = builder.breadcrumbs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SessionMessage copy) {
        Builder builder = new Builder();
        builder.session = copy.getSession();
        builder.userInfo = copy.getUserInfo();
        builder.appInfo = copy.getAppInfo();
        builder.deviceInfo = copy.getDeviceInfo();
        builder.performanceInfo = copy.getPerformanceInfo();
        builder.breadcrumbs = copy.getBreadcrumbs();
        return builder;
    }

    public Session getSession() {
        return this.session;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public AppInfo getAppInfo() {
        return this.appInfo;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public SessionPerformanceInfo getPerformanceInfo() {
        return this.performanceInfo;
    }

    public Breadcrumbs getBreadcrumbs() {
        return this.breadcrumbs;
    }

    public static final class Builder {
        private Session session;
        private UserInfo userInfo;
        private AppInfo appInfo;
        private DeviceInfo deviceInfo;
        private SessionPerformanceInfo performanceInfo;
        private Breadcrumbs breadcrumbs;

        private Builder() {
        }

        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder withUserInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public Builder withAppInfo(AppInfo appInfo) {
            this.appInfo = appInfo;
            return this;
        }

        public Builder withDeviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder withPerformanceInfo(SessionPerformanceInfo performanceInfo) {
            this.performanceInfo = performanceInfo;
            return this;
        }

        public Builder withBreadcrumbs(Breadcrumbs breadcrumbs) {
            this.breadcrumbs = breadcrumbs;
            return this;
        }

        public SessionMessage build() {
            return new SessionMessage(this);
        }
    }
}

