/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.support.annotation.Nullable;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceLogger;

final class EmbraceUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @Nullable
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final CrashService crashService;

    EmbraceUncaughtExceptionHandler(Thread.UncaughtExceptionHandler defaultHandler, CrashService crashService) {
        this.defaultHandler = defaultHandler;
        this.crashService = (CrashService)Preconditions.checkNotNull((Object)crashService);
        EmbraceLogger.logDebug("Registered EmbraceUncaughtExceptionHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        try {
            this.crashService.handleCrash(thread, exception);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Error occurred in the uncaught exception handler", ex);
        }
        finally {
            EmbraceLogger.logDebug("Finished handling exception. Delegating to default handler.", exception);
            if (this.defaultHandler != null) {
                this.defaultHandler.uncaughtException(thread, exception);
            }
        }
    }
}

