/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import com.fernandocejas.arrow.strings.Charsets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.ApiRequest;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

class ApiClient
implements Closeable {
    static final int MESSAGE_VERSION = 13;
    private static final int CONFIG_API_VERSION = 2;
    private static final int API_VERSION = 1;
    private static final String FAILED_API_CALL_FILE = "failed_api_calls.json";
    private static final String DATA_DEV_PREFIX = "https://data-dev.emb-api.com";
    private static final String DATA_PROD_PREFIX = "https://data.emb-api.com";
    private static final String SCREENSHOT_URL_FORMAT = "%s/%s/%s/%s.jpg";
    private static final String URL_FORMAT = "%s/v%s/%s";
    private static final String CONFIG_URL_FORMAT = "%s?appId=%s&osVersion=%s&appVersion=%s&deviceId=%s";
    private static final String STORY_ID_HEADER_FORMAT = "%s:%s";
    private static final String SCREENSHOT_URL = String.format("%s/v%s/%s", "https://images.emb-api.com", 1, "screenshot");
    private final CacheService cacheService;
    private final String dataUrlPrefix;
    private final String appId;
    private final String deviceId;
    private final String operatingSystemCode = String.format(Locale.US, "%d.0.0", MetadataUtils.getOperatingSystemVersionCode());
    private final String appVersion;
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("API Client");
    private final ScheduledWorker retryWorker = ScheduledWorker.ofSingleThread("API Retry");
    private final Gson gson = new Gson();
    private final Queue<FailedApiCall> failedApiCalls = new ConcurrentLinkedQueue<FailedApiCall>();

    ApiClient(MetadataService metadataService, CacheService cacheService) {
        Preconditions.checkNotNull((Object)metadataService, (Object)"metadataService must not be null");
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService, (Object)"cacheService must not be null");
        this.dataUrlPrefix = metadataService.isDebug() ? DATA_DEV_PREFIX : DATA_PROD_PREFIX;
        this.appId = metadataService.getAppId();
        this.appVersion = (String)metadataService.getAppVersionCodeForRequest().or((Object)"");
        this.deviceId = metadataService.getDeviceId();
        this.startRetryWorker();
    }

    private void startRetryWorker() {
        Optional<FailedApiCalls> optionalCalls = this.cacheService.loadObject(FAILED_API_CALL_FILE, FailedApiCalls.class);
        if (optionalCalls.isPresent()) {
            this.failedApiCalls.addAll(((FailedApiCalls)optionalCalls.get()).getFailedApiCalls());
        }
        this.retryWorker.scheduleAtFixedRate(() -> {
            try {
                ArrayList<FailedApiCall> reattempt = new ArrayList<FailedApiCall>();
                FailedApiCall lastCall = this.failedApiCalls.poll();
                while (lastCall != null) {
                    reattempt.add(lastCall);
                    lastCall = this.failedApiCalls.poll();
                }
                this.cacheService.cacheObject(FAILED_API_CALL_FILE, new FailedApiCalls(reattempt));
                for (FailedApiCall apiCall : reattempt) {
                    this.jsonPost(apiCall.getApiRequest(), apiCall.getPayload());
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Error in ApiClient retry worker", ex);
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    Future<Config> getConfig() {
        String base = String.format(URL_FORMAT, "https://config.emb-api.com", 2, "config");
        String url = String.format(CONFIG_URL_FORMAT, base, this.appId, this.operatingSystemCode, this.appVersion, this.deviceId);
        HttpURLConnection connection = ApiRequest.newBuilder().withHttpMethod(HttpMethod.GET).withUrl(Unchecked.wrap(() -> new URL(url))).build().toConection();
        return this.worker.submit(() -> {
            connection.connect();
            return this.httpCall(connection, Config.class);
        });
    }

    Future<String> sendLogScreenshot(byte[] screenshot, String logId) {
        URL url = Unchecked.wrap(() -> new URL(String.format(SCREENSHOT_URL_FORMAT, SCREENSHOT_URL, this.appId, "logs", logId)));
        ApiRequest request = this.screenshotBuilder(url).withLogId(logId).build();
        return this.rawPost(request, screenshot);
    }

    Future<String> sendMomentScreenshot(byte[] screenshot, String storyId) {
        URL url = Unchecked.wrap(() -> new URL(String.format(SCREENSHOT_URL_FORMAT, SCREENSHOT_URL, this.appId, "moments", storyId)));
        ApiRequest request = this.screenshotBuilder(url).withStoryId(storyId).build();
        return this.rawPost(request, screenshot);
    }

    Future<String> sendSession(SessionMessage sessionMessage) {
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/sessions")));
        ApiRequest request = this.eventBuilder(url).withDeviceId(this.deviceId).withAppId(this.appId).withUrl(url).withHttpMethod(HttpMethod.POST).withContentEncoding("gzip").build();
        return this.jsonPost(request, sessionMessage);
    }

    Future<String> sendLogs(EventMessage eventMessage) {
        Preconditions.checkNotNull((Object)eventMessage.getEvent(), (Object)"event must be set");
        Event event = eventMessage.getEvent();
        Preconditions.checkNotNull((Object)((Object)event.getType()), (Object)"event type must be set");
        Preconditions.checkNotNull((Object)event.getStoryId(), (Object)"event storyId must be set");
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/logging")));
        String abbreviation = event.getType().getAbbreviation();
        String storyIdentifier = String.format(STORY_ID_HEADER_FORMAT, abbreviation, event.getStoryId());
        ApiRequest request = this.eventBuilder(url).withLogId(storyIdentifier).build();
        return this.sendEvent(eventMessage, request);
    }

    Future<String> sendEvent(EventMessage eventMessage) {
        Preconditions.checkNotNull((Object)eventMessage.getEvent(), (Object)"event must be set");
        Event event = eventMessage.getEvent();
        Preconditions.checkNotNull((Object)((Object)event.getType()), (Object)"event type must be set");
        Preconditions.checkNotNull((Object)event.getStoryId(), (Object)"event storyId must be set");
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/events")));
        String abbreviation = event.getType().getAbbreviation();
        String storyIdentifier = String.format(STORY_ID_HEADER_FORMAT, abbreviation, event.getStoryId());
        ApiRequest request = this.eventBuilder(url).withStoryId(storyIdentifier).build();
        return this.sendEvent(eventMessage, request);
    }

    private Future<String> sendEvent(EventMessage eventMessage, ApiRequest request) {
        return this.jsonPost(request, eventMessage);
    }

    Future<String> sendUser(UserInfo user) {
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/users")));
        ApiRequest request = this.eventBuilder(url).withDeviceId(this.deviceId).withAppId(this.appId).withUrl(url).withHttpMethod(HttpMethod.POST).withContentEncoding("gzip").build();
        return this.jsonPost(request, user);
    }

    private <T> Future<String> jsonPost(ApiRequest request, T payload) {
        byte[] bytes = this.gson.toJson(payload).getBytes(Charsets.UTF_8);
        return this.worker.submit(() -> {
            try {
                return this.sendBytes(request, ApiClient.gzip(bytes));
            }
            catch (Exception ex) {
                EmbraceLogger.logWarning("Failed to post Embrace API call. Will retry.", ex);
                this.failedApiCalls.add(new FailedApiCall<Object>(request, payload));
                throw Unchecked.propagate(ex);
            }
        });
    }

    private Future<String> rawPost(ApiRequest request, byte[] payload) {
        return this.worker.submit(() -> this.sendBytes(request, payload));
    }

    private String sendBytes(ApiRequest request, byte[] payload) {
        return Unchecked.wrap(() -> {
            HttpURLConnection connection = request.toConection();
            if (payload != null) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(payload);
                connection.connect();
            }
            return this.httpCall(connection);
        });
    }

    void sendDebugMessages() {
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "debugMessages")));
    }

    private static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream os = null;
        try {
            baos = new ByteArrayOutputStream();
            os = new GZIPOutputStream(baos);
            os.write(bytes);
            os.finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close streams when gzipping payload", ex);
            }
        }
    }

    private <T> T httpCall(HttpURLConnection connection, Class<T> clazz) {
        this.handleHttpResponseCode(connection);
        return this.readJsonObject(connection, clazz);
    }

    private String httpCall(HttpURLConnection connection) {
        this.handleHttpResponseCode(connection);
        return Unchecked.wrap(() -> this.readString(connection.getInputStream()));
    }

    private void handleHttpResponseCode(HttpURLConnection connection) {
        Integer responseCode = null;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseCode == null || responseCode != 200) {
            if (responseCode != null) {
                String errorMessage = this.readString(connection.getErrorStream());
                EmbraceLogger.logWarning("Embrace API request failed. HTTP response code: " + responseCode + ", message: " + errorMessage);
            }
            throw new IllegalStateException("Failed to retrieve from Embrace server.");
        }
    }

    private <T> T readJsonObject(HttpURLConnection connection, Class<T> clazz) {
        InputStreamReader inputStreamReader = null;
        JsonReader reader = null;
        try {
            inputStreamReader = new InputStreamReader(connection.getInputStream());
            reader = new JsonReader((Reader)inputStreamReader);
            Object object = this.gson.fromJson(reader, clazz);
            return (T)object;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close HTTP reader", ex);
            }
        }
    }

    private String readString(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            int len;
            inputStreamReader = new InputStreamReader(inputStream);
            reader = new BufferedReader(inputStreamReader);
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close HTTP reader", ex);
            }
        }
    }

    private ApiRequest.Builder screenshotBuilder(URL url) {
        return ApiRequest.newBuilder().withContentType("application/octet-stream").withHttpMethod(HttpMethod.POST).withAppId(this.appId).withDeviceId(this.deviceId).withUrl(url);
    }

    private ApiRequest.Builder eventBuilder(URL url) {
        return ApiRequest.newBuilder().withUrl(url).withHttpMethod(HttpMethod.POST).withAppId(this.appId).withDeviceId(this.deviceId).withContentEncoding("gzip");
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Shutting down ApiClient");
        this.retryWorker.close();
        this.worker.close();
    }

    class FailedApiCalls {
        private final List<FailedApiCall> failedApiCalls;

        FailedApiCalls(List<FailedApiCall> failedApiCalls) {
            this.failedApiCalls = failedApiCalls;
        }

        List<FailedApiCall> getFailedApiCalls() {
            return this.failedApiCalls;
        }
    }

    class FailedApiCall<T> {
        private final ApiRequest apiRequest;
        private final T payload;

        FailedApiCall(ApiRequest apiRequest, T payload) {
            this.apiRequest = apiRequest;
            this.payload = payload;
        }

        public ApiRequest getApiRequest() {
            return this.apiRequest;
        }

        public T getPayload() {
            return this.payload;
        }
    }
}

