/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java9.util.Lists;

final class ExceptionInfo {
    @SerializedName(value="n")
    private final String name;
    @SerializedName(value="m")
    private final String message;
    @SerializedName(value="tt")
    private final List<String> lines;

    ExceptionInfo(String name, String message, List<String> lines) {
        this.name = name;
        this.message = message;
        this.lines = Lists.copyOf(lines);
    }

    String getName() {
        return this.name;
    }

    String getMessage() {
        return this.message;
    }

    List<String> getLines() {
        return this.lines;
    }

    static ExceptionInfo ofThrowable(Throwable throwable) {
        String name = "";
        String message = "";
        ArrayList<String> lines = new ArrayList<String>();
        if (throwable.getClass() != null && throwable.getClass().getName() != null) {
            name = throwable.getClass().getName();
        }
        if (throwable.getMessage() != null) {
            message = throwable.getMessage();
        }
        for (StackTraceElement line : throwable.getStackTrace()) {
            lines.add(line.toString());
        }
        return new ExceptionInfo(name, message, lines);
    }
}

