/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.Crash;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceUncaughtExceptionHandler;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.UserService;

final class EmbraceCrashService
implements CrashService {
    private static final String CRASH_REPORT_EVENT_NAME = "_crash_report";
    private final SessionService sessionService;
    private final MetadataService metadataService;
    private final ApiClient apiClient;
    private final UserService userService;

    EmbraceCrashService(SessionService sessionService, MetadataService metadataService, ApiClient apiClient, UserService userService) {
        this.registerExceptionHandler();
        this.sessionService = (SessionService)Preconditions.checkNotNull((Object)sessionService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
    }

    @Override
    public void handleCrash(Thread thread, Throwable exception) {
        Event.Builder builder = Event.newBuilder();
        Crash crash = Crash.ofThrowable(exception);
        builder = builder.withName(CRASH_REPORT_EVENT_NAME).withType(EmbraceEvent.Type.CRASH).withTimestamp(System.currentTimeMillis()).withAppState(this.metadataService.getAppState());
        Optional<String> optionalSessionId = this.metadataService.getActiveSessionId();
        if (optionalSessionId.isPresent()) {
            builder = builder.withSessionId((String)optionalSessionId.get());
        }
        EventMessage.Builder versionedEventBuilder = EventMessage.newBuilder().withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withUserInfo(this.userService.getUserInfo()).withCrash(crash).withEvent(builder.build());
        this.apiClient.sendEvent(versionedEventBuilder.build());
        this.sessionService.handleCrash();
    }

    private void registerExceptionHandler() {
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        EmbraceUncaughtExceptionHandler embraceHandler = new EmbraceUncaughtExceptionHandler(defaultHandler, this);
        Thread.setDefaultUncaughtExceptionHandler(embraceHandler);
    }
}

