/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.util.concurrent.atomic.AtomicInteger;

final class EmbraceSessionService
implements SessionService,
ActivityListener {
    public static final String APPLICATION_STATE_ACTIVE = "active";
    public static final String APPLICATION_STATE_BACKGROUND = "background";
    private static final String SESSION_START_TYPE = "st";
    private static final String SESSION_END_TYPE = "en";
    private final Object lock = new Object();
    private final PreferencesService preferencesService;
    private final MetadataService metadataService;
    private final BreadcrumbService breadcrumbService;
    private final PowerService powerService;
    private final ActivityService activityService;
    private final ApiClient apiClient;
    private final EventService eventService;
    private final EmbraceRemoteLogger remoteLogger;
    private final UserService userService;
    private final ConfigService configService;
    private final AtomicInteger sessionNumber = new AtomicInteger(0);
    private volatile Session activeSession;
    private volatile long sessionLastSaved = System.currentTimeMillis();

    EmbraceSessionService(PreferencesService preferencesService, MetadataService metadataService, BreadcrumbService breadcrumbService, PowerService powerService, ActivityService activityService, ApiClient apiClient, EventService eventService, EmbraceRemoteLogger remoteLogger, UserService userService, ConfigService configService) {
        this.preferencesService = (PreferencesService)Preconditions.checkNotNull((Object)preferencesService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.breadcrumbService = (BreadcrumbService)Preconditions.checkNotNull((Object)breadcrumbService);
        this.powerService = (PowerService)Preconditions.checkNotNull((Object)powerService);
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.eventService = (EventService)Preconditions.checkNotNull((Object)eventService);
        this.remoteLogger = (EmbraceRemoteLogger)Preconditions.checkNotNull((Object)remoteLogger);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.activityService.addListener(this, true);
    }

    private static long getLastKnownTime(Session session) {
        if (session.getEndTime() != null) {
            return session.getEndTime();
        }
        if (session.getLastHeartbeatTime() != null) {
            return session.getLastHeartbeatTime();
        }
        return session.getStartTime();
    }

    @Override
    public void startSession(boolean coldStart) {
        if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
            EmbraceLogger.logWarning("Session messages disabled. Ignoring all Sessions.");
            return;
        }
        String sessionId = Uuid.getEmbUuid();
        SessionMessage message = this.sessionStart(coldStart, this.sessionNumber.incrementAndGet(), sessionId);
        this.activeSession = message.getSession();
        this.metadataService.setActiveSessionId(sessionId);
        this.apiClient.sendSession(message);
    }

    @Override
    public boolean sdkStartupFailedLastSession() {
        Optional<String> lastSessionStartupProgress = this.preferencesService.getSDKStartupStatus();
        return lastSessionStartupProgress.isPresent() && !((String)lastSessionStartupProgress.get()).equals("startup_completed");
    }

    @Override
    public boolean isFirstDay() {
        Optional<Long> installDate = this.preferencesService.getInstallDate();
        return installDate.isPresent() && System.currentTimeMillis() - (Long)installDate.get() <= 86400000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCrash() {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeSession != null) {
                SessionMessage sessionMessage = this.sessionEnd(this.activeSession, false);
                Unchecked.wrap(() -> this.apiClient.sendSession(sessionMessage).get());
            }
        }
    }

    private SessionMessage sessionStart(boolean coldStart, int number, String id) {
        Session.Builder builder = Session.newBuilder();
        if (this.powerService.getLatestBatteryLevel().isPresent()) {
            builder.withStartingBatteryLevel(((Float)this.powerService.getLatestBatteryLevel().get()).floatValue());
        }
        Session session = builder.withSessionId(id).withStartTime(System.currentTimeMillis()).withNumber(number).withColdStart(coldStart).withSessionType(SESSION_START_TYPE).build();
        return SessionMessage.newBuilder().withSession(session).withDeviceInfo(this.metadataService.getDeviceInfo()).withAppInfo(this.metadataService.getAppInfo()).build();
    }

    private SessionMessage sessionCache(Session session) {
        return null;
    }

    private SessionMessage sessionEnd(Session session, boolean endedCleanly) {
        Long startTime = session.getStartTime();
        long endTime = System.currentTimeMillis();
        Session newSession = Session.newBuilder(session).withEndTime(endTime).withEndedCleanly(endedCleanly).withLastState(this.getApplicationState()).withSessionType(SESSION_END_TYPE).withStoryIds(this.eventService.findStoryIds(startTime, endTime)).withInfoLogIds(this.remoteLogger.findInfoLogIds(startTime, endTime)).withWarningLogIds(this.remoteLogger.findWarningLogIds(startTime, endTime)).withErrorLogIds(this.remoteLogger.findErrorLogIds(startTime, endTime)).withLastHeartbeatTime(this.sessionLastSaved).build();
        return SessionMessage.newBuilder().withUserInfo(this.userService.getUserInfo()).withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withPerformanceInfo(this.metadataService.getSessionPerformanceInfo(startTime, endTime)).withBreadcrumbs(this.breadcrumbService.getBreadcrumbs(startTime, endTime, 100)).withSession(newSession).build();
    }

    private String getApplicationState() {
        if (this.activityService.isInBackground()) {
            return APPLICATION_STATE_BACKGROUND;
        }
        return APPLICATION_STATE_ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackground() {
        Object object = this.lock;
        synchronized (object) {
            this.metadataService.pause();
            if (this.activeSession != null) {
                if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
                    EmbraceLogger.logWarning("Session messages disabled. Ignoring all Sessions.");
                    return;
                }
                SessionMessage sessionMessage = this.sessionEnd(this.activeSession, true);
                this.activeSession = null;
                this.metadataService.setActiveSessionId(null);
                try {
                    this.apiClient.sendSession(sessionMessage).get();
                }
                catch (Exception ex) {
                    EmbraceLogger.logError("Failed to send session end message", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(boolean coldStart, boolean appInForeground, long startupTime) {
        Object object = this.lock;
        synchronized (object) {
            this.metadataService.resume();
            this.startSession(coldStart);
            this.addViewBreadcrumbForResumedSession();
        }
    }

    private void addViewBreadcrumbForResumedSession() {
        Optional<String> screen = this.breadcrumbService.getLastViewBreadcrumbScreenName();
        if (screen.isPresent()) {
            this.breadcrumbService.forceLogView((String)screen.orNull(), System.currentTimeMillis());
        }
    }
}

