/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MessageType;
import java.util.Set;
import java.util.regex.Pattern;
import java9.util.stream.StreamSupport;

final class EmbraceConfigService
implements ConfigService,
ActivityListener {
    private static final long CONFIG_TTL = 3600000L;
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("SDK Configuration");
    private final ApiClient apiClient;
    private final Object lock = new Object();
    private volatile Config config = Config.ofDefault();
    private volatile long lastUpdated;

    public EmbraceConfigService(ApiClient apiClient, EmbraceActivityService activityService) {
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        ((EmbraceActivityService)Preconditions.checkNotNull((Object)activityService)).addListener(this);
    }

    @Override
    public Config getConfig() {
        if (this.configRequiresRefresh()) {
            this.worker.submit(() -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.configRequiresRefresh()) {
                        try {
                            this.config = this.apiClient.getConfig().get();
                            this.lastUpdated = System.currentTimeMillis();
                        }
                        catch (Exception ex) {
                            EmbraceLogger.logWarning("Failed to load SDK config from the server", ex);
                        }
                    }
                    return this.config;
                }
            });
        }
        return this.config;
    }

    @Override
    public boolean isScreenshotDisabledForEvent(String eventName) {
        return this.doesStringMatchesPatternInSet(eventName, this.config.getDisabledScreenshotPatterns());
    }

    @Override
    public boolean isEventDisabled(String eventName) {
        return this.doesStringMatchesPatternInSet(eventName, this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public boolean isLogMessageDisabled(String logMessage) {
        return this.doesStringMatchesPatternInSet(logMessage, this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public boolean isMessageTypeDisabled(MessageType type) {
        return this.doesStringMatchesPatternInSet(type.name().toLowerCase(), this.config.getDisabledEventAndLogPatterns());
    }

    @Override
    public void onResume(boolean coldStart, boolean appInForeground, long startupTime) {
        this.getConfig();
    }

    private boolean doesStringMatchesPatternInSet(String string, Set<String> patternSet) {
        return StreamSupport.stream(patternSet).map(Pattern::compile).anyMatch(p -> p.matcher(string).matches());
    }

    private boolean configRequiresRefresh() {
        return System.currentTimeMillis() - this.lastUpdated > 3600000L;
    }
}

