/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.strings.Charsets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import io.embrace.android.embracesdk.ApiRequest;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;

class ApiClient {
    static final int MESSAGE_VERSION = 13;
    private static final int CONFIG_API_VERSION = 2;
    private static final int API_VERSION = 1;
    private static final String DATA_DEV_PREFIX = "https://data-dev.emb-api.com";
    private static final String DATA_PROD_PREFIX = "https://data.emb-api.com";
    private static final String SCREENSHOT_URL_FORMAT = "%s/%s/%s/%s.jpg";
    private static final String URL_FORMAT = "%s/v%s/%s";
    private static final String CONFIG_URL_FORMAT = "%s?appId=%s&osVersion=%s&appVersion=%s&deviceId=%s";
    private static final String STORY_ID_HEADER_FORMAT = "%s:%s";
    private static final String SCREENSHOT_URL = String.format("%s/v%s/%s", "https://images.emb-api.com", 1, "screenshot");
    private final String dataUrlPrefix;
    private final String appId;
    private final String deviceId;
    private final String operatingSystemCode = String.format(Locale.US, "%d.0.0", MetadataUtils.getOperatingSystemVersionCode());
    private final String appVersion;
    private final BackgroundWorker worker = BackgroundWorker.ofSingleThread("API Client");
    private final Gson gson = new Gson();

    public ApiClient(MetadataService metadataService) {
        this.dataUrlPrefix = metadataService.isDebug() ? DATA_DEV_PREFIX : DATA_PROD_PREFIX;
        this.appId = metadataService.getAppId();
        this.appVersion = (String)metadataService.getAppVersionCodeForRequest().or((Object)"");
        this.deviceId = metadataService.getDeviceId();
    }

    Future<Config> getConfig() {
        String base = String.format(URL_FORMAT, "https://config.emb-api.com", 2, "config");
        String url = String.format(CONFIG_URL_FORMAT, base, this.appId, this.operatingSystemCode, this.appVersion, this.deviceId);
        HttpURLConnection connection = ApiRequest.newBuilder().withHttpMethod(HttpMethod.GET).withUrl(Unchecked.wrap(() -> new URL(url))).build().toConection();
        return this.worker.submit(() -> {
            connection.connect();
            return this.httpCall(connection, Config.class);
        });
    }

    Future<String> sendLogScreenshot(byte[] screenshot, String logId) {
        URL url = Unchecked.wrap(() -> new URL(String.format(SCREENSHOT_URL_FORMAT, SCREENSHOT_URL, this.appId, "logs", logId)));
        ApiRequest request = this.screenshotBuilder(url).withLogId(logId).build();
        return this.sendScreenshot(request, screenshot);
    }

    Future<String> sendMomentScreenshot(byte[] screenshot, String storyId) {
        URL url = Unchecked.wrap(() -> new URL(String.format(SCREENSHOT_URL_FORMAT, SCREENSHOT_URL, this.appId, "moments", storyId)));
        ApiRequest request = this.screenshotBuilder(url).withStoryId(storyId).build();
        return this.sendScreenshot(request, screenshot);
    }

    Future<String> sendSession(SessionMessage sessionMessage) {
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/sessions")));
        ApiRequest request = this.eventBuilder(url).withDeviceId(this.deviceId).withAppId(this.appId).withUrl(url).withHttpMethod(HttpMethod.POST).withContentEncoding("gzip").build();
        byte[] json = this.gson.toJson((Object)sessionMessage).getBytes(Charsets.UTF_8);
        return this.worker.submit(() -> {
            HttpURLConnection connection = request.toConection();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(ApiClient.gzip(json));
            connection.connect();
            return this.httpCall(connection);
        });
    }

    Future<String> sendLogs(EventMessage eventMessage) {
        Preconditions.checkNotNull((Object)eventMessage.getEvent(), (Object)"event must be set");
        Event event = eventMessage.getEvent();
        Preconditions.checkNotNull((Object)((Object)event.getType()), (Object)"event type must be set");
        Preconditions.checkNotNull((Object)event.getStoryId(), (Object)"event storyId must be set");
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/logging")));
        String abbreviation = event.getType().getAbbreviation();
        String storyIdentifier = String.format(STORY_ID_HEADER_FORMAT, abbreviation, event.getStoryId());
        ApiRequest request = this.eventBuilder(url).withLogId(storyIdentifier).build();
        return this.sendEvent(eventMessage, request);
    }

    Future<String> sendEvent(EventMessage eventMessage) {
        Preconditions.checkNotNull((Object)eventMessage.getEvent(), (Object)"event must be set");
        Event event = eventMessage.getEvent();
        Preconditions.checkNotNull((Object)((Object)event.getType()), (Object)"event type must be set");
        Preconditions.checkNotNull((Object)event.getStoryId(), (Object)"event storyId must be set");
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/events")));
        String abbreviation = event.getType().getAbbreviation();
        String storyIdentifier = String.format(STORY_ID_HEADER_FORMAT, abbreviation, event.getStoryId());
        ApiRequest request = this.eventBuilder(url).withStoryId(storyIdentifier).build();
        return this.sendEvent(eventMessage, request);
    }

    private Future<String> sendEvent(EventMessage eventMessage, ApiRequest request) {
        byte[] json = this.gson.toJson((Object)eventMessage).getBytes(Charsets.UTF_8);
        return this.worker.submit(() -> {
            HttpURLConnection connection = request.toConection();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(ApiClient.gzip(json));
            connection.connect();
            return this.httpCall(connection);
        });
    }

    Future<String> sendUser(UserInfo user) {
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "log/users")));
        ApiRequest request = this.eventBuilder(url).withDeviceId(this.deviceId).withAppId(this.appId).withUrl(url).withHttpMethod(HttpMethod.POST).withContentEncoding("gzip").build();
        byte[] json = this.gson.toJson((Object)user).getBytes(Charsets.UTF_8);
        return this.worker.submit(() -> {
            HttpURLConnection connection = request.toConection();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(ApiClient.gzip(json));
            connection.connect();
            return this.httpCall(connection);
        });
    }

    void sendDebugMessages() {
        URL url = Unchecked.wrap(() -> new URL(String.format(URL_FORMAT, this.dataUrlPrefix, 1, "debugMessages")));
    }

    private static byte[] gzip(byte[] bytes) {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream os = null;
        try {
            baos = new ByteArrayOutputStream();
            os = new GZIPOutputStream(baos);
            os.write(bytes);
            os.finish();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close streams when gzipping payload", ex);
            }
        }
    }

    private <T> T httpCall(HttpURLConnection connection, Class<T> clazz) {
        this.handleHttpResponseCode(connection);
        return this.readJsonObject(connection, clazz);
    }

    private String httpCall(HttpURLConnection connection) {
        this.handleHttpResponseCode(connection);
        return Unchecked.wrap(() -> this.readString(connection.getInputStream()));
    }

    private void handleHttpResponseCode(HttpURLConnection connection) {
        Integer responseCode = null;
        try {
            responseCode = connection.getResponseCode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (responseCode == null || responseCode != 200) {
            if (responseCode != null) {
                String errorMessage = this.readString(connection.getErrorStream());
                EmbraceLogger.logWarning("Embrace API request failed. HTTP response code: " + responseCode + ", message: " + errorMessage);
            }
            throw new IllegalStateException("Failed to retrieve from Embrace server.");
        }
    }

    private <T> T readJsonObject(HttpURLConnection connection, Class<T> clazz) {
        InputStreamReader inputStreamReader = null;
        JsonReader reader = null;
        try {
            inputStreamReader = new InputStreamReader(connection.getInputStream());
            reader = new JsonReader((Reader)inputStreamReader);
            Object object = this.gson.fromJson(reader, clazz);
            return (T)object;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close HTTP reader", ex);
            }
        }
    }

    private String readString(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            int len;
            inputStreamReader = new InputStreamReader(inputStream);
            reader = new BufferedReader(inputStreamReader);
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw Unchecked.propagate(ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException ex) {
                EmbraceLogger.logWarning("Failed to close HTTP reader", ex);
            }
        }
    }

    private ApiRequest.Builder screenshotBuilder(URL url) {
        return ApiRequest.newBuilder().withContentType("application/octet-stream").withHttpMethod(HttpMethod.POST).withAppId(this.appId).withDeviceId(this.deviceId).withUrl(url);
    }

    private ApiRequest.Builder eventBuilder(URL url) {
        return ApiRequest.newBuilder().withUrl(url).withHttpMethod(HttpMethod.POST).withAppId(this.appId).withDeviceId(this.deviceId).withContentEncoding("gzip");
    }

    private Future<String> sendScreenshot(ApiRequest request, byte[] screenshot) {
        return this.worker.submit(() -> {
            HttpURLConnection connection = request.toConection();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(screenshot);
            connection.connect();
            return this.httpCall(connection);
        });
    }
}

