/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.ui.view.customViews;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.sdk.getidlib.R;
import com.sdk.getidlib.ui.view.customViews.OnRecordListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0006\u00108\u001a\u00020\nJ\u001a\u00109\u001a\u00020:2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010;\u001a\u00020 H\u0016J\u0010\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020>H\u0014J\u0018\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\nH\u0014J\u0010\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020 H\u0016J\b\u0010F\u001a\u00020GH\u0002J\u0018\u0010H\u001a\u00020:2\u0006\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020\u0016H\u0002J\u000e\u0010K\u001a\u00020:2\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010L\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010M\u001a\u00020:2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u000e\u0010N\u001a\u00020:2\u0006\u00102\u001a\u000203J\b\u0010O\u001a\u00020:H\u0016J\b\u0010P\u001a\u00020:H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0012\"\u0004\b#\u0010\u0014R\u001a\u0010$\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R\u001a\u0010'\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014R\u0010\u0010*\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0012\"\u0004\b.\u0010\u0014R\u001a\u0010/\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/sdk/getidlib/ui/view/customViews/RecordButton;", "Landroid/view/View;", "Landroid/graphics/drawable/Animatable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "bitmap", "Landroid/graphics/Bitmap;", "buttonColor", "getButtonColor", "()I", "setButtonColor", "(I)V", "<set-?>", "", "buttonGap", "getButtonGap", "()F", "buttonPaint", "Landroid/graphics/Paint;", "buttonRadius", "getButtonRadius", "currentMilliSecond", "isRecording", "", "maxMilliSecond", "getMaxMilliSecond", "setMaxMilliSecond", "progressColor", "getProgressColor", "setProgressColor", "progressEmptyColor", "getProgressEmptyColor", "setProgressEmptyColor", "progressEmptyPaint", "progressPaint", "progressStroke", "getProgressStroke", "setProgressStroke", "recordIcon", "getRecordIcon", "setRecordIcon", "recordListener", "Lcom/sdk/getidlib/ui/view/customViews/OnRecordListener;", "rectF", "Landroid/graphics/RectF;", "startAngle", "sweepAngle", "getCurrentMiliSecond", "init", "", "isRunning", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "performClick", "progressAnimate", "Landroid/animation/ObjectAnimator;", "scaleAnimation", "scaleX", "scaleY", "setButtonGap", "setButtonRadius", "setCurrentMilliSecond", "setRecordListener", "start", "stop", "getidlib_release"})
public final class RecordButton
extends View
implements Animatable {
    @Nullable
    private Paint buttonPaint;
    @Nullable
    private Paint progressEmptyPaint;
    @Nullable
    private Paint progressPaint;
    @Nullable
    private RectF rectF;
    @Nullable
    private Bitmap bitmap;
    private float buttonRadius;
    private int progressStroke;
    private float buttonGap;
    private int buttonColor;
    private int progressEmptyColor;
    private int progressColor;
    private int recordIcon;
    private boolean isRecording;
    private int currentMilliSecond;
    private int maxMilliSecond;
    private final int startAngle;
    private int sweepAngle;
    @Nullable
    private OnRecordListener recordListener;

    public final float getButtonRadius() {
        return this.buttonRadius;
    }

    public final int getProgressStroke() {
        return this.progressStroke;
    }

    public final void setProgressStroke(int n) {
        this.progressStroke = n;
    }

    public final float getButtonGap() {
        return this.buttonGap;
    }

    public final int getButtonColor() {
        return this.buttonColor;
    }

    public final void setButtonColor(int n) {
        this.buttonColor = n;
    }

    public final int getProgressEmptyColor() {
        return this.progressEmptyColor;
    }

    public final void setProgressEmptyColor(int n) {
        this.progressEmptyColor = n;
    }

    public final int getProgressColor() {
        return this.progressColor;
    }

    public final void setProgressColor(int n) {
        this.progressColor = n;
    }

    public final int getRecordIcon() {
        return this.recordIcon;
    }

    public final void setRecordIcon(int n) {
        this.recordIcon = n;
    }

    public final int getMaxMilliSecond() {
        return this.maxMilliSecond;
    }

    public final void setMaxMilliSecond(int n) {
        this.maxMilliSecond = n;
    }

    public RecordButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.startAngle = 270;
        this.init(context, null);
    }

    public RecordButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.startAngle = 270;
        this.init(context, attrs);
    }

    public RecordButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.startAngle = 270;
        this.init(context, attrs);
    }

    public RecordButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.startAngle = 270;
        this.init(context, attrs);
    }

    private final void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RecordButton);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026R.styleable.RecordButton)");
        TypedArray resource = typedArray;
        this.buttonRadius = resource.getDimension(R.styleable.RecordButton_buttonRadius, this.getResources().getDisplayMetrics().scaledDensity * 40.0f);
        this.progressStroke = resource.getInt(R.styleable.RecordButton_progressStroke, 10);
        this.buttonGap = resource.getDimension(R.styleable.RecordButton_buttonGap, this.getResources().getDisplayMetrics().scaledDensity * 8.0f);
        this.buttonColor = resource.getColor(R.styleable.RecordButton_buttonColor, -65536);
        this.progressEmptyColor = resource.getColor(R.styleable.RecordButton_progressEmptyColor, -3355444);
        this.progressColor = resource.getColor(R.styleable.RecordButton_progressColor, -16776961);
        this.recordIcon = resource.getResourceId(R.styleable.RecordButton_recordIcon, -1);
        this.maxMilliSecond = resource.getInt(R.styleable.RecordButton_maxMillisecond, 5000);
        resource.recycle();
        this.buttonPaint = new Paint(1);
        typedArray = this.buttonPaint;
        if (typedArray != null) {
            typedArray.setColor(this.buttonColor);
        }
        typedArray = this.buttonPaint;
        if (typedArray != null) {
            typedArray.setStyle(Paint.Style.FILL);
        }
        this.progressEmptyPaint = new Paint(1);
        typedArray = this.progressEmptyPaint;
        if (typedArray != null) {
            typedArray.setColor(this.progressEmptyColor);
        }
        typedArray = this.progressEmptyPaint;
        if (typedArray != null) {
            typedArray.setStyle(Paint.Style.STROKE);
        }
        typedArray = this.progressEmptyPaint;
        if (typedArray != null) {
            typedArray.setStrokeWidth((float)this.progressStroke);
        }
        this.progressPaint = new Paint(1);
        typedArray = this.progressPaint;
        if (typedArray != null) {
            typedArray.setColor(this.progressColor);
        }
        typedArray = this.progressPaint;
        if (typedArray != null) {
            typedArray.setStyle(Paint.Style.STROKE);
        }
        typedArray = this.progressPaint;
        if (typedArray != null) {
            typedArray.setStrokeWidth((float)this.progressStroke);
        }
        typedArray = this.progressPaint;
        if (typedArray != null) {
            typedArray.setStrokeCap(Paint.Cap.ROUND);
        }
        this.rectF = new RectF();
        this.bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.recordIcon);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        float f = cx;
        float f2 = cy;
        Paint paint = this.buttonPaint;
        Intrinsics.checkNotNull((Object)paint);
        canvas.drawCircle(f, f2, this.buttonRadius, paint);
        float f3 = cx;
        float f4 = cy;
        Paint paint2 = this.progressEmptyPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f3, f4, this.buttonRadius + this.buttonGap, paint2);
        if (this.recordIcon != -1) {
            Bitmap bitmap = this.bitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            Bitmap bitmap2 = this.bitmap;
            Intrinsics.checkNotNull((Object)bitmap2);
            float f5 = cx - bitmap2.getHeight() / 2;
            Bitmap bitmap3 = this.bitmap;
            Intrinsics.checkNotNull((Object)bitmap3);
            canvas.drawBitmap(bitmap, f5, (float)(cy - bitmap3.getWidth() / 2), null);
        }
        this.sweepAngle = 360 * this.currentMilliSecond / this.maxMilliSecond;
        RectF rectF = this.rectF;
        if (rectF != null) {
            rectF.set((float)cx - this.buttonRadius - this.buttonGap, (float)cy - this.buttonRadius - this.buttonGap, (float)cx + this.buttonRadius + this.buttonGap, (float)cy + this.buttonRadius + this.buttonGap);
        }
        RectF rectF2 = this.rectF;
        Intrinsics.checkNotNull((Object)rectF2);
        float f6 = this.startAngle;
        float f7 = this.sweepAngle;
        Paint paint3 = this.progressPaint;
        Intrinsics.checkNotNull((Object)paint3);
        canvas.drawArc(rectF2, f6, f7, false, paint3);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        int size = (int)this.buttonRadius * 2 + (int)this.buttonGap * 2 + this.progressStroke + 30;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int n4 = widthMode;
        switch (n4) {
            case 0x40000000: {
                n3 = widthSize;
                break;
            }
            case -2147483648: {
                n2 = 0;
                n3 = Math.min(size, widthSize);
                break;
            }
            case 0: {
                n3 = size;
                break;
            }
            default: {
                n3 = size;
            }
        }
        int width = n3;
        n2 = heightMode;
        switch (n2) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                boolean bl = false;
                n = Math.min(size, heightSize);
                break;
            }
            case 0: {
                n = size;
                break;
            }
            default: {
                n = size;
            }
        }
        int height = n;
        this.setMeasuredDimension(width, height);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = event.getAction();
        if (n == 0) {
            this.performClick();
            return true;
        }
        return false;
    }

    public boolean performClick() {
        if (!super.performClick()) {
            return false;
        }
        if (this.isRecording) {
            this.setEnabled(false);
            this.stop();
            this.progressAnimate().end();
        } else {
            this.start();
            this.progressAnimate().start();
        }
        return true;
    }

    public void start() {
        this.isRecording = true;
        this.scaleAnimation(1.1f, 1.1f);
    }

    public void stop() {
        this.isRecording = false;
        this.currentMilliSecond = 0;
        this.scaleAnimation(1.0f, 1.0f);
    }

    public boolean isRunning() {
        return this.isRecording;
    }

    private final void scaleAnimation(float scaleX, float scaleY) {
        this.animate().scaleX(scaleX).scaleY(scaleY).start();
    }

    private final ObjectAnimator progressAnimate() {
        int[] nArray = new int[]{this.currentMilliSecond, this.maxMilliSecond};
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), (String)"progress", (int[])nArray);
        animator.addUpdateListener(arg_0 -> RecordButton.progressAnimate$lambda-0(this, arg_0));
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setDuration((long)this.maxMilliSecond);
        Intrinsics.checkNotNullExpressionValue((Object)animator, (String)"animator");
        return animator;
    }

    private final void setCurrentMilliSecond(int currentMilliSecond) {
        this.currentMilliSecond = currentMilliSecond;
        this.postInvalidate();
    }

    public final int getCurrentMiliSecond() {
        return this.currentMilliSecond;
    }

    public final void setButtonRadius(int buttonRadius) {
        this.buttonRadius = buttonRadius;
    }

    public final void setButtonGap(int buttonGap) {
        this.buttonGap = buttonGap;
    }

    public final void setRecordListener(@NotNull OnRecordListener recordListener) {
        Intrinsics.checkNotNullParameter((Object)recordListener, (String)"recordListener");
        this.recordListener = recordListener;
    }

    private static final void progressAnimate$lambda-0(RecordButton this$0, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = animation.getAnimatedValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        int value = (Integer)object;
        if (this$0.isRecording && value == 0 && this$0.recordListener != null && (object = this$0.recordListener) != null) {
            object.onRecordStart();
        }
        if (this$0.isRecording) {
            this$0.setCurrentMilliSecond(value);
            if (this$0.recordListener != null && (object = this$0.recordListener) != null) {
                object.onRecord();
            }
        } else {
            animation.cancel();
            this$0.isRecording = false;
            if (this$0.recordListener != null && (object = this$0.recordListener) != null) {
                object.onRecordCancel();
            }
        }
        if (value == this$0.getMaxMilliSecond()) {
            if (this$0.recordListener != null && (object = this$0.recordListener) != null) {
                object.onRecordFinish();
            }
            this$0.stop();
        }
    }
}

