/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.ui.global;

import android.content.Context;
import android.widget.Toast;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.viewbinding.ViewBinding;
import com.sdk.getidlib.R;
import com.sdk.getidlib.app.navigation.NavigatorListener;
import com.sdk.getidlib.app.navigation.SupportFragmentNavigator;
import com.sdk.getidlib.presentation.global.BaseContract;
import com.sdk.getidlib.ui.dialog.message.MessageDialog;
import com.sdk.getidlib.ui.global.BaseActivity;
import com.sdk.getidlib.ui.global.ViewBindingActivity;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.terrakok.cicerone.Navigator;
import ru.terrakok.cicerone.NavigatorHolder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\b \u0018\u0000 ,*\b\b\u0000\u0010\u0001*\u00020\u0002*\f\b\u0001\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u00062\u00020\u0007:\u0001,B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\b\u0010\u001c\u001a\u00020\u0019H\u0004J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0014J\b\u0010!\u001a\u00020\u0019H\u0014J\b\u0010\"\u001a\u00020\u0019H\u0014J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020\u0019H\u0004J\u0012\u0010&\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u001bH\u0016J\u0012\u0010(\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u001bH\u0016J\u0012\u0010+\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u0011\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lcom/sdk/getidlib/ui/global/BaseActivity;", "VB", "Landroidx/viewbinding/ViewBinding;", "T", "Lcom/sdk/getidlib/presentation/global/BaseContract$Presenter;", "Lcom/sdk/getidlib/ui/global/ViewBindingActivity;", "Lcom/sdk/getidlib/presentation/global/BaseContract$View;", "Lcom/sdk/getidlib/app/navigation/NavigatorListener;", "()V", "fragmentNavigator", "Lru/terrakok/cicerone/Navigator;", "navigatorHolder", "Lru/terrakok/cicerone/NavigatorHolder;", "getNavigatorHolder", "()Lru/terrakok/cicerone/NavigatorHolder;", "navigatorHolder$delegate", "Lkotlin/Lazy;", "presenter", "getPresenter", "()Lcom/sdk/getidlib/presentation/global/BaseContract$Presenter;", "viewContext", "Landroid/content/Context;", "getViewContext", "()Landroid/content/Context;", "changeStatusBarColor", "", "color", "", "clearBackStackFragments", "currentScreen", "screenKey", "", "onDestroy", "onPause", "onResume", "setAgreeButtonTitle", "title", "setupFragmentManager", "showError", "errorMessage", "showLongToast", "resID", "message", "showToast", "Companion", "getidlib_release"})
public abstract class BaseActivity<VB extends ViewBinding, T extends BaseContract.Presenter<?>>
extends ViewBindingActivity<VB>
implements BaseContract.View,
NavigatorListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy navigatorHolder$delegate = LazyKt.lazy((Function0)navigatorHolder.2.INSTANCE);
    private Navigator fragmentNavigator;
    @NotNull
    public static final String ERROR_DIALOG_TAG = "error_dialog";

    private final NavigatorHolder getNavigatorHolder() {
        Lazy lazy = this.navigatorHolder$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (NavigatorHolder)lazy.getValue();
    }

    @Override
    @Nullable
    public Context getViewContext() {
        return (Context)this;
    }

    @NotNull
    public abstract T getPresenter();

    protected void onResume() {
        Navigator navigator;
        super.onResume();
        NavigatorHolder navigatorHolder2 = this.getNavigatorHolder();
        Navigator navigator2 = this.fragmentNavigator;
        if (navigator2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fragmentNavigator");
            navigator = null;
        } else {
            navigator = navigator2;
        }
        navigatorHolder2.setNavigator(navigator);
    }

    protected void onPause() {
        this.getNavigatorHolder().removeNavigator();
        this.overridePendingTransition(0, R.anim.exit_to_end);
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        this.getPresenter().onStop();
        super.onDestroy();
    }

    @Override
    public void showError(@Nullable String errorMessage) {
        CharSequence charSequence = errorMessage;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String string2 = this.getString(R.string.error);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.error)");
        String header = string2;
        MessageDialog.Companion.newInstance$default(MessageDialog.Companion, header, errorMessage, null, 4, null).show(this.getSupportFragmentManager(), ERROR_DIALOG_TAG);
    }

    @Override
    public void showToast(@Nullable String message) {
        CharSequence charSequence = message;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        Toast.makeText((Context)((Context)this), (CharSequence)message, (int)0).show();
    }

    @Override
    public void showToast(int resID) {
        String string2 = this.getString(resID);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(resID)");
        String message = string2;
        this.showToast(message);
    }

    @Override
    public void showLongToast(@Nullable String message) {
        CharSequence charSequence = message;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        Toast.makeText((Context)((Context)this), (CharSequence)message, (int)1).show();
    }

    @Override
    public void showLongToast(int resID) {
        String string2 = this.getString(resID);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(resID)");
        String message = string2;
        this.showLongToast(message);
    }

    @Override
    public void currentScreen(@NotNull String screenKey) {
        Intrinsics.checkNotNullParameter((Object)screenKey, (String)"screenKey");
    }

    @Override
    public void setAgreeButtonTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
    }

    protected final void clearBackStackFragments() {
        int n = 0;
        int n2 = this.getSupportFragmentManager().getBackStackEntryCount();
        if (n < n2) {
            do {
                int i = n++;
                this.getSupportFragmentManager().popBackStack();
            } while (n < n2);
        }
    }

    protected final void setupFragmentManager() {
        SupportFragmentNavigator supportFragmentNavigator = new SupportFragmentNavigator();
        FragmentActivity fragmentActivity = (FragmentActivity)this;
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"supportFragmentManager");
        this.fragmentNavigator = (Navigator)supportFragmentNavigator.initNavigator(fragmentActivity, fragmentManager, this);
    }

    protected final void changeStatusBarColor(int color) {
        this.getWindow().addFlags(Integer.MIN_VALUE);
        this.getWindow().setStatusBarColor(color);
    }

    @Override
    public void showErrorDialog(@NotNull String header, @NotNull String description) {
        BaseContract.View.DefaultImpls.showErrorDialog(this, header, description);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/sdk/getidlib/ui/global/BaseActivity$Companion;", "", "()V", "ERROR_DIALOG_TAG", "", "getidlib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

