/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.selfie;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.PhotoEnum;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.app.utils.FileEncodeUtils;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.entity.base.BaseResponse;
import com.sdk.getidlib.model.entity.events.GetIDError;
import com.sdk.getidlib.model.entity.selfie.SelfieData;
import com.sdk.getidlib.presentation.features.selfie.SelfieContract;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\u001a\u0010$\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020\u001fH\u0016J\b\u0010*\u001a\u00020\u001fH\u0016J\b\u0010+\u001a\u00020\u001fH\u0016J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lcom/sdk/getidlib/presentation/features/selfie/SelfiePresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/selfie/SelfieContract$View;", "Lcom/sdk/getidlib/presentation/features/selfie/SelfieContract$Presenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "documentRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "(Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;)V", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "imageSelfie", "Landroid/graphics/Bitmap;", "isRequestInProgress", "", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/selfie/SelfieContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/selfie/SelfieContract$View;)V", "changeToolbarTitle", "", "cleanPreviouslyTakenImage", "isRTL", "onCaptureClicked", "onClickToGoSettings", "onPictureTaken", "image", "context", "Landroid/content/Context;", "onRetakeClicked", "onStart", "onUsePhotoClicked", "permissionDenied", "saveImage", "showPreview", "getidlib_release"})
public final class SelfiePresenter
extends BasePresenterImpl<SelfieContract.View>
implements SelfieContract.Presenter {
    @NotNull
    private final PhotoRepository repository;
    @NotNull
    private final DocumentTypeRepository documentRepository;
    public SelfieContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;
    @Nullable
    private Bitmap imageSelfie;
    private boolean isRequestInProgress;

    public SelfiePresenter(@NotNull PhotoRepository repository, @NotNull DocumentTypeRepository documentRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)documentRepository, (String)"documentRepository");
        this.repository = repository;
        this.documentRepository = documentRepository;
        this.flowScreen = Screens.Selfie.INSTANCE.getScreenKey();
        this.eventScreenName = "selfie";
        File file = this.repository.getSelfieMediaPic();
        this.imageSelfie = BitmapFactory.decodeFile((String)(file == null ? null : file.getPath()));
    }

    @Override
    @NotNull
    public SelfieContract.View getView() {
        SelfieContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull SelfieContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        super.onStart();
        SelfieContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        SelfieContract.View $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
        this.changeToolbarTitle();
        view = this.imageSelfie;
        if (view != null) {
            SelfieContract.View view2 = view;
            bl2 = false;
            boolean bl4 = false;
            SelfieContract.View it = view2;
            boolean bl5 = false;
            this.showPreview((Bitmap)it);
        }
    }

    @Override
    public void onPictureTaken(@Nullable Bitmap image, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (image == null) {
            return;
        }
        this.saveImage(image, context);
    }

    @Override
    public void permissionDenied() {
        this.getView().changeCameraPermissionLayoutVisibility(true);
    }

    @Override
    public void onClickToGoSettings() {
        this.getView().openAppSettings();
        this.getEventsRepository().verificationFlowFail(GetIDError.DENY_PERMISSION);
        this.getView().finish();
    }

    @Override
    public void onCaptureClicked() {
        SelfieContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        SelfieContract.View $this$onCaptureClicked_u24lambda_u2d2 = view;
        boolean bl3 = false;
        $this$onCaptureClicked_u24lambda_u2d2.showLoading();
        $this$onCaptureClicked_u24lambda_u2d2.takePicture();
        $this$onCaptureClicked_u24lambda_u2d2.blink();
    }

    @Override
    public void onRetakeClicked() {
        this.cleanPreviouslyTakenImage();
        this.getView().changePreviewVisibility(false);
    }

    @Override
    public void onUsePhotoClicked() {
        this.getView().changePreviewVisibility(false);
        this.onClickAgree();
    }

    private final void changeToolbarTitle() {
        this.getView().changeTitleToolbar(Localization.Companion.translation(TranslationKey.SELFIE_SHARED_HEADER));
    }

    private final void saveImage(Bitmap image, Context context) {
        this.imageSelfie = image;
        FileEncodeUtils fileEncodeUtils = new FileEncodeUtils();
        String string2 = context.getFilesDir().getAbsolutePath();
        String string3 = PhotoEnum.SELFIE.name();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        File imageFile = fileEncodeUtils.getImageFile(Intrinsics.stringPlus((String)string2, (Object)string5), image);
        string3 = (Function1)new Function1<Continuation<? super Response<SelfieData>>, Object>(this, imageFile, null){
            int label;
            final /* synthetic */ SelfiePresenter this$0;
            final /* synthetic */ File $imageFile;
            {
                this.this$0 = $receiver;
                this.$imageFile = $imageFile;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SelfiePresenter.access$getRepository$p(this.this$0).checkSelfie(this.$imageFile, (Continuation<? super Response<SelfieData>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Response<SelfieData>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
        bl = false;
        this.doRequest(false, string3, (Function1)new Function1<SelfieData, Unit>(this, imageFile){
            final /* synthetic */ SelfiePresenter this$0;
            final /* synthetic */ File $imageFile;
            {
                this.this$0 = $receiver;
                this.$imageFile = $imageFile;
                super(1);
            }

            public final void invoke(@Nullable SelfieData it) {
                this.this$0.getView().showLoading();
                SelfiePresenter.access$setRequestInProgress$p(this.this$0, true);
                Object object = new IntRange(200, 299);
                Object object2 = it;
                object2 = object2 == null ? null : ((BaseResponse)object2).getResponseCode();
                boolean bl = false;
                if (object2 != null && object.contains(((Integer)object2).intValue())) {
                    object = it;
                    if (Intrinsics.areEqual((Object)(object == null ? null : ((SelfieData)object).getConclusion()), (Object)"ok")) {
                        SelfiePresenter.access$getRepository$p(this.this$0).addFileId(it.getFileId());
                        SelfiePresenter.access$getRepository$p(this.this$0).onUpdateSelfieMediaPic(this.$imageFile);
                        Bitmap bitmap = SelfiePresenter.access$getImageSelfie$p(this.this$0);
                        Intrinsics.checkNotNull((Object)bitmap);
                        SelfiePresenter.access$showPreview(this.this$0, bitmap);
                    } else {
                        this.this$0.getView().showToast(Localization.Companion.translation(TranslationKey.SELFIE_BADPHOTO_NOFACE));
                    }
                } else {
                    this.this$0.getView().showToast(Localization.Companion.translation(TranslationKey.SELFIE_BADPHOTO_NOFACE));
                }
                this.this$0.getView().captureButtonAvailable();
                this.this$0.getView().hideLoading();
                SelfiePresenter.access$setRequestInProgress$p(this.this$0, false);
            }
        });
    }

    @Override
    public boolean isRequestInProgress() {
        return this.isRequestInProgress;
    }

    @Override
    public boolean isRTL() {
        return this.documentRepository.getIsRTL();
    }

    private final SelfieContract.View showPreview(Bitmap image) {
        SelfieContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        SelfieContract.View $this$showPreview_u24lambda_u2d3 = view;
        boolean bl3 = false;
        $this$showPreview_u24lambda_u2d3.changePreviewVisibility(true);
        $this$showPreview_u24lambda_u2d3.showPreviewPicture(image);
        this.getView().hideLoading();
        return view;
    }

    private final void cleanPreviouslyTakenImage() {
        this.imageSelfie = null;
        this.repository.onUpdateSelfieMediaPic(null);
    }

    public static final /* synthetic */ PhotoRepository access$getRepository$p(SelfiePresenter $this) {
        return $this.repository;
    }

    public static final /* synthetic */ void access$setRequestInProgress$p(SelfiePresenter $this, boolean bl) {
        $this.isRequestInProgress = bl;
    }

    public static final /* synthetic */ SelfieContract.View access$showPreview(SelfiePresenter $this, Bitmap image) {
        return $this.showPreview(image);
    }

    public static final /* synthetic */ Bitmap access$getImageSelfie$p(SelfiePresenter $this) {
        return $this.imageSelfie;
    }
}

