/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.photo_document;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.app.utils.FileEncodeUtils;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.events.EventsRepository;
import com.sdk.getidlib.model.data.repository.form.FormRepository;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.entity.documents.DocumentData;
import com.sdk.getidlib.model.entity.documents.FileIds;
import com.sdk.getidlib.presentation.features.photo_document.BasePhotoDocumentPresenter;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0017H\u0016J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0017H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/sdk/getidlib/presentation/features/photo_document/BackPhotoDocumentPresenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/BasePhotoDocumentPresenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "(Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/form/FormRepository;Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;)V", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "imageBackSide", "Landroid/graphics/Bitmap;", "isRequestInProgress", "", "docSidesConclusionBackMissing", "", "docSidesConclusionFrontMissing", "docSidesConclusionOther", "onRetakeClicked", "onStart", "onUsePhotoClicked", "saveImage", "image", "context", "Landroid/content/Context;", "uploadConclusionBackSideMissing", "responseData", "Lcom/sdk/getidlib/model/entity/documents/DocumentData;", "bCanProceed", "uploadConclusionOk", "uploadConclusionOther", "getidlib_release"})
public final class BackPhotoDocumentPresenter
extends BasePhotoDocumentPresenter {
    @Nullable
    private String flowScreen;
    @Nullable
    private String eventScreenName;
    @Nullable
    private Bitmap imageBackSide;
    private boolean isRequestInProgress;

    public BackPhotoDocumentPresenter(@NotNull PhotoRepository repository, @NotNull DocumentTypeRepository documentTypeRepository, @NotNull FormRepository formRepository, @NotNull SetupRepository setupRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        Intrinsics.checkNotNullParameter((Object)formRepository, (String)"formRepository");
        Intrinsics.checkNotNullParameter((Object)setupRepository, (String)"setupRepository");
        super(repository, documentTypeRepository, formRepository, setupRepository);
        this.flowScreen = Screens.BackPhotoDocument.INSTANCE.getScreenKey();
        this.eventScreenName = "back";
        File file = repository.getBackDocumentMedia();
        this.imageBackSide = BitmapFactory.decodeFile((String)(file == null ? null : file.getPath()));
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        String string2;
        int n;
        Object object;
        super.onStart();
        Bitmap bitmap = this.imageBackSide;
        if (bitmap != null) {
            object = bitmap;
            n = 0;
            boolean bl = false;
            Object it = object;
            boolean bl2 = false;
            this.showPreview((Bitmap)it);
        }
        object = this.getDocumentTypeRepository().getComposition();
        n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_SINGLEHEADER_MOBILE);
                break;
            }
            case 2: 
            case 3: {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_BACKHEADER_MOBILE);
                break;
            }
            case 4: {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_TOPPAGEHEADER_MOBILE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String title = string2;
        this.getView().changeTitleToolbar(title);
        EventsRepository eventsRepository2 = this.getEventsRepository();
        String string3 = this.getEventScreenName();
        Intrinsics.checkNotNull((Object)string3);
        eventsRepository2.sendStatusOpenedScreen(string3, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ BackPhotoDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BackPhotoDocumentPresenter.access$showDialogEaAlreadyExists(this.this$0);
            }
        }));
    }

    @Override
    public void onRetakeClicked() {
        this.imageBackSide = null;
        this.getRepository().onUpdateBackDocumentMedia(null);
        this.getView().changePreviewVisibility(false);
    }

    @Override
    public void onUsePhotoClicked() {
        this.getView().showLoading();
        this.isRequestInProgress = true;
        Function1 function1 = (Function1)new Function1<Continuation<? super Response<DocumentData>>, Object>(this, null){
            int label;
            final /* synthetic */ BackPhotoDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getDocumentTypeRepository().sendDocument((Continuation<? super Response<DocumentData>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Response<DocumentData>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
        boolean bl = false;
        this.doRequest(true, function1, (Function1)new Function1<DocumentData, Unit>(this){
            final /* synthetic */ BackPhotoDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable DocumentData it) {
                DocumentData documentData = it;
                Integer n = documentData == null ? null : documentData.getResponseCode();
                documentData = new IntRange(200, 299);
                boolean bl = false;
                if (n != null && documentData.contains(n)) {
                    DocumentData documentData2 = it;
                    Intrinsics.checkNotNull((Object)documentData2);
                    this.this$0.handleConclusion(documentData2, false);
                } else {
                    Integer n2 = n;
                    int n3 = 400;
                    if (n2 != null && n2 == n3) {
                        this.this$0.onRetakeClicked();
                        this.this$0.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_BADREQUEST), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
                    } else {
                        this.this$0.getView().showError("Oops: Something else went wrong");
                    }
                }
                this.this$0.getView().hideLoading();
                BackPhotoDocumentPresenter.access$setRequestInProgress$p(this.this$0, false);
            }
        });
    }

    @Override
    public void docSidesConclusionFrontMissing() {
    }

    @Override
    public void docSidesConclusionBackMissing() {
        this.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGBACKSIDE), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
        this.onRetakeClicked();
    }

    @Override
    public void docSidesConclusionOther() {
        this.onRetakeClicked();
    }

    @Override
    public void uploadConclusionOk(@NotNull DocumentData responseData, boolean bCanProceed) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        FileIds fileIds = responseData.getFileIds();
        this.getDocumentTypeRepository().setFrontId(fileIds == null ? null : fileIds.getFront());
        fileIds = responseData.getFileIds();
        this.getDocumentTypeRepository().setBackId(fileIds == null ? null : fileIds.getBack());
        this.onClickAgree();
    }

    @Override
    public void uploadConclusionBackSideMissing(@NotNull DocumentData responseData, boolean bCanProceed) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        this.onRetakeClicked();
    }

    @Override
    public void uploadConclusionOther() {
        this.onRetakeClicked();
    }

    @Override
    public boolean isRequestInProgress() {
        return this.isRequestInProgress;
    }

    @Override
    public void saveImage(@NotNull Bitmap image, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bitmap bitmap = this.imageBackSide = new FileEncodeUtils().scaleDocumentImage(image);
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap2;
            boolean bl3 = false;
            File imageFile = new FileEncodeUtils().getImageFile(Intrinsics.stringPlus((String)context.getFilesDir().getAbsolutePath(), (Object)"document_image_back"), it);
            this.getRepository().onUpdateBackDocumentMedia(imageFile);
        }
    }

    public static final /* synthetic */ void access$showDialogEaAlreadyExists(BackPhotoDocumentPresenter $this) {
        $this.showDialogEaAlreadyExists();
    }

    public static final /* synthetic */ void access$setRequestInProgress$p(BackPhotoDocumentPresenter $this, boolean bl) {
        $this.isRequestInProgress = bl;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentState.values().length];
            nArray[DocumentState.SINGLE.ordinal()] = 1;
            nArray[DocumentState.FRONT_BACK.ordinal()] = 2;
            nArray[DocumentState.BOOKLET.ordinal()] = 3;
            nArray[DocumentState.TOP_BOTTOM.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

