/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.guidelines;

import android.graphics.Color;
import com.sdk.getidlib.app.common.objects.ThemeInstance;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.presentation.features.guidelines.BaseGuidelineContract;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import com.sdk.getidlib.utils.ColorUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/sdk/getidlib/presentation/features/guidelines/BaseGuidelinePresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/guidelines/BaseGuidelineContract$View;", "Lcom/sdk/getidlib/presentation/features/guidelines/BaseGuidelineContract$Presenter;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "(Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;)V", "getDocumentTypeRepository", "()Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "formTitleScreen", "", "getFormTitleScreen", "()Ljava/lang/String;", "setFormTitleScreen", "(Ljava/lang/String;)V", "titleScreen", "getTitleScreen", "setTitleScreen", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/guidelines/BaseGuidelineContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/guidelines/BaseGuidelineContract$View;)V", "getComposition", "Lcom/sdk/getidlib/presentation/features/photo_document/DocumentState;", "getRgb", "hex", "coef", "", "isRTL", "", "onStart", "", "updateDesignColor", "svg", "getidlib_release"})
public abstract class BaseGuidelinePresenter
extends BasePresenterImpl<BaseGuidelineContract.View>
implements BaseGuidelineContract.Presenter {
    @NotNull
    private final DocumentTypeRepository documentTypeRepository;
    public BaseGuidelineContract.View view;
    @Nullable
    private String formTitleScreen;

    public BaseGuidelinePresenter(@NotNull DocumentTypeRepository documentTypeRepository) {
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        this.documentTypeRepository = documentTypeRepository;
    }

    @NotNull
    public final DocumentTypeRepository getDocumentTypeRepository() {
        return this.documentTypeRepository;
    }

    @Override
    @NotNull
    public BaseGuidelineContract.View getView() {
        BaseGuidelineContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull BaseGuidelineContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @NotNull
    public abstract String getTitleScreen();

    public abstract void setTitleScreen(@NotNull String var1);

    @Override
    public void onStart() {
        super.onStart();
        this.getView().changeToolbarMode(ActionBarMode.BACK);
        this.getView().changeTitleToolbar(this.getTitleScreen());
    }

    @Override
    public boolean isRTL() {
        return this.documentTypeRepository.getIsRTL();
    }

    @Override
    @NotNull
    public DocumentState getComposition() {
        return this.documentTypeRepository.getComposition();
    }

    @Override
    @NotNull
    public String updateDesignColor(@NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)svg, (String)"#9C77E0", (String)this.getRgb(ThemeInstance.Companion.getTheme$getidlib_release().getAccentColor(), 0.9), (boolean)false, (int)4, null), (String)"#4C3B82", (String)this.getRgb(ThemeInstance.Companion.getTheme$getidlib_release().getAccentColor(), 0.5), (boolean)false, (int)4, null), (String)"#30295E", (String)this.getRgb(ThemeInstance.Companion.getTheme$getidlib_release().getAccentColor(), 0.4), (boolean)false, (int)4, null), (String)"#1C1341", (String)this.getRgb(ThemeInstance.Companion.getTheme$getidlib_release().getAccentColor(), 0.4), (boolean)false, (int)4, null), (String)"#47DAAE", (String)this.getRgb(ThemeInstance.Companion.getTheme$getidlib_release().getSuccessColor(), 1.0), (boolean)false, (int)4, null);
    }

    private final String getRgb(String hex, double coef) {
        String string2 = hex;
        Intrinsics.checkNotNull((Object)string2);
        int initColor = ColorUtils.INSTANCE.parse(string2);
        double r = (double)Color.red((int)initColor) * coef;
        double g = (double)Color.green((int)initColor) * coef;
        double b = (double)Color.blue((int)initColor) * coef;
        return "rgb(" + r + ',' + g + ',' + b + ')';
    }
}

