/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.document_type;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.model.app.form.FormField;
import com.sdk.getidlib.model.app.form.FormValueType;
import com.sdk.getidlib.model.app.navigation.ScreenFlowItem;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.entity.countries.Country;
import com.sdk.getidlib.model.entity.countries.Document;
import com.sdk.getidlib.presentation.features.document_type.ChoosingDocumentTypeContract;
import com.sdk.getidlib.presentation.features.document_type.DocumentConverter;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.terrakok.cicerone.Screen;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000eH\u0002J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020 H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010)\u001a\u00020 H\u0002J\b\u0010*\u001a\u00020 H\u0002J\b\u0010+\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020%H\u0016J\b\u0010.\u001a\u00020 H\u0016J\b\u0010/\u001a\u00020 H\u0016J\u0010\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u000eH\u0016J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u000eH\u0016J\u0010\u00104\u001a\u00020 2\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020 H\u0002J\b\u00108\u001a\u00020 H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00069"}, d2={"Lcom/sdk/getidlib/presentation/features/document_type/ChoosingDocumentTypePresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/document_type/ChoosingDocumentTypeContract$View;", "Lcom/sdk/getidlib/presentation/features/document_type/ChoosingDocumentTypeContract$Presenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "photoRepository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "(Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;)V", "currentCountry", "Lcom/sdk/getidlib/model/app/form/FormField;", "docState", "Lcom/sdk/getidlib/presentation/features/photo_document/DocumentState;", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "phoneLocale", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/document_type/ChoosingDocumentTypeContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/document_type/ChoosingDocumentTypeContract$View;)V", "addFlowItem", "", "flowItemKey", "changeAcceptButtonState", "checkToShowDocumentList", "filterCountryCondition", "", "it", "Lcom/sdk/getidlib/model/entity/countries/Country;", "getPhoneTranslatedCountry", "initCurrentCountry", "initDocumentList", "isContainsPhoneCountry", "isCountryTitleDefault", "isRTL", "onClickAgree", "onStart", "selectedCountry", "country", "selectedDocument", "document", "setPhoneLocale", "locale", "Ljava/util/Locale;", "showCountries", "showData", "getidlib_release"})
public final class ChoosingDocumentTypePresenter
extends BasePresenterImpl<ChoosingDocumentTypeContract.View>
implements ChoosingDocumentTypeContract.Presenter {
    @NotNull
    private final DocumentTypeRepository repository;
    @NotNull
    private final PhotoRepository photoRepository;
    public ChoosingDocumentTypeContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;
    @Nullable
    private FormField currentCountry;
    private String phoneLocale;
    @NotNull
    private DocumentState docState;

    public ChoosingDocumentTypePresenter(@NotNull DocumentTypeRepository repository, @NotNull PhotoRepository photoRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)photoRepository, (String)"photoRepository");
        this.repository = repository;
        this.photoRepository = photoRepository;
        this.flowScreen = Screens.ChooseDocumentType.INSTANCE.getScreenKey();
        this.eventScreenName = "document-type";
        this.docState = DocumentState.SINGLE;
    }

    @Override
    @NotNull
    public ChoosingDocumentTypeContract.View getView() {
        ChoosingDocumentTypeContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull ChoosingDocumentTypeContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onStart() {
        void $this$filterTo$iv$iv;
        super.onStart();
        ChoosingDocumentTypeContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
        $this$onStart_u24lambda_u2d0.changeTitleToolbar(Localization.Companion.translation(TranslationKey.DOCUMENT_CHOICE_HEADER));
        this.photoRepository.onUpdateFrontDocumentMedia(null);
        this.photoRepository.onUpdateBackDocumentMedia(null);
        this.showData();
        Iterable $this$filter$iv = this.getFlowRepository().getActiveFlows();
        boolean $i$f$filter = false;
        $this$onStart_u24lambda_u2d0 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScreenFlowItem it = (ScreenFlowItem)element$iv$iv;
            boolean bl4 = false;
            boolean bl5 = !(Intrinsics.areEqual((Object)it.getName(), (Object)Screens.FrontPhotoDocument.INSTANCE.getScreenKey()) || Intrinsics.areEqual((Object)it.getName(), (Object)Screens.FrontGuideline.INSTANCE.getScreenKey()) || Intrinsics.areEqual((Object)it.getName(), (Object)Screens.BackGuideline.INSTANCE.getScreenKey()) || Intrinsics.areEqual((Object)it.getName(), (Object)Screens.BackPhotoDocument.INSTANCE.getScreenKey()) || Intrinsics.areEqual((Object)it.getName(), (Object)Screens.LibraryPhotoDocument.INSTANCE.getScreenKey()));
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ArrayList flowList = (ArrayList)((List)destination$iv$iv);
        this.getFlowRepository().onUpdateFlows(flowList);
    }

    @Override
    public void onClickAgree() {
        Object object = this.getEventScreenName();
        if (object != null) {
            String string2 = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.getEventsRepository().sendStatusLeavedScreen(it, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ChoosingDocumentTypePresenter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ChoosingDocumentTypePresenter.access$showDialogEaAlreadyExists(this.this$0);
                }
            }));
        }
        if (this.repository.getAllowDocumentPhotosFromGallery()) {
            this.navigateToNextFlowScreen();
        } else {
            this.addFlowItem(Screens.FrontPhotoDocument.INSTANCE.getScreenKey());
            if (this.repository.isShowGuideline()) {
                object = this.docState;
                int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
                switch (n) {
                    case 1: {
                        this.navigateTo((Screen)Screens.PassportGuideline.INSTANCE);
                        break;
                    }
                    case 2: {
                        this.navigateTo((Screen)Screens.FrontGuideline.INSTANCE);
                        break;
                    }
                    case 3: {
                        this.navigateTo((Screen)Screens.FrontGuideline.INSTANCE);
                        break;
                    }
                    case 4: {
                        this.navigateTo((Screen)Screens.FrontGuideline.INSTANCE);
                    }
                }
            } else {
                this.navigateToNextFlowScreen();
            }
        }
    }

    private final void addFlowItem(String flowItemKey) {
        List flowList = null;
        ScreenFlowItem flowItem = new ScreenFlowItem(flowItemKey, true, false, null, 12, null);
        flowList = TypeIntrinsics.asMutableList(this.getFlowRepository().getActiveFlows());
        if (!flowList.contains(flowItem)) {
            flowList.add(this.getFlowRepository().getIndexNextScreen(), flowItem);
        }
        this.getFlowRepository().onUpdateFlows(flowList);
    }

    @Override
    public void setPhoneLocale(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string2 = locale.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.toLanguageTag()");
        this.phoneLocale = string2;
    }

    @Override
    public void selectedCountry(@NotNull String country) {
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        this.repository.onUpdateCountry(Localization.Companion.getCountryByName(country));
        this.repository.onUpdateDocument(new Document(null, false, null, 7, null));
        this.initCurrentCountry();
        this.initDocumentList();
        this.checkToShowDocumentList();
    }

    @Override
    public void selectedDocument(@NotNull String document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Document selectedDocument = this.repository.getDocumentByName(document);
        this.repository.onUpdateDocument(selectedDocument);
        this.docState = DocumentConverter.INSTANCE.getDocumentComposition(this.repository.getCountry(), selectedDocument.getName());
        this.repository.setComposition(this.docState);
        this.changeAcceptButtonState();
    }

    @Override
    public boolean isRTL() {
        return this.repository.getIsRTL();
    }

    private final void showData() {
        Collection collection = Localization.Companion.getCountries();
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.initCurrentCountry();
        this.initDocumentList();
        this.showCountries();
        this.checkToShowDocumentList();
    }

    private final void initCurrentCountry() {
        String countryName;
        CharSequence charSequence = this.repository.getCountry().getName();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = countryName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? (this.isContainsPhoneCountry() && this.getPhoneTranslatedCountry() != null ? this.getPhoneTranslatedCountry() : Localization.Companion.translation(TranslationKey.DOCUMENT_CHOICE_COUNTRYPLACEHOLDER)) : this.repository.getCountry().getName();
        Intrinsics.checkNotNull((Object)string2);
        this.currentCountry = new FormField(string2, FormValueType.COUNTRY, null, null, null, null, false, false, null, null, 1020, null);
    }

    private final boolean isContainsPhoneCountry() {
        Iterator<Country> $this$forEach$iv = Localization.Companion.getCountries().iterator();
        boolean $i$f$forEach = false;
        Iterator<Country> iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator<Country> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Country element$iv;
            Country it = element$iv = iterator2.next();
            boolean bl2 = false;
            Object object = it.getName();
            boolean bl3 = false;
            if (!(object.length() > 0)) continue;
            CharSequence charSequence = it.getCountry();
            object = Locale.getDefault().getISO3Country();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefault().isO3Country");
            if (!StringsKt.contains((CharSequence)charSequence, (CharSequence)object, (boolean)true)) continue;
            object = it.getDocumentTypes();
            bl3 = false;
            boolean bl4 = false;
            return !(object == null || object.isEmpty());
        }
        return false;
    }

    private final String getPhoneTranslatedCountry() {
        Object v0;
        block1: {
            Iterable iterable = Localization.Companion.getCountries();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Country it = (Country)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getCountry(), (Object)Locale.getDefault().getISO3Country())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Country country = v0;
        return country == null ? null : country.getName();
    }

    private final void initDocumentList() {
        Iterator<String> iterator;
        Object v0;
        List<String> list;
        ArrayList<Document> documentList;
        block4: {
            if (this.isCountryTitleDefault()) {
                return;
            }
            documentList = null;
            documentList = new ArrayList<Document>();
            list = (List<String>)Localization.Companion.getCountries();
            boolean bl = false;
            List<String> list2 = list;
            boolean bl2 = false;
            for (Object t : list2) {
                Country it = (Country)t;
                boolean bl3 = false;
                if (!this.filterCountryCondition(it)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        Country country = v0;
        list = country.getDocumentTypes();
        if (list != null && (iterator = list.iterator()) != null) {
            Iterator<String> $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Object> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object element$iv = iterator3.next();
                String it = (String)element$iv;
                boolean bl4 = false;
                Document document = DocumentConverter.INSTANCE.getDocumentField(it);
                if (document == null) continue;
                Document document2 = document;
                boolean bl5 = false;
                boolean bl6 = false;
                Document $this$initDocumentList_u24lambda_u2d7_u24lambda_u2d6 = document2;
                boolean bl7 = false;
                documentList.add($this$initDocumentList_u24lambda_u2d7_u24lambda_u2d6);
            }
        }
        this.repository.setDocuments(documentList);
        this.repository.onUpdateCountry(country);
    }

    /*
     * WARNING - void declaration
     */
    private final void showCountries() {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterator $this$filter$iv;
        Iterable $this$sortedBy$iv;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<String> $this$showCountries_u24lambda_u2d11 = arrayList;
        boolean bl4 = false;
        Iterable iterable = Localization.Companion.getCountries();
        boolean $i$f$sortedBy = false;
        boolean bl5 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Country it = (Country)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Country)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string2 = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
            }
        });
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Country it = (Country)element$iv$iv;
            boolean bl6 = false;
            Collection collection = it.getDocumentTypes();
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = !(collection == null || collection.isEmpty());
            if (!bl9) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = ((List)destination$iv$iv).iterator();
        boolean $i$f$forEach = false;
        var9_10 = $this$forEach$iv;
        boolean bl10 = false;
        void var11_14 = var9_10;
        while (var11_14.hasNext()) {
            Object element$iv = var11_14.next();
            Country it = (Country)element$iv;
            boolean bl11 = false;
            CharSequence charSequence = it.getName();
            boolean bl12 = false;
            if (!(charSequence.length() > 0)) continue;
            $this$showCountries_u24lambda_u2d11.add(it.getName());
        }
        ArrayList<String> countriesList = arrayList;
        ChoosingDocumentTypeContract.View view = this.getView();
        FormField formField = this.currentCountry;
        Intrinsics.checkNotNull((Object)formField);
        view.showDropDownView(formField);
        this.getView().setCountriesDropDown(countriesList);
    }

    private final void checkToShowDocumentList() {
        if (this.isCountryTitleDefault()) {
            return;
        }
        this.getView().showDocumentList(this.repository.getDocuments(), this.repository.getDocument());
        this.changeAcceptButtonState();
    }

    private final boolean isCountryTitleDefault() {
        FormField formField = this.currentCountry;
        Intrinsics.checkNotNull((Object)formField);
        return Intrinsics.areEqual((Object)formField.getTitle(), (Object)Localization.Companion.translation(TranslationKey.DOCUMENT_CHOICE_COUNTRYPLACEHOLDER));
    }

    private final void changeAcceptButtonState() {
        CharSequence charSequence = this.repository.getDocument().getTitle();
        boolean bl = false;
        boolean isActive = !StringsKt.isBlank((CharSequence)charSequence);
        this.getView().changeAcceptButtonState(isActive);
    }

    private final boolean filterCountryCondition(Country it) {
        CharSequence charSequence = it.getName();
        FormField formField = this.currentCountry;
        Intrinsics.checkNotNull((Object)formField);
        return StringsKt.contains((CharSequence)charSequence, (CharSequence)formField.getTitle(), (boolean)true);
    }

    public static final /* synthetic */ void access$showDialogEaAlreadyExists(ChoosingDocumentTypePresenter $this) {
        $this.showDialogEaAlreadyExists();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentState.values().length];
            nArray[DocumentState.SINGLE.ordinal()] = 1;
            nArray[DocumentState.FRONT_BACK.ordinal()] = 2;
            nArray[DocumentState.TOP_BOTTOM.ordinal()] = 3;
            nArray[DocumentState.BOOKLET.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

