/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.consent;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.helpers.ValidationExtensionsKt;
import com.sdk.getidlib.model.app.flow.FlowScreenPositionState;
import com.sdk.getidlib.model.data.repository.consent.ConsentRepository;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.presentation.features.consent.ConsentContract;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/sdk/getidlib/presentation/features/consent/ConsentPresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/consent/ConsentContract$View;", "Lcom/sdk/getidlib/presentation/features/consent/ConsentContract$Presenter;", "consentRepository", "Lcom/sdk/getidlib/model/data/repository/consent/ConsentRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "(Lcom/sdk/getidlib/model/data/repository/consent/ConsentRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;)V", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/consent/ConsentContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/consent/ConsentContract$View;)V", "changeConsentState", "", "initAgreeButtonTitle", "isRTL", "", "onStart", "setupViewsState", "getidlib_release"})
public final class ConsentPresenter
extends BasePresenterImpl<ConsentContract.View>
implements ConsentContract.Presenter {
    @NotNull
    private final ConsentRepository consentRepository;
    @NotNull
    private final DocumentTypeRepository documentTypeRepository;
    public ConsentContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;

    public ConsentPresenter(@NotNull ConsentRepository consentRepository, @NotNull DocumentTypeRepository documentTypeRepository) {
        Intrinsics.checkNotNullParameter((Object)consentRepository, (String)"consentRepository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        this.consentRepository = consentRepository;
        this.documentTypeRepository = documentTypeRepository;
        this.flowScreen = Screens.Consent.INSTANCE.getScreenKey();
        this.eventScreenName = "consent";
    }

    @Override
    @NotNull
    public ConsentContract.View getView() {
        ConsentContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull ConsentContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.getView().changeTitleToolbar(ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE));
        this.getView().changeToolbarMode(ActionBarMode.BACK);
        this.setupViewsState();
    }

    @Override
    public boolean isRTL() {
        return this.documentTypeRepository.getIsRTL();
    }

    @Override
    public void initAgreeButtonTitle() {
        if (this.getStateButtonAgree() == FlowScreenPositionState.NEXT_IS_NOT_LAST) {
            this.getView().setAgreeButtonTitle(Localization.Companion.translation(TranslationKey.CONSENT__IAGREE));
        } else {
            super.initAgreeButtonTitle();
        }
    }

    @Override
    public void changeConsentState() {
        boolean previousConsentState = this.consentRepository.getCheckBoxConsentState();
        this.consentRepository.onUpdateCheckBoxConsentState(!previousConsentState);
        this.setupViewsState();
    }

    private final void setupViewsState() {
        boolean actualConsentState = this.consentRepository.getCheckBoxConsentState();
        this.getView().changeConsentStateIcon(actualConsentState);
        this.getView().changeAcceptButtonState(actualConsentState);
    }
}

