/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.model.data.repository.setup;

import com.sdk.getidlib.app.di.network.NetworkComponent;
import com.sdk.getidlib.internal.DocumentType;
import com.sdk.getidlib.model.app.auth.TokenResponse;
import com.sdk.getidlib.model.data.cache.runtime.SetupState;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.data.service.AppService;
import com.sdk.getidlib.model.entity.configuration.ConfigurationResponse;
import com.sdk.getidlib.model.entity.jwt.JwtResponse;
import com.sdk.getidlib.model.entity.localization.LocalesResponse;
import com.sdk.getidlib.model.entity.localization.LocalizationResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\rH\u0016J&\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016J6\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\r2\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\rH\u0002J\u001c\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0018\u00010\rH\u0016J\u001c\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0018\u00010\rH\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\nH\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\rH\u0016J\n\u0010$\u001a\u0004\u0018\u00010\nH\u0016J!\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\b\u0010'\u001a\u0004\u0018\u00010\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\n\u0010(\u001a\u0004\u0018\u00010\nH\u0016J\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\n\u0010,\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010-\u001a\u0004\u0018\u00010\nH\u0016J)\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001d2\u0006\u0010\u0010\u001a\u00020\n2\b\u00100\u001a\u0004\u0018\u00010\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u000203H\u0016J$\u00104\u001a\u00020\b2\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\rH\u0016J$\u00106\u001a\u00020\b2\u001a\u00105\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\rH\u0016J\u0010\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\nH\u0016J\u0010\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\nH\u0016J\u0010\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\nH\u0016J\u0010\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\nH\u0016J\u0012\u0010?\u001a\u00020\b2\b\u0010@\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010A\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006B"}, d2={"Lcom/sdk/getidlib/model/data/repository/setup/SetupRepositoryImpl;", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "networkComponent", "Lcom/sdk/getidlib/app/di/network/NetworkComponent;", "setupState", "Lcom/sdk/getidlib/model/data/cache/runtime/SetupState;", "(Lcom/sdk/getidlib/app/di/network/NetworkComponent;Lcom/sdk/getidlib/model/data/cache/runtime/SetupState;)V", "addConfigurationName", "", "name", "", "addExtensions", "extensions", "", "addMetadata", "version", "locale", "Ljava/util/Locale;", "deviceId", "filterNotNullValues", "", "Lcom/sdk/getidlib/internal/DocumentType;", "map", "getAcceptableDocumentsFromClient", "getAcceptableDocumentsFromServer", "getApiKey", "getApplicationId", "getBaseUrl", "getConfiguration", "Lretrofit2/Response;", "Lcom/sdk/getidlib/model/entity/configuration/ConfigurationResponse;", "flowName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getConfigurationName", "getDeviceId", "getExtensions", "getExternalId", "getJwt", "Lcom/sdk/getidlib/model/entity/jwt/JwtResponse;", "customerId", "getLocale", "getLocales", "Lcom/sdk/getidlib/model/entity/localization/LocalesResponse;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSdkVersion", "getSelectedLocale", "getTranslations", "Lcom/sdk/getidlib/model/entity/localization/LocalizationResponse;", "dictionary", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isThankYouScreen", "", "setAcceptableDocumentsFromClient", "acceptableDocuments", "setAcceptableDocumentsFromServer", "setApiKey", "apiKey", "setApplicationId", "applicationId", "setBaseUrl", "baseUrl", "setExternalId", "externalId", "setSelectedLocale", "selectedLocale", "setThankYouScreen", "getidlib_release"})
public final class SetupRepositoryImpl
implements SetupRepository {
    @NotNull
    private final NetworkComponent networkComponent;
    @NotNull
    private final SetupState setupState;

    public SetupRepositoryImpl(@NotNull NetworkComponent networkComponent, @NotNull SetupState setupState2) {
        Intrinsics.checkNotNullParameter((Object)networkComponent, (String)"networkComponent");
        Intrinsics.checkNotNullParameter((Object)setupState2, (String)"setupState");
        this.networkComponent = networkComponent;
        this.setupState = setupState2;
    }

    @Override
    public void setApiKey(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.setupState.setApiKey(apiKey);
    }

    @Override
    @NotNull
    public String getApiKey() {
        return this.setupState.getApiKey();
    }

    @Override
    public void setBaseUrl(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.setupState.setApiUrl(baseUrl);
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.setupState.getApiUrl();
    }

    @Override
    @Nullable
    public Object getConfiguration(@Nullable String flowName, @NotNull Continuation<? super Response<ConfigurationResponse>> $completion) {
        return this.networkComponent.appService().getConfiguration(flowName, $completion);
    }

    @Override
    @Nullable
    public Object getTranslations(@NotNull String locale, @Nullable String dictionary, @NotNull Continuation<? super Response<LocalizationResponse>> $completion) {
        return this.networkComponent.appService().getTranslations(locale, dictionary, $completion);
    }

    @Override
    @Nullable
    public Object getLocales(@NotNull Continuation<? super Response<LocalesResponse>> $completion) {
        return AppService.DefaultImpls.getLocales$default(this.networkComponent.appService(), false, $completion, 1, null);
    }

    @Override
    @Nullable
    public Object getJwt(@Nullable String customerId, @NotNull Continuation<? super Response<JwtResponse>> $completion) {
        return this.networkComponent.appJwtService().getJwt(new TokenResponse(customerId), $completion);
    }

    @Override
    public void addMetadata(@Nullable String version, @Nullable Locale locale, @Nullable String deviceId) {
        this.setupState.setSdkVersion(version);
        this.setupState.setLocale(String.valueOf(locale));
        this.setupState.setDeviceId(deviceId);
    }

    @Override
    @Nullable
    public String getSdkVersion() {
        return this.setupState.getSdkVersion();
    }

    @Override
    @Nullable
    public String getDeviceId() {
        return this.setupState.getDeviceId();
    }

    @Override
    @Nullable
    public String getLocale() {
        return this.setupState.getLocale();
    }

    @Override
    public void addExtensions(@NotNull Map<String, String> extensions) {
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.setupState.setMetadataExtensions(extensions);
    }

    @Override
    @Nullable
    public Map<String, String> getExtensions() {
        return this.setupState.getMetadataExtensions();
    }

    @Override
    public void addConfigurationName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setupState.setConfigurationName(name);
    }

    @Override
    @NotNull
    public String getConfigurationName() {
        return this.setupState.getConfigurationName();
    }

    @Override
    public void setSelectedLocale(@Nullable String selectedLocale) {
        this.setupState.setSelectedLocale(selectedLocale);
    }

    @Override
    @Nullable
    public String getSelectedLocale() {
        return this.setupState.getSelectedLocale();
    }

    @Override
    public void setExternalId(@NotNull String externalId) {
        Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
        this.setupState.setExternalId(externalId);
    }

    @Override
    @Nullable
    public String getExternalId() {
        return this.setupState.getExternalId();
    }

    @Override
    public void setAcceptableDocumentsFromClient(@NotNull Map<String, ? extends List<? extends DocumentType>> acceptableDocuments) {
        Intrinsics.checkNotNullParameter(acceptableDocuments, (String)"acceptableDocuments");
        this.setupState.setAcceptableDocumentsFromClient(this.filterNotNullValues(acceptableDocuments));
    }

    @Override
    public void setAcceptableDocumentsFromServer(@NotNull Map<String, ? extends List<? extends DocumentType>> acceptableDocuments) {
        Intrinsics.checkNotNullParameter(acceptableDocuments, (String)"acceptableDocuments");
        this.setupState.setAcceptableDocumentsFromServer(this.filterNotNullValues(acceptableDocuments));
    }

    private final Map<String, List<DocumentType>> filterNotNullValues(Map<String, ? extends List<? extends DocumentType>> map) {
        HashMap result = new HashMap();
        Object object = map;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends List<? extends DocumentType>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            List value = (List)object3.getValue();
            object3 = result;
            List list = CollectionsKt.filterNotNull((Iterable)value);
            boolean bl4 = false;
            object3.put(key, list);
        }
        return result;
    }

    @Override
    @Nullable
    public Map<String, List<DocumentType>> getAcceptableDocumentsFromClient() {
        return this.setupState.getAcceptableDocumentsFromClient();
    }

    @Override
    @Nullable
    public Map<String, List<DocumentType>> getAcceptableDocumentsFromServer() {
        return this.setupState.getAcceptableDocumentsFromServer();
    }

    @Override
    public void setApplicationId(@NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.setupState.setApplicationId(applicationId);
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.setupState.getApplicationId();
    }

    @Override
    public void setThankYouScreen(boolean isThankYouScreen) {
        this.setupState.setThankYouScreen(isThankYouScreen);
    }

    @Override
    public boolean isThankYouScreen() {
        return this.setupState.isThankYouScreen();
    }
}

