/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.model.data.repository.liveness;

import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.sdk.getidlib.helpers.ValidationExtensionsKt;
import com.sdk.getidlib.model.data.cache.runtime.LivenessState;
import com.sdk.getidlib.model.data.repository.events.EventsRepository;
import com.sdk.getidlib.model.data.repository.liveness.LivenessRepository;
import com.sdk.getidlib.model.entity.events.EventScreen;
import com.sdk.getidlib.model.entity.events.GetIDError;
import com.sdk.getidlib.model.entity.liveness.LivenessResponse;
import com.sdk.getidlib.presentation.features.liveness.DetectListener;
import com.sdk.getidlib.presentation.features.liveness.EventsListener;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLParameters;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\nH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0018\u0010$\u001a\u00020\u00102\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020\u0010H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/sdk/getidlib/model/data/repository/liveness/LivenessRepositoryImpl;", "Lcom/sdk/getidlib/model/data/repository/liveness/LivenessRepository;", "livenessState", "Lcom/sdk/getidlib/model/data/cache/runtime/LivenessState;", "eventsRepository", "Lcom/sdk/getidlib/model/data/repository/events/EventsRepository;", "(Lcom/sdk/getidlib/model/data/cache/runtime/LivenessState;Lcom/sdk/getidlib/model/data/repository/events/EventsRepository;)V", "detectListener", "Lcom/sdk/getidlib/presentation/features/liveness/DetectListener;", "eventListener", "Lcom/sdk/getidlib/presentation/features/liveness/EventsListener;", "mWebSocketClient", "Lorg/java_websocket/client/WebSocketClient;", "sdf", "Ljava/text/SimpleDateFormat;", "dispose", "", "getFullFaceId", "", "getLivenessFullFaceSignature", "getLivenessServers", "getLivenessVideoId", "getLivenessVideoSignature", "giveTask", "handleFailure", "failure", "handleWarning", "warning", "Lcom/sdk/getidlib/model/entity/liveness/LivenessResponse$LivenessWarning;", "init", "listener", "sendFrame", "data", "", "setJwt", "jwt", "setLivenessServers", "servers", "", "setupDetectListener", "startDetecting", "getidlib_release"})
public final class LivenessRepositoryImpl
implements LivenessRepository {
    @NotNull
    private final LivenessState livenessState;
    @NotNull
    private final EventsRepository eventsRepository;
    @Nullable
    private EventsListener eventListener;
    @Nullable
    private DetectListener detectListener;
    private WebSocketClient mWebSocketClient;
    @NotNull
    private final SimpleDateFormat sdf;

    public LivenessRepositoryImpl(@NotNull LivenessState livenessState2, @NotNull EventsRepository eventsRepository2) {
        Intrinsics.checkNotNullParameter((Object)livenessState2, (String)"livenessState");
        Intrinsics.checkNotNullParameter((Object)eventsRepository2, (String)"eventsRepository");
        this.livenessState = livenessState2;
        this.eventsRepository = eventsRepository2;
        this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
    }

    @Override
    public void init(@NotNull EventsListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventListener = listener;
        this.startDetecting();
    }

    @Override
    public void dispose() {
        if (this.mWebSocketClient != null) {
            WebSocketClient webSocketClient;
            WebSocketClient webSocketClient2 = this.mWebSocketClient;
            if (webSocketClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                webSocketClient = null;
            } else {
                webSocketClient = webSocketClient2;
            }
            webSocketClient.close();
        }
        this.eventListener = null;
    }

    @Override
    public void setLivenessServers(@Nullable List<String> servers) {
        this.livenessState.setServers(servers);
    }

    @Override
    @NotNull
    public String getLivenessServers() {
        String string2;
        Collection collection = this.livenessState.getServers();
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            string2 = ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE);
        } else {
            List<String> list = this.livenessState.getServers();
            Intrinsics.checkNotNull(list);
            string2 = list.get(0);
        }
        return string2;
    }

    @Override
    public void startDetecting() {
        String additionalUrl = Intrinsics.stringPlus((String)"/0.5/liveness/", (Object)this.livenessState.getJwt());
        List<String> livenessServers = this.livenessState.getServers();
        Collection collection = livenessServers;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            for (String server : livenessServers) {
                WebSocketClient webSocketClient;
                WebSocketClient webSocketClient2;
                WebSocketClient webSocketClient3;
                WebSocketClient webSocketClient4;
                WebSocketClient webSocketClient5;
                String webSocketEndPointUrl;
                URI uri;
                this.mWebSocketClient = new WebSocketClient(this, livenessServers, server, uri = new URI(webSocketEndPointUrl = Intrinsics.stringPlus((String)server, (Object)additionalUrl))){
                    final /* synthetic */ LivenessRepositoryImpl this$0;
                    final /* synthetic */ List<String> $livenessServers;
                    final /* synthetic */ String $server;
                    final /* synthetic */ URI $uri;
                    {
                        this.this$0 = $receiver;
                        this.$livenessServers = $livenessServers;
                        this.$server = $server;
                        this.$uri = $uri;
                        super($uri);
                    }

                    public void onOpen(@NotNull ServerHandshake serverHandshake) {
                        Intrinsics.checkNotNullParameter((Object)serverHandshake, (String)"serverHandshake");
                    }

                    protected void onSetSSLParameters(@Nullable SSLParameters sslParameters) {
                        SSLParameters sSLParameters;
                        if (Build.VERSION.SDK_INT >= 24 && (sSLParameters = sslParameters) != null) {
                            sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
                        }
                    }

                    public void onMessage(@NotNull String message) {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        LivenessResponse.LivenessDataResponse response2 = (LivenessResponse.LivenessDataResponse)new Gson().fromJson(message, LivenessResponse.LivenessDataResponse.class);
                        LivenessRepositoryImpl.access$getEventsRepository$p(this.this$0).sendLivenessEvents(new EventScreen("liveness", null, LivenessRepositoryImpl.access$getSdf$p(this.this$0).format(new Date(System.currentTimeMillis())), response2, 2, null));
                        switch (response2.getMessageType()) {
                            case "task": {
                                DetectListener detectListener = LivenessRepositoryImpl.access$getDetectListener$p(this.this$0);
                                Intrinsics.checkNotNull((Object)detectListener);
                                detectListener.startTask(response2.getTask());
                                break;
                            }
                            case "taskComplete": {
                                DetectListener detectListener = LivenessRepositoryImpl.access$getDetectListener$p(this.this$0);
                                Intrinsics.checkNotNull((Object)detectListener);
                                detectListener.taskComplete();
                                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ LivenessRepositoryImpl this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var1_1);
                                                this.label = 1;
                                                v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                                                if (v0 == var2_2) {
                                                    return var2_2;
                                                }
                                                ** GOTO lbl13
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl13:
                                                // 2 sources

                                                this.this$0.giveTask();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null);
                                break;
                            }
                            case "warning": {
                                LivenessResponse.LivenessWarning livenessWarning = response2.getWarning();
                                if (livenessWarning == null) break;
                                LivenessResponse.LivenessWarning livenessWarning2 = livenessWarning;
                                LivenessRepositoryImpl livenessRepositoryImpl = this.this$0;
                                boolean bl = false;
                                boolean bl2 = false;
                                LivenessResponse.LivenessWarning it = livenessWarning2;
                                boolean bl3 = false;
                                LivenessRepositoryImpl.access$handleWarning(livenessRepositoryImpl, it);
                                break;
                            }
                            case "success": {
                                DetectListener detectListener = LivenessRepositoryImpl.access$getDetectListener$p(this.this$0);
                                Intrinsics.checkNotNull((Object)detectListener);
                                detectListener.success();
                                break;
                            }
                            case "failure": {
                                String string2 = response2.getErrorType();
                                if (string2 == null) break;
                                String string3 = string2;
                                LivenessRepositoryImpl livenessRepositoryImpl = this.this$0;
                                boolean bl = false;
                                boolean bl4 = false;
                                String it = string3;
                                boolean bl5 = false;
                                LivenessRepositoryImpl.access$handleFailure(livenessRepositoryImpl, it);
                                break;
                            }
                            case "artifactInfo": {
                                LivenessResponse.ArtifactInfo artifactInfo = response2.getArtifactInfo();
                                if (artifactInfo == null) break;
                                LivenessResponse.ArtifactInfo artifactInfo2 = artifactInfo;
                                LivenessRepositoryImpl livenessRepositoryImpl = this.this$0;
                                boolean bl = false;
                                boolean bl6 = false;
                                LivenessResponse.ArtifactInfo it = artifactInfo2;
                                boolean bl7 = false;
                                if (Intrinsics.areEqual((Object)it.getKind(), (Object)"video")) {
                                    LivenessRepositoryImpl.access$getLivenessState$p(livenessRepositoryImpl).setVideoLivenessSignature(it.getSignature());
                                    LivenessRepositoryImpl.access$getLivenessState$p(livenessRepositoryImpl).setVideoLivenessId(it.getFileId());
                                    break;
                                }
                                if (!Intrinsics.areEqual((Object)it.getKind(), (Object)"fullFace")) break;
                                LivenessRepositoryImpl.access$getLivenessState$p(livenessRepositoryImpl).setFullFaceSignature(it.getSignature());
                                LivenessRepositoryImpl.access$getLivenessState$p(livenessRepositoryImpl).setFullFaceId(it.getFileId());
                            }
                        }
                    }

                    public void onClose(int i, @NotNull String closedMessage, boolean b) {
                        Intrinsics.checkNotNullParameter((Object)closedMessage, (String)"closedMessage");
                        if (StringsKt.contains$default((CharSequence)closedMessage, (CharSequence)"401", (boolean)false, (int)2, null)) {
                            EventsListener eventsListener = LivenessRepositoryImpl.access$getEventListener$p(this.this$0);
                            Intrinsics.checkNotNull((Object)eventsListener);
                            eventsListener.showFatalErrorScreen(GetIDError.INVALID_LIVENESS_TOKEN);
                        } else if (StringsKt.contains$default((CharSequence)closedMessage, (CharSequence)"404", (boolean)false, (int)2, null) && this.$livenessServers.indexOf(this.$server) == this.$livenessServers.size() - 1) {
                            EventsListener eventsListener = LivenessRepositoryImpl.access$getEventListener$p(this.this$0);
                            Intrinsics.checkNotNull((Object)eventsListener);
                            eventsListener.showFatalErrorScreen(GetIDError.UNSUPPORTED_LIVENESS_VERSION);
                        }
                    }

                    public void onError(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        LivenessRepositoryImpl.access$handleFailure(this.this$0, "livenessServerUnavailable");
                        Log.i((String)"Websocket", (String)Intrinsics.stringPlus((String)"Error ", (Object)e.getMessage()));
                    }
                };
                WebSocketClient webSocketClient6 = this.mWebSocketClient;
                if (webSocketClient6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                    webSocketClient5 = null;
                } else {
                    webSocketClient5 = webSocketClient6;
                }
                webSocketClient5.connectBlocking();
                webSocketClient6 = this.mWebSocketClient;
                if (webSocketClient6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                    webSocketClient4 = null;
                } else {
                    webSocketClient4 = webSocketClient6;
                }
                if (!webSocketClient4.getConnection().isOpen()) continue;
                webSocketClient6 = this.mWebSocketClient;
                if (webSocketClient6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                    webSocketClient3 = null;
                } else {
                    webSocketClient3 = webSocketClient6;
                }
                webSocketClient3.send("{\"messageType\": \"metadata\", \"metadata\": {\"platform\": \"android\", \"schemaVersion\": \"0.5.0\"}}");
                webSocketClient6 = this.mWebSocketClient;
                if (webSocketClient6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                    webSocketClient2 = null;
                } else {
                    webSocketClient2 = webSocketClient6;
                }
                webSocketClient2.send("needArtifacts");
                webSocketClient6 = this.mWebSocketClient;
                if (webSocketClient6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                    webSocketClient = null;
                } else {
                    webSocketClient = webSocketClient6;
                }
                webSocketClient.send("giveMeTask");
                break;
            }
        }
    }

    private final void handleFailure(String failure) {
        DetectListener detectListener = this.detectListener;
        Intrinsics.checkNotNull((Object)detectListener);
        detectListener.failure(failure);
    }

    private final void handleWarning(LivenessResponse.LivenessWarning warning) {
        DetectListener detectListener = this.detectListener;
        Intrinsics.checkNotNull((Object)detectListener);
        detectListener.warning(warning);
    }

    @Override
    public void giveTask() {
        WebSocketClient webSocketClient;
        WebSocketClient webSocketClient2 = this.mWebSocketClient;
        if (webSocketClient2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
            webSocketClient = null;
        } else {
            webSocketClient = webSocketClient2;
        }
        if (webSocketClient.getConnection().isOpen()) {
            WebSocketClient webSocketClient3;
            webSocketClient2 = this.mWebSocketClient;
            if (webSocketClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                webSocketClient3 = null;
            } else {
                webSocketClient3 = webSocketClient2;
            }
            webSocketClient3.send("giveMeTask");
        } else {
            WebSocketClient webSocketClient4;
            WebSocketClient webSocketClient5;
            WebSocketClient webSocketClient6;
            WebSocketClient webSocketClient7;
            webSocketClient2 = this.mWebSocketClient;
            if (webSocketClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                webSocketClient7 = null;
            } else {
                webSocketClient7 = webSocketClient2;
            }
            webSocketClient7.reconnectBlocking();
            webSocketClient2 = this.mWebSocketClient;
            if (webSocketClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                webSocketClient6 = null;
            } else {
                webSocketClient6 = webSocketClient2;
            }
            webSocketClient6.send("{\"messageType\": \"metadata\", \"metadata\": {\"platform\": \"android\", \"schemaVersion\": \"0.5.0\"}}");
            webSocketClient2 = this.mWebSocketClient;
            if (webSocketClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                webSocketClient5 = null;
            } else {
                webSocketClient5 = webSocketClient2;
            }
            webSocketClient5.send("needArtifacts");
            webSocketClient2 = this.mWebSocketClient;
            if (webSocketClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
                webSocketClient4 = null;
            } else {
                webSocketClient4 = webSocketClient2;
            }
            webSocketClient4.send("giveMeTask");
        }
    }

    @Override
    @Nullable
    public String getLivenessFullFaceSignature() {
        return this.livenessState.getFullFaceSignature();
    }

    @Override
    @Nullable
    public String getLivenessVideoSignature() {
        return this.livenessState.getVideoLivenessSignature();
    }

    @Override
    @Nullable
    public String getFullFaceId() {
        return this.livenessState.getFullFaceId();
    }

    @Override
    @Nullable
    public String getLivenessVideoId() {
        return this.livenessState.getVideoLivenessId();
    }

    @Override
    public void setJwt(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        this.livenessState.setJwt(jwt);
    }

    @Override
    public void setupDetectListener(@NotNull DetectListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.detectListener = listener;
    }

    @Override
    public void sendFrame(@NotNull byte[] data) {
        WebSocketClient webSocketClient;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        WebSocketClient webSocketClient2 = this.mWebSocketClient;
        if (webSocketClient2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mWebSocketClient");
            webSocketClient = null;
        } else {
            webSocketClient = webSocketClient2;
        }
        webSocketClient.send(data);
    }

    public static final /* synthetic */ EventsRepository access$getEventsRepository$p(LivenessRepositoryImpl $this) {
        return $this.eventsRepository;
    }

    public static final /* synthetic */ SimpleDateFormat access$getSdf$p(LivenessRepositoryImpl $this) {
        return $this.sdf;
    }

    public static final /* synthetic */ DetectListener access$getDetectListener$p(LivenessRepositoryImpl $this) {
        return $this.detectListener;
    }

    public static final /* synthetic */ EventsListener access$getEventListener$p(LivenessRepositoryImpl $this) {
        return $this.eventListener;
    }

    public static final /* synthetic */ void access$handleFailure(LivenessRepositoryImpl $this, String failure) {
        $this.handleFailure(failure);
    }

    public static final /* synthetic */ void access$handleWarning(LivenessRepositoryImpl $this, LivenessResponse.LivenessWarning warning) {
        $this.handleWarning(warning);
    }

    public static final /* synthetic */ LivenessState access$getLivenessState$p(LivenessRepositoryImpl $this) {
        return $this.livenessState;
    }
}

