/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.model.data.repository.flow;

import com.sdk.getidlib.model.app.navigation.ScreenFlowItem;
import com.sdk.getidlib.model.data.cache.runtime.FlowState;
import com.sdk.getidlib.model.data.repository.flow.FlowRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00070\tj\b\u0012\u0004\u0012\u00020\u0007`\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0016\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0012\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/sdk/getidlib/model/data/repository/flow/FlowRepositoryImpl;", "Lcom/sdk/getidlib/model/data/repository/flow/FlowRepository;", "flowState", "Lcom/sdk/getidlib/model/data/cache/runtime/FlowState;", "(Lcom/sdk/getidlib/model/data/cache/runtime/FlowState;)V", "getActiveFlows", "", "Lcom/sdk/getidlib/model/app/navigation/ScreenFlowItem;", "getAllFlow", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getIndexNextScreen", "", "isCurrentScreen", "", "value", "isInitFlow", "onUpdateFlow", "", "indexItemPosition", "flow", "onUpdateFlows", "flows", "updateCurrentFlowScreen", "flowScreen", "", "updateCurrentFormTitle", "formTitleScreen", "getidlib_release"})
public final class FlowRepositoryImpl
implements FlowRepository {
    @NotNull
    private final FlowState flowState;

    public FlowRepositoryImpl(@NotNull FlowState flowState2) {
        Intrinsics.checkNotNullParameter((Object)flowState2, (String)"flowState");
        this.flowState = flowState2;
    }

    @Override
    public void onUpdateFlow(int indexItemPosition, @NotNull ScreenFlowItem flow) {
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        this.flowState.getFlows().add(indexItemPosition, flow);
    }

    @Override
    public void onUpdateFlows(@NotNull List<ScreenFlowItem> flows) {
        Intrinsics.checkNotNullParameter(flows, (String)"flows");
        this.flowState.setFlows(new ArrayList<ScreenFlowItem>((Collection)flows));
    }

    @NotNull
    public ArrayList<ScreenFlowItem> getAllFlow() {
        return this.flowState.getFlows();
    }

    @Override
    @NotNull
    public List<ScreenFlowItem> getActiveFlows() {
        return this.flowState.getActiveFlows();
    }

    @Override
    public void updateCurrentFlowScreen(@Nullable String flowScreen) {
        this.flowState.setCurrentFlowScreenName(flowScreen);
    }

    @Override
    public void updateCurrentFormTitle(@Nullable String formTitleScreen) {
        this.flowState.setCurrentFormTitle(formTitleScreen);
    }

    @Override
    public int getIndexNextScreen() {
        int indexNextScreen = -1;
        Iterator<ScreenFlowItem> iterator = this.getActiveFlows().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ScreenFlowItem value = iterator.next();
            if (!this.isCurrentScreen(value)) continue;
            indexNextScreen = index + 1;
            break;
        }
        return indexNextScreen;
    }

    @Override
    public boolean isInitFlow() {
        return this.flowState.getCurrentFlowScreenName() == null;
    }

    private final boolean isCurrentScreen(ScreenFlowItem value) {
        return this.flowState.getCurrentFormTitle() != null && Intrinsics.areEqual((Object)this.flowState.getCurrentFlowScreenName(), (Object)"Form") ? Intrinsics.areEqual((Object)value.getName(), (Object)this.flowState.getCurrentFlowScreenName()) && Intrinsics.areEqual((Object)value.getFormTitle(), (Object)this.flowState.getCurrentFormTitle()) : Intrinsics.areEqual((Object)value.getName(), (Object)this.flowState.getCurrentFlowScreenName());
    }
}

