/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.app.utils;

import android.graphics.Bitmap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/sdk/getidlib/app/utils/FileEncodeUtils;", "", "()V", "getImageFile", "Ljava/io/File;", "fileTitle", "", "image", "Landroid/graphics/Bitmap;", "scaleDocumentImage", "getidlib_release"})
public final class FileEncodeUtils {
    @NotNull
    public final Bitmap scaleDocumentImage(@NotNull Bitmap image) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image.getHeight() > 2048 && image.getWidth() > 2048) {
            bitmap = image;
        } else if (image.getHeight() >= image.getWidth()) {
            double height = (double)image.getHeight() / (double)image.getWidth() * (double)2048;
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)image, (int)2048, (int)((int)height), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n            val height\u2026toInt(), false)\n        }");
            bitmap = bitmap2;
        } else {
            double width = (double)image.getWidth() / (double)image.getHeight() * (double)2048;
            Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)image, (int)((int)width), (int)2048, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"{\n            val width \u2026), 2048, false)\n        }");
            bitmap = bitmap3;
        }
        return bitmap;
    }

    @NotNull
    public final File getImageFile(@NotNull String fileTitle, @NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)fileTitle, (String)"fileTitle");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        File file = new File(fileTitle);
        OutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        image.compress(Bitmap.CompressFormat.JPEG, 90, os);
        os.close();
        return file;
    }
}

