/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.app.di.repository;

import com.sdk.getidlib.app.di.network.NetworkComponent;
import com.sdk.getidlib.app.di.repository.RepositoryComponent;
import com.sdk.getidlib.app.di.service.ServiceComponent;
import com.sdk.getidlib.app.di.storage.StorageComponent;
import com.sdk.getidlib.model.data.repository.consent.ConsentRepositoryImpl;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepositoryImpl;
import com.sdk.getidlib.model.data.repository.events.EventsRepositoryImpl;
import com.sdk.getidlib.model.data.repository.flow.FlowRepositoryImpl;
import com.sdk.getidlib.model.data.repository.form.FormRepositoryImpl;
import com.sdk.getidlib.model.data.repository.liveness.LivenessRepositoryImpl;
import com.sdk.getidlib.model.data.repository.loading.LoadingRepositoryImpl;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepositoryImpl;
import com.sdk.getidlib.model.data.repository.setup.SetupRepositoryImpl;
import com.sdk.getidlib.model.data.repository.thank_you.ThankYouRepositoryImpl;
import com.sdk.getidlib.model.data.repository.video_recording.VideoRecordingRepositoryImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/sdk/getidlib/app/di/repository/RepositoryModule;", "Lcom/sdk/getidlib/app/di/repository/RepositoryComponent;", "storage", "Lcom/sdk/getidlib/app/di/storage/StorageComponent;", "networkComponent", "Lcom/sdk/getidlib/app/di/network/NetworkComponent;", "service", "Lcom/sdk/getidlib/app/di/service/ServiceComponent;", "(Lcom/sdk/getidlib/app/di/storage/StorageComponent;Lcom/sdk/getidlib/app/di/network/NetworkComponent;Lcom/sdk/getidlib/app/di/service/ServiceComponent;)V", "consentRepository", "Lcom/sdk/getidlib/model/data/repository/consent/ConsentRepositoryImpl;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepositoryImpl;", "eventsRepository", "Lcom/sdk/getidlib/model/data/repository/events/EventsRepositoryImpl;", "flowRepository", "Lcom/sdk/getidlib/model/data/repository/flow/FlowRepositoryImpl;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepositoryImpl;", "livenessRepository", "Lcom/sdk/getidlib/model/data/repository/liveness/LivenessRepositoryImpl;", "loadingRepository", "Lcom/sdk/getidlib/model/data/repository/loading/LoadingRepositoryImpl;", "photoRepository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepositoryImpl;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepositoryImpl;", "thankYouRepository", "Lcom/sdk/getidlib/model/data/repository/thank_you/ThankYouRepositoryImpl;", "videoRecordingRepository", "Lcom/sdk/getidlib/model/data/repository/video_recording/VideoRecordingRepositoryImpl;", "getidlib_release"})
public final class RepositoryModule
implements RepositoryComponent {
    @NotNull
    private final StorageComponent storage;
    @NotNull
    private final NetworkComponent networkComponent;
    @NotNull
    private final ServiceComponent service;

    public RepositoryModule(@NotNull StorageComponent storage, @NotNull NetworkComponent networkComponent, @NotNull ServiceComponent service) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)networkComponent, (String)"networkComponent");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.storage = storage;
        this.networkComponent = networkComponent;
        this.service = service;
    }

    @Override
    @NotNull
    public FlowRepositoryImpl flowRepository() {
        return new FlowRepositoryImpl(this.storage.getFlowState());
    }

    @Override
    @NotNull
    public FormRepositoryImpl formRepository() {
        return new FormRepositoryImpl(this.storage.getFormState());
    }

    @Override
    @NotNull
    public ConsentRepositoryImpl consentRepository() {
        return new ConsentRepositoryImpl(this.storage.getConsentState());
    }

    @Override
    @NotNull
    public DocumentTypeRepositoryImpl documentTypeRepository() {
        return new DocumentTypeRepositoryImpl(this.storage.getDocumentTypeState(), this.storage.getPhotoState(), this.networkComponent);
    }

    @Override
    @NotNull
    public PhotoRepositoryImpl photoRepository() {
        return new PhotoRepositoryImpl(this.storage.getPhotoState(), this.networkComponent);
    }

    @Override
    @NotNull
    public VideoRecordingRepositoryImpl videoRecordingRepository() {
        return new VideoRecordingRepositoryImpl(this.storage.getVideoRecordingState(), this.networkComponent);
    }

    @Override
    @NotNull
    public ThankYouRepositoryImpl thankYouRepository() {
        return new ThankYouRepositoryImpl(this.storage.getThankYouState());
    }

    @Override
    @NotNull
    public LoadingRepositoryImpl loadingRepository() {
        return new LoadingRepositoryImpl(this.setupRepository(), this.documentTypeRepository(), this.formRepository(), this.photoRepository(), this.livenessRepository(), this.videoRecordingRepository(), this.networkComponent);
    }

    @Override
    @NotNull
    public SetupRepositoryImpl setupRepository() {
        return new SetupRepositoryImpl(this.networkComponent, this.storage.getSetupState());
    }

    @Override
    @NotNull
    public LivenessRepositoryImpl livenessRepository() {
        return new LivenessRepositoryImpl(this.storage.getLivenessState(), this.eventsRepository());
    }

    @Override
    @NotNull
    public EventsRepositoryImpl eventsRepository() {
        return new EventsRepositoryImpl(this.networkComponent, this.service.getLocalBroadcast());
    }
}

