/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.app.common.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.sdk.getidlib.app.common.receivers.BroadcastReceiverListener;
import com.sdk.getidlib.app.common.receivers.EventBroadcastReceiver;
import com.sdk.getidlib.model.entity.events.GetIDApplication;
import com.sdk.getidlib.model.entity.events.GetIDError;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0006\u0010\r\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/sdk/getidlib/app/common/receivers/BroadcastReceiverManager;", "", "context", "Landroid/content/Context;", "eventListener", "Lcom/sdk/getidlib/app/common/receivers/BroadcastReceiverListener;", "(Landroid/content/Context;Lcom/sdk/getidlib/app/common/receivers/BroadcastReceiverListener;)V", "getContext", "()Landroid/content/Context;", "eventBroadcastManager", "Lcom/sdk/getidlib/app/common/receivers/EventBroadcastReceiver;", "initBroadcastReceivers", "", "stop", "getidlib_release"})
public final class BroadcastReceiverManager {
    @NotNull
    private final Context context;
    private EventBroadcastReceiver eventBroadcastManager;

    public BroadcastReceiverManager(@NotNull Context context, @NotNull BroadcastReceiverListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.context = context;
        this.initBroadcastReceivers(this.context, eventListener);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void stop() {
        EventBroadcastReceiver eventBroadcastReceiver;
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.context);
        EventBroadcastReceiver eventBroadcastReceiver2 = this.eventBroadcastManager;
        if (eventBroadcastReceiver2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventBroadcastManager");
            eventBroadcastReceiver = null;
        } else {
            eventBroadcastReceiver = eventBroadcastReceiver2;
        }
        localBroadcastManager.unregisterReceiver((BroadcastReceiver)eventBroadcastReceiver);
    }

    private final void initBroadcastReceivers(Context context, BroadcastReceiverListener eventListener) {
        EventBroadcastReceiver eventBroadcastReceiver;
        if (eventListener == null) {
            return;
        }
        this.eventBroadcastManager = new EventBroadcastReceiver(new BroadcastReceiverListener(eventListener){
            final /* synthetic */ BroadcastReceiverListener $eventListener;
            {
                this.$eventListener = $eventListener;
            }

            public void verificationFlowStart() {
                this.$eventListener.verificationFlowStart();
            }

            public void verificationFlowCancel() {
                this.$eventListener.verificationFlowCancel();
            }

            public void verificationFlowFail(@NotNull GetIDError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                this.$eventListener.verificationFlowFail(error);
            }

            public void verificationFlowComplete(@NotNull GetIDApplication application) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                this.$eventListener.verificationFlowComplete(application);
            }
        });
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        EventBroadcastReceiver eventBroadcastReceiver2 = this.eventBroadcastManager;
        if (eventBroadcastReceiver2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventBroadcastManager");
            eventBroadcastReceiver = null;
        } else {
            eventBroadcastReceiver = eventBroadcastReceiver2;
        }
        localBroadcastManager.registerReceiver((BroadcastReceiver)eventBroadcastReceiver, new IntentFilter("event_data"));
    }
}

