/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ldif;

import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.bean.LdapResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ldif
implements Serializable {
    public static final int NUL_CHAR = 0;
    public static final int LF_CHAR = 10;
    public static final int CR_CHAR = 13;
    public static final int SP_CHAR = 32;
    public static final int COLON_CHAR = 58;
    public static final int LA_CHAR = 60;
    public static final int MAX_ASCII_CHAR = 127;
    private static final long serialVersionUID = -3763879179455001975L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapBeanFactory beanFactory = LdapBeanProvider.getLdapBeanFactory();

    public LdapBeanFactory getLdapBeanFactory() {
        return this.beanFactory;
    }

    public void setLdapBeanFactory(LdapBeanFactory lbf) {
        if (lbf != null) {
            this.beanFactory = lbf;
        }
    }

    public String createLdif(Iterator<SearchResult> results) {
        String ldif;
        block2: {
            ldif = "";
            try {
                LdapResult lr = this.beanFactory.newLdapResult();
                lr.addEntries(results);
                ldif = this.createLdif(lr);
            }
            catch (NamingException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error((Object)"Error creating String from SearchResults", (Throwable)e);
            }
        }
        return ldif;
    }

    public String createLdif(LdapResult result) {
        StringBuffer ldif = new StringBuffer();
        if (result != null) {
            for (LdapEntry le : result.getEntries()) {
                ldif.append(this.createLdifEntry(le));
            }
        }
        return ldif.toString();
    }

    protected String createLdifEntry(LdapEntry ldapEntry) {
        StringBuffer entry = new StringBuffer();
        if (ldapEntry != null) {
            String dn = ldapEntry.getDn();
            if (dn != null) {
                if (this.encodeData(dn)) {
                    String encodedDn = LdapUtil.base64Encode(dn);
                    if (encodedDn != null) {
                        entry.append("dn:: ").append(dn).append(LINE_SEPARATOR);
                    }
                } else {
                    entry.append("dn: ").append(dn).append(LINE_SEPARATOR);
                }
            }
            for (LdapAttribute attr : ldapEntry.getLdapAttributes().getAttributes()) {
                String attrName = attr.getName();
                for (Object attrValue : attr.getValues()) {
                    if (this.encodeData(attrValue)) {
                        String encodedAttrValue = null;
                        if (attrValue instanceof String) {
                            encodedAttrValue = LdapUtil.base64Encode((String)attrValue);
                        } else if (attrValue instanceof byte[]) {
                            encodedAttrValue = LdapUtil.base64Encode((byte[])attrValue);
                        } else if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)"Could not cast attribute value as a byte[] or a String");
                        }
                        if (encodedAttrValue == null) continue;
                        entry.append(attrName).append(":: ").append(encodedAttrValue).append(LINE_SEPARATOR);
                        continue;
                    }
                    entry.append(attrName).append(": ").append(attrValue).append(LINE_SEPARATOR);
                }
            }
        }
        if (entry.length() > 0) {
            entry.append(LINE_SEPARATOR);
        }
        return entry.toString();
    }

    private boolean encodeData(Object data) {
        boolean encode = false;
        if (data instanceof String) {
            String stringData = (String)data;
            char[] dataCharArray = stringData.toCharArray();
            for (int i = 0; i < dataCharArray.length; ++i) {
                char charInt = dataCharArray[i];
                if (charInt == '\u0000') {
                    encode = true;
                    continue;
                }
                if (charInt == '\n') {
                    encode = true;
                    continue;
                }
                if (charInt == '\r') {
                    encode = true;
                    continue;
                }
                if (charInt == ' ' && (i == 0 || i == dataCharArray.length - 1)) {
                    encode = true;
                    continue;
                }
                if (charInt == ':' && i == 0) {
                    encode = true;
                    continue;
                }
                if (charInt == '<' && i == 0) {
                    encode = true;
                    continue;
                }
                if (charInt <= '\u007f') continue;
                encode = true;
            }
        } else {
            encode = true;
        }
        return encode;
    }

    public void outputLdif(Iterator<SearchResult> results, Writer writer) throws IOException {
        writer.write(this.createLdif(results));
        writer.flush();
    }

    public void outputLdif(LdapResult result, Writer writer) throws IOException {
        writer.write(this.createLdif(result));
        writer.flush();
    }

    public Iterator<SearchResult> importLdif(Reader reader) throws IOException {
        return this.importLdifToLdapResult(reader).toSearchResults().iterator();
    }

    public LdapResult importLdifToLdapResult(Reader reader) throws IOException {
        LdapResult ldapResult = this.beanFactory.newLdapResult();
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        int lineCount = 0;
        LdapEntry ldapEntry = null;
        StringBuffer lineValue = new StringBuffer();
        while ((line = br.readLine()) != null) {
            ++lineCount;
            if (!line.startsWith("dn:")) continue;
            lineValue.append(line);
            ldapEntry = this.beanFactory.newLdapEntry();
            break;
        }
        boolean read = true;
        while (read) {
            line = br.readLine();
            if (line == null) {
                read = false;
                line = "";
            }
            if (line.startsWith("#")) continue;
            if (line.startsWith("dn:")) {
                ldapResult.addEntry(ldapEntry);
                ldapEntry = this.beanFactory.newLdapEntry();
            }
            if (line.startsWith(" ")) {
                lineValue.append(line.substring(1));
                continue;
            }
            String s = lineValue.toString();
            if (s.indexOf(":") != -1) {
                boolean isBinary = false;
                boolean isUrl = false;
                String[] parts = s.split(":", 2);
                String attrName = parts[0];
                String attrValue = parts[1];
                if (attrValue.startsWith(":")) {
                    isBinary = true;
                    attrValue = attrValue.substring(1);
                } else if (attrValue.startsWith("<")) {
                    isUrl = true;
                    attrValue = attrValue.substring(1);
                }
                if (attrValue.startsWith(" ")) {
                    attrValue = attrValue.substring(1);
                }
                if ("dn".equals(attrName)) {
                    ldapEntry.setDn(attrValue);
                } else {
                    LdapAttribute ldapAttr = ldapEntry.getLdapAttributes().getAttribute(attrName);
                    if (ldapAttr == null) {
                        ldapAttr = this.beanFactory.newLdapAttribute();
                        ldapAttr.setName(attrName);
                        ldapEntry.getLdapAttributes().addAttribute(ldapAttr);
                    }
                    if (isBinary) {
                        ldapAttr.getValues().add(LdapUtil.base64Decode(attrValue));
                    } else if (isUrl) {
                        ldapAttr.getValues().add(LdapUtil.readURL(new URL(attrValue)));
                    } else {
                        ldapAttr.getValues().add(attrValue);
                    }
                }
            }
            lineValue = new StringBuffer(line);
        }
        if (ldapEntry != null) {
            ldapResult.addEntry(ldapEntry);
        }
        return ldapResult;
    }
}

