/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ssl;

import edu.vt.middleware.ldap.ssl.CredentialConfig;
import edu.vt.middleware.ldap.ssl.KeyStoreCredentialReader;
import edu.vt.middleware.ldap.ssl.KeyStoreSSLContextInitializer;
import edu.vt.middleware.ldap.ssl.SSLContextInitializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;

public class KeyStoreCredentialConfig
implements CredentialConfig {
    protected KeyStoreCredentialReader keyStoreReader = new KeyStoreCredentialReader();
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType;

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String s) {
        this.trustStore = s;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String s) {
        this.trustStorePassword = s;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String s) {
        this.trustStoreType = s;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String s) {
        this.keyStore = s;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String s) {
        this.keyStorePassword = s;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String s) {
        this.keyStoreType = s;
    }

    public SSLContextInitializer createSSLContextInitializer() throws GeneralSecurityException {
        KeyStoreSSLContextInitializer sslInit = new KeyStoreSSLContextInitializer();
        try {
            if (this.trustStore != null) {
                sslInit.setTrustKeystore((KeyStore)this.keyStoreReader.read(this.trustStore, this.trustStorePassword, this.trustStoreType));
            }
            if (this.keyStore != null) {
                sslInit.setAuthenticationKeystore((KeyStore)this.keyStoreReader.read(this.keyStore, this.keyStorePassword, this.keyStoreType));
                sslInit.setAuthenticationPassword(this.keyStorePassword != null ? this.keyStorePassword.toCharArray() : null);
            }
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
        return sslInit;
    }
}

