/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.bean.LdapResult;
import edu.vt.middleware.ldap.pool.LdapPool;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapSearch {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected LdapPool<Ldap> pool;
    protected LdapBeanFactory beanFactory = LdapBeanProvider.getLdapBeanFactory();

    public LdapSearch(LdapPool<Ldap> pool) {
        this.pool = pool;
    }

    public LdapBeanFactory getLdapBeanFactory() {
        return this.beanFactory;
    }

    public void setLdapBeanFactory(LdapBeanFactory lbf) {
        if (lbf != null) {
            this.beanFactory = lbf;
        }
    }

    public Iterator<SearchResult> search(String query, String[] attrs) throws NamingException {
        Iterator<SearchResult> queryResults;
        block9: {
            queryResults = null;
            if (query != null) {
                try {
                    Ldap ldap = null;
                    try {
                        ldap = this.pool.checkOut();
                        queryResults = ldap.search(new SearchFilter(query), attrs);
                    }
                    catch (NamingException e) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error((Object)"Error attempting LDAP search", (Throwable)e);
                        }
                        throw e;
                    }
                    finally {
                        this.pool.checkIn(ldap);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block9;
                    this.logger.error((Object)"Error using LDAP pool", (Throwable)e);
                }
            }
        }
        return queryResults;
    }

    public void search(String query, String[] attrs, Writer writer) throws NamingException, IOException {
        LdapResult lr = this.beanFactory.newLdapResult();
        lr.addEntries(this.search(query, attrs));
        writer.write(lr.toString());
        writer.flush();
    }

    public void close() {
        this.pool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

