/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import ucar.units.Prefix;
import ucar.units.PrefixDB;
import ucar.units.PrefixExistsException;
import ucar.units.PrefixName;
import ucar.units.PrefixSymbol;

public class PrefixDBImpl
implements PrefixDB,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedSet<Prefix> nameSet = new TreeSet<Prefix>();
    private final SortedSet<Prefix> symbolSet = new TreeSet<Prefix>();
    private final Map<Double, Prefix> valueMap = new TreeMap<Double, Prefix>();

    @Override
    public void addName(String name, double value) throws PrefixExistsException {
        PrefixName prefix = new PrefixName(name, value);
        this.nameSet.add(prefix);
    }

    @Override
    public void addSymbol(String symbol, double value) throws PrefixExistsException {
        PrefixSymbol prefix = new PrefixSymbol(symbol, value);
        this.symbolSet.add(prefix);
        this.valueMap.put(value, prefix);
    }

    @Override
    public Prefix getPrefixByName(String string) {
        return PrefixDBImpl.getPrefix(string, this.nameSet);
    }

    @Override
    public Prefix getPrefixBySymbol(String string) {
        return PrefixDBImpl.getPrefix(string, this.symbolSet);
    }

    @Override
    public Prefix getPrefixByValue(double value) {
        return this.valueMap.get(value);
    }

    private static Prefix getPrefix(String string, Set<Prefix> set) {
        for (Prefix prefix : set) {
            int comp = prefix.compareTo(string);
            if (comp == 0) {
                return prefix;
            }
            if (comp <= 0) continue;
            break;
        }
        return null;
    }

    @Override
    public String toString() {
        return "nameSet=" + this.nameSet + "symbolSet=" + this.symbolSet + "valueMap=" + this.valueMap;
    }

    public Iterator iterator() {
        return this.nameSet.iterator();
    }
}

