/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import java.util.Date;
import javax.annotation.concurrent.Immutable;
import ucar.units.ConversionException;
import ucar.units.Converter;
import ucar.units.ConverterImpl;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.LogarithmicUnit;
import ucar.units.MultiplyException;
import ucar.units.OffsetUnit;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.ScaledUnit;
import ucar.units.ShiftException;
import ucar.units.TimeScaleUnit;
import ucar.units.Unit;
import ucar.units.UnitName;

@Immutable
public abstract class UnitImpl
implements Unit,
Serializable {
    private static final long serialVersionUID = 1L;
    private final UnitName id;

    protected UnitImpl() {
        this(null);
    }

    protected UnitImpl(UnitName id) {
        this.id = id;
    }

    @Override
    public final UnitName getUnitName() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.id == null ? null : this.id.getName();
    }

    @Override
    public final String getPlural() {
        return this.id == null ? null : this.id.getPlural();
    }

    @Override
    public final String getSymbol() {
        return this.id == null ? null : this.id.getSymbol();
    }

    @Override
    public Unit shiftTo(double origin) throws ShiftException {
        return OffsetUnit.getInstance(this, origin);
    }

    @Override
    public Unit shiftTo(Date origin) throws ShiftException {
        return TimeScaleUnit.getInstance(this, origin);
    }

    @Override
    public final Unit multiplyBy(Unit that) throws MultiplyException {
        return this.myMultiplyBy(that);
    }

    @Override
    public Unit multiplyBy(double scale) throws MultiplyException {
        return ScaledUnit.getInstance(scale, this);
    }

    protected abstract Unit myMultiplyBy(Unit var1) throws MultiplyException;

    @Override
    public final Unit divideBy(Unit that) throws OperationException {
        return this.myDivideBy(that);
    }

    protected abstract Unit myDivideBy(Unit var1) throws OperationException;

    @Override
    public final Unit divideInto(Unit that) throws OperationException {
        return this.myDivideInto(that);
    }

    protected abstract Unit myDivideInto(Unit var1) throws OperationException;

    @Override
    public final Unit raiseTo(int power) throws RaiseException {
        return this.myRaiseTo(power);
    }

    protected abstract Unit myRaiseTo(int var1) throws RaiseException;

    @Override
    public Unit log(double base) {
        return LogarithmicUnit.getInstance(this, base);
    }

    @Override
    public Converter getConverterTo(Unit outputUnit) throws ConversionException {
        return new MyConverter(this, outputUnit);
    }

    @Override
    public float convertTo(float amount, Unit outputUnit) throws ConversionException {
        return (float)this.convertTo((double)amount, outputUnit);
    }

    @Override
    public double convertTo(double amount, Unit outputUnit) throws ConversionException {
        return this.getConverterTo(outputUnit).convert(amount);
    }

    @Override
    public float[] convertTo(float[] amounts, Unit outputUnit) throws ConversionException {
        return this.convertTo(amounts, outputUnit, new float[amounts.length]);
    }

    @Override
    public double[] convertTo(double[] amounts, Unit outputUnit) throws ConversionException {
        return this.convertTo(amounts, outputUnit, new double[amounts.length]);
    }

    @Override
    public float[] convertTo(float[] input, Unit outputUnit, float[] output) throws ConversionException {
        return this.getConverterTo(outputUnit).convert(input, output);
    }

    @Override
    public double[] convertTo(double[] input, Unit outputUnit, double[] output) throws ConversionException {
        return this.getConverterTo(outputUnit).convert(input, output);
    }

    @Override
    public boolean isCompatible(Unit that) {
        DerivedUnit u1 = this.getDerivedUnit();
        return u1.equals(that.getDerivedUnit());
    }

    public abstract int hashCode();

    private static boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    @Override
    public String toString() {
        String string = this.getSymbol();
        return string != null ? string : this.getName();
    }

    @Override
    public String makeLabel(String quantityID) {
        StringBuilder buf = new StringBuilder(quantityID);
        if (quantityID.contains(" ")) {
            buf.insert(0, '(').append(')');
        }
        buf.append('/');
        int start = buf.length();
        buf.append(this.toString());
        if (buf.substring(start).indexOf(32) != -1) {
            buf.insert(start, '(').append(')');
        }
        return buf.toString();
    }

    protected static class MyConverter
    extends ConverterImpl {
        private final DerivableUnit fromUnit;
        private final DerivableUnit toUnit;

        protected MyConverter(Unit fromUnit, Unit toUnit) throws ConversionException {
            super(fromUnit, toUnit);
            if (!(fromUnit instanceof DerivableUnit) || !(toUnit instanceof DerivableUnit)) {
                throw new ConversionException(fromUnit, toUnit);
            }
            this.fromUnit = (DerivableUnit)((Object)fromUnit);
            this.toUnit = (DerivableUnit)((Object)toUnit);
        }

        @Override
        public double convert(double amount) {
            double output;
            try {
                output = this.toUnit.fromDerivedUnit(this.fromUnit.toDerivedUnit(amount));
            }
            catch (ConversionException e) {
                output = 0.0;
            }
            return output;
        }

        @Override
        public float[] convert(float[] input, float[] output) {
            try {
                this.toUnit.fromDerivedUnit(this.fromUnit.toDerivedUnit(input, output), output);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            return output;
        }

        @Override
        public double[] convert(double[] input, double[] output) {
            try {
                this.toUnit.fromDerivedUnit(this.fromUnit.toDerivedUnit(input, output), output);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            return output;
        }
    }
}

