/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import ucar.nc2.grib.grib2.table.Grib2FlagTableInterface;
import ucar.nc2.grib.grib2.table.WmoCodeFlagTables;

public class WmoFlagTable
implements Grib2FlagTableInterface {
    private final WmoCodeFlagTables.WmoTable wmoTable;
    private final ImmutableListMultimap<Integer, WmoCodeFlagTables.WmoTable.WmoEntry> multimap;

    WmoFlagTable(WmoCodeFlagTables.WmoTable wmoTable) {
        Preconditions.checkNotNull(wmoTable);
        Preconditions.checkArgument(wmoTable.getType() == WmoCodeFlagTables.TableType.flag);
        this.wmoTable = wmoTable;
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (WmoCodeFlagTables.WmoTable.WmoEntry wmoEntry : wmoTable.getEntries()) {
            builder.put((Object)wmoEntry.getNumber(), wmoEntry);
        }
        this.multimap = builder.build();
    }

    @Override
    public String getName() {
        return this.wmoTable.getName();
    }

    @Override
    public String getShortName() {
        return this.wmoTable.getName();
    }

    @Override
    public ImmutableList<Grib2FlagTableInterface.Entry> getEntries() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : ((ImmutableMap)this.multimap.asMap()).entrySet()) {
            builder.add(new WmoFlagEntry((Integer)entry.getKey(), (Collection)entry.getValue()));
        }
        return builder.build();
    }

    @Override
    @Nullable
    public Grib2FlagTableInterface.Entry getEntry(int code) {
        ImmutableCollection entries = this.multimap.get((Object)code);
        if (entries == null) {
            return null;
        }
        return new WmoFlagEntry(code, entries);
    }

    private static class WmoFlagEntry
    implements Grib2FlagTableInterface.Entry {
        private final int code;
        private final Collection<WmoCodeFlagTables.WmoTable.WmoEntry> entries;

        public WmoFlagEntry(int code, Collection<WmoCodeFlagTables.WmoTable.WmoEntry> entries) {
            this.code = code;
            this.entries = entries;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public ImmutableList<Integer> getValues() {
            return this.entries.stream().map(WmoCodeFlagTables.WmoTable.WmoEntry::getValue).collect(ImmutableList.toImmutableList());
        }

        @Override
        @Nullable
        public String getName(int value) {
            return this.entries.stream().filter(e -> e.getValue() == value).findFirst().map(WmoCodeFlagTables.WmoTable.WmoEntry::getName).orElse(null);
        }
    }
}

