/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.EccodesLocalTables;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.unidata.util.StringUtil2;

class EccodesLocalConcepts {
    private static final Logger logger = LoggerFactory.getLogger(EccodesLocalTables.class);
    private static final String DISCIPLINE = "discipline";
    private static final String CATEGORY = "parameterCategory";
    private static final String NUMBER = "parameterNumber";
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private final String tableId;
    private ImmutableListMultimap<String, LocalConcept> localConcepts;
    private static final String FORMAT = "%-10s: %-70s: %-10s - %-8s - %-10s - %-20s - %s%n";

    EccodesLocalConcepts(String directoryPath) throws IOException {
        String[] dirs = directoryPath.split("/");
        this.tableId = dirs[dirs.length - 1];
        ImmutableListMultimap.Builder<LocalConceptPart, LocalConceptPart> partsBuilder = ImmutableListMultimap.builder();
        this.parseLocalConcept(partsBuilder, directoryPath + "/name.def", Type.name);
        this.parseLocalConcept(partsBuilder, directoryPath + "/shortName.def", Type.shortName);
        this.parseLocalConcept(partsBuilder, directoryPath + "/paramId.def", Type.paramId);
        this.parseLocalConcept(partsBuilder, directoryPath + "/units.def", Type.units);
        this.parseLocalConcept(partsBuilder, directoryPath + "/cfName.def", Type.cfName);
        this.parseLocalConcept(partsBuilder, directoryPath + "/cfVarName.def", Type.cfVarName);
        ImmutableListMultimap.Builder conceptsBuilder = ImmutableListMultimap.builder();
        for (Collection parts : ((ImmutableMap)partsBuilder.build().asMap()).values()) {
            LocalConcept localConcept = null;
            for (LocalConceptPart part : parts) {
                if (localConcept == null) {
                    localConcept = new LocalConcept(part);
                    continue;
                }
                localConcept.merge(part);
            }
            if (localConcept == null) continue;
            conceptsBuilder.put(localConcept.getKey(), localConcept);
        }
        this.localConcepts = conceptsBuilder.build();
    }

    ImmutableListMultimap<Integer, Grib2Parameter> getLocalConceptMultimap() {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (LocalConcept lc : this.localConcepts.values()) {
            if (lc.getName() == null || lc.getShortName() == null) continue;
            int code = Grib2Tables.makeParamId(lc.discipline, lc.category, lc.number);
            Grib2Parameter param = new Grib2Parameter(lc.discipline, lc.category, lc.number, lc.getName(), lc.getUnits(), lc.getShortName(), null);
            result.put((Object)code, param);
        }
        return result.build();
    }

    private void parseLocalConcept(ImmutableListMultimap.Builder<LocalConceptPart, LocalConceptPart> localConceptParts, String path, Type conceptType) throws IOException {
        ClassLoader cl = EccodesLocalConcepts.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(path);){
            if (is == null) {
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, ENCODING));){
                String line;
                boolean header = true;
                LocalConceptPart current = null;
                while ((line = br.readLine()) != null) {
                    if (line.isEmpty() || header && (line.startsWith("# Auto") || line.startsWith("#Provide"))) continue;
                    header = false;
                    if (line.startsWith("#paramId")) continue;
                    if (line.startsWith("#")) {
                        if (current != null) {
                            localConceptParts.put((Object)current, (Object)current);
                        }
                        String paramName = line.substring(1);
                        line = br.readLine();
                        current = new LocalConceptPart(paramName, this.clean(line), conceptType);
                        continue;
                    }
                    if (!line.contains("=")) continue;
                    Iterator<String> tokens = Splitter.on('=').trimResults().omitEmptyStrings().split(line).iterator();
                    String name = tokens.next();
                    String valueS = this.clean(tokens.next());
                    try {
                        int value = Integer.parseInt(valueS);
                        if (current == null) continue;
                        current.addAttribute(name, value);
                    }
                    catch (Exception e) {
                        logger.warn("Table {}/{} line {}", new Object[]{this.tableId, conceptType, line});
                    }
                }
                if (current != null) {
                    localConceptParts.put((Object)current, (Object)current);
                }
            }
        }
    }

    private String clean(String in) {
        StringBuilder sb = new StringBuilder(in);
        StringUtil2.removeAll(sb, ";={}'");
        return sb.toString().trim();
    }

    void showDetails(Formatter f) {
        ImmutableList sorted = this.localConcepts.values().stream().sorted().collect(ImmutableList.toImmutableList());
        TreeSet attNames = new TreeSet();
        f.format(FORMAT, "code", "name", "shortName", "paramId", "units", "cfName", "cfVarName");
        f.format("%s%n", StringUtil2.padRight("-", 120, "-"));
        for (LocalConcept lc : sorted) {
            f.format(FORMAT, lc.getCode(), lc.paramName, lc.shortName, lc.paramId, lc.units, lc.cfName, lc.cfVarName);
            lc.bag.show(f);
            attNames.addAll(lc.bag.atts.keySet());
        }
        f.format("%s%n", StringUtil2.padRight("-", 120, "-"));
        f.format("All attribute names in this table:%n", new Object[0]);
        for (String attName : attNames) {
            f.format(" %s%n", attName);
        }
    }

    public void showEntryDetails(Formatter f, List<GribTables.Parameter> params) {
        ArrayList<LocalConcept> concepts = new ArrayList<LocalConcept>();
        TreeSet<String> attNames = new TreeSet<String>();
        for (GribTables.Parameter param : params) {
            String key = param.getName() + ":" + Grib2Tables.makeParamCode(param.getDiscipline(), param.getCategory(), param.getNumber());
            ImmutableCollection match = this.localConcepts.get((Object)key);
            for (LocalConcept concept : match) {
                if (!concept.getShortName().equals(param.getAbbrev())) continue;
                concepts.add(concept);
                this.showLocalConcept(f, concept, attNames);
            }
        }
        f.format("%n", new Object[0]);
        int count = 0;
        f.format("%-30s   ", "");
        for (LocalConcept concept : concepts) {
            f.format("  (%2d)   ", count);
            ++count;
        }
        f.format("%n", new Object[0]);
        for (String attName : attNames) {
            f.format("%-30s ", attName);
            for (LocalConcept concept : concepts) {
                Integer value = (Integer)concept.bag.atts.get(attName);
                f.format("%8s ", value == null ? "" : value);
            }
            f.format("%n", new Object[0]);
        }
    }

    private void showLocalConcept(Formatter f, LocalConcept lc, Set<String> attNames) {
        f.format(FORMAT, lc.getCode(), lc.paramName, lc.shortName, lc.paramId, lc.units, lc.cfName, lc.cfVarName);
        lc.bag.show(f);
        attNames.addAll(lc.bag.atts.keySet());
        f.format("%n", new Object[0]);
    }

    private class LocalConceptPart {
        private final AttributeBag atts = new AttributeBag();
        private final String paramName;
        private final String value;
        private final Type type;

        LocalConceptPart(String paramName, String value, Type type) {
            this.paramName = paramName;
            this.value = value;
            this.type = type;
        }

        void addAttribute(String name, int value) {
            this.atts.atts.put(name, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalConceptPart that = (LocalConceptPart)o;
            if (!this.atts.equals(that.atts)) {
                return false;
            }
            return this.paramName.equals(that.paramName);
        }

        public int hashCode() {
            int result = this.atts.hashCode();
            result = 31 * result + this.paramName.hashCode();
            return result;
        }
    }

    private static enum Type {
        name,
        shortName,
        paramId,
        units,
        cfName,
        cfVarName;

    }

    private class LocalConcept
    implements Comparable<LocalConcept> {
        private final String paramName;
        private final LocalConceptPart org;
        private int discipline;
        private int category;
        private int number;
        private String paramId;
        private String name;
        private String shortName;
        private String units;
        private String cfName;
        private String cfVarName;
        private final AttributeBag bag = new AttributeBag();

        LocalConcept(LocalConceptPart part) {
            this.paramName = part.paramName;
            this.org = part;
            this.extractValue(part);
            this.extractAtts(part);
        }

        String getKey() {
            return this.paramName + ":" + Grib2Tables.makeParamCode(this.discipline, this.category, this.number);
        }

        void merge(LocalConceptPart part) {
            assert (this.paramName.equals(part.paramName));
            assert (this.org.atts.equals(part.atts));
            this.extractValue(part);
        }

        void extractAtts(LocalConceptPart part) {
            block10: for (Map.Entry entry : part.atts.atts.entrySet()) {
                String name = (String)entry.getKey();
                Integer value = (Integer)entry.getValue();
                switch (name) {
                    case "discipline": {
                        this.discipline = value;
                        continue block10;
                    }
                    case "parameterCategory": {
                        this.category = value;
                        continue block10;
                    }
                    case "parameterNumber": {
                        this.number = value;
                        continue block10;
                    }
                }
                this.bag.atts.put(name, value);
            }
        }

        private void extractValue(LocalConceptPart part) {
            switch (part.type) {
                case name: {
                    this.name = part.value;
                    break;
                }
                case shortName: {
                    this.shortName = part.value;
                    break;
                }
                case paramId: {
                    this.paramId = part.value;
                    break;
                }
                case units: {
                    this.units = part.value;
                    break;
                }
                case cfName: {
                    this.cfName = part.value;
                    break;
                }
                case cfVarName: {
                    this.cfVarName = part.value;
                }
            }
        }

        String getCode() {
            return Grib2Tables.makeParamCode(this.discipline, this.category, this.number);
        }

        String getName() {
            return this.paramName != null ? this.paramName : this.cfName;
        }

        String getShortName() {
            return this.shortName != null ? this.shortName : this.cfVarName;
        }

        String getUnits() {
            return this.units != null ? this.units : "";
        }

        @Override
        public int compareTo(LocalConcept o) {
            int c = this.discipline - o.discipline;
            if (c != 0) {
                return c;
            }
            c = this.category - o.category;
            if (c != 0) {
                return c;
            }
            return this.number - o.number;
        }
    }

    private static class AttributeBag {
        private final Map<String, Integer> atts = new TreeMap<String, Integer>();
        int hashCode;

        private AttributeBag() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeBag that = (AttributeBag)o;
            return this.atts.equals(that.atts);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                for (Map.Entry<String, Integer> entry : this.atts.entrySet()) {
                    result = 37 * result + entry.getKey().hashCode();
                    result = 37 * result + entry.getValue().hashCode();
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }

        public void show(Formatter f) {
            if (this.atts.isEmpty()) {
                return;
            }
            f.format("     ", new Object[0]);
            for (Map.Entry<String, Integer> entry : this.atts.entrySet()) {
                f.format("%s(%3d) ", entry.getKey(), entry.getValue());
            }
            f.format("%n", new Object[0]);
        }
    }
}

