/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib2SectionData {
    private final long startingPosition;
    private final int msgLength;

    public Grib2SectionData(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        this.msgLength = GribNumbers.int4(raf);
        int section = raf.read();
        if (section != 7) {
            throw new IllegalStateException("Not a Grib2SectionData (section 7)");
        }
        raf.seek(this.startingPosition + (long)this.msgLength);
    }

    Grib2SectionData(long startingPosition, int msgLength) {
        this.startingPosition = startingPosition;
        this.msgLength = msgLength;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    public long getEndingPosition() {
        return this.startingPosition + (long)this.msgLength;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public byte[] getBytes(RandomAccessFile raf) throws IOException {
        raf.seek(this.startingPosition);
        byte[] data = new byte[this.msgLength];
        raf.readFully(data);
        return data;
    }
}

