/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.DateExtractor;
import thredds.inventory.MCollection;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.cache.SmartArrayInt;
import ucar.unidata.util.StringUtil2;

public class PartitionCollectionMutable
extends GribCollectionMutable {
    protected final Logger logger;
    protected List<Partition> partitions;
    protected boolean isPartitionOfPartitions;
    int[] run2part;

    protected PartitionCollectionMutable(String name, File directory, FeatureCollectionConfig config, boolean isGrib1, Logger logger) {
        super(name, directory, config, isGrib1);
        this.logger = logger;
        this.partitions = new ArrayList<Partition>();
        this.datasets = new ArrayList();
    }

    @Override
    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Partition p : this.getPartitions()) {
            result.add(p.getIndexFilenameInCache());
        }
        Collections.sort(result);
        return result;
    }

    Partition addPartition(String name, String filename, long lastModified, long length, String directory, CalendarDate partitionDate) {
        Partition partition = new Partition(name, filename, lastModified, length, directory, partitionDate);
        this.partitions.add(partition);
        return partition;
    }

    public void addPartition(MCollection dcm) {
        Partition partition = new Partition(dcm);
        try (GribCollectionMutable gc = partition.makeGribCollection();){
            if (gc == null) {
                this.logger.warn("failed to open partition {} =skipping", (Object)dcm.getCollectionName());
            } else {
                this.partitions.add(partition);
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to open partition {} -skipping", (Object)dcm.getCollectionName(), (Object)e);
        }
    }

    void sortPartitions() {
        Collections.sort(this.partitions);
        this.partitions = Collections.unmodifiableList(this.partitions);
    }

    VariableIndexPartitioned makeVariableIndexPartitioned(GribCollectionMutable.GroupGC group, GribCollectionMutable.VariableIndex from, int nparts) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(group, from, nparts);
        group.addVariable(vip);
        if (from instanceof VariableIndexPartitioned && !this.isPartitionOfPartitions) {
            VariableIndexPartitioned vipFrom = (VariableIndexPartitioned)from;
            assert (vipFrom.partList == null);
            for (int i = 0; i < vipFrom.nparts; ++i) {
                vip.addPartition(vipFrom.partnoSA.get(i), vipFrom.groupnoSA.get(i), vipFrom.varnoSA.get(i), 0, 0, 0, vipFrom);
            }
        }
        return vip;
    }

    public Iterable<Partition> getPartitions() {
        return this.partitions;
    }

    Partition getPartition(int idx) {
        return this.partitions.get(idx);
    }

    int getPartitionSize() {
        return this.partitions.size();
    }

    @Override
    public void showIndex(Formatter f) {
        super.showIndex(f);
        int count = 0;
        f.format("isPartitionOfPartitions=%s%n", this.isPartitionOfPartitions);
        f.format("Partitions%n", new Object[0]);
        for (Partition p : this.getPartitions()) {
            f.format("%d:  %s%n", count++, p);
        }
        f.format("%n", new Object[0]);
        if (this.run2part == null) {
            f.format("run2part null%n", new Object[0]);
        } else {
            f.format(" master runtime -> partition %n", new Object[0]);
            for (int idx = 0; idx < this.masterRuntime.getSize(); ++idx) {
                int partno = this.run2part[idx];
                Partition part = this.getPartition(partno);
                f.format(" %d:  %s -> part %3d %s%n", count, this.masterRuntime.getRuntimeDate(idx), partno, part);
                ++count;
            }
            f.format("%n", new Object[0]);
        }
    }

    public class Partition
    implements Comparable<Partition> {
        final String name;
        final String directory;
        final String filename;
        long lastModified;
        long fileSize;
        CalendarDate partitionDate;
        private DateExtractor extractor;
        private MCollection dcm;

        public Partition(String name, String filename, long lastModified, long fileSize, String directory, CalendarDate partitionDate) {
            this.name = name;
            this.filename = filename;
            this.lastModified = lastModified;
            this.fileSize = fileSize;
            this.directory = directory;
            this.partitionDate = partitionDate;
        }

        public String getName() {
            return this.name;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getDirectory() {
            return this.directory;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean isGrib1() {
            return PartitionCollectionMutable.this.isGrib1;
        }

        public FeatureCollectionConfig getConfig() {
            return PartitionCollectionMutable.this.config;
        }

        public Logger getLogger() {
            return PartitionCollectionMutable.this.logger;
        }

        public MCollection getDcm() {
            return this.dcm;
        }

        private DateExtractor getDateExtractor() {
            if (this.extractor == null) {
                this.extractor = PartitionCollectionMutable.this.config.getDateExtractor();
            }
            return this.extractor;
        }

        @Nullable
        String getIndexFilenameInCache() {
            File file = new File(this.directory, this.filename);
            File existingFile = GribIndexCache.getExistingFileOrCache(file.getPath());
            if (existingFile == null) {
                File parent = PartitionCollectionMutable.this.getIndexParentFile();
                if (parent == null) {
                    return null;
                }
                existingFile = new File(parent, this.filename);
                if (!existingFile.exists()) {
                    return null;
                }
            }
            return existingFile.getPath();
        }

        public GribCollectionImmutable getGribCollection() throws IOException {
            String path = this.getIndexFilenameInCache();
            if (path == null) {
                if (Grib.debugIndexOnly) {
                    File orgParentDir = new File(this.directory);
                    File currentFile = new File(PartitionCollectionMutable.this.indexFilename);
                    File currentParent = currentFile.getParentFile();
                    File currentParentWithDir = new File(currentParent, orgParentDir.getName());
                    File nestedIndex = PartitionCollectionMutable.this.isPartitionOfPartitions ? new File(currentParentWithDir, this.filename) : new File(currentParent, this.filename);
                    path = nestedIndex.getPath();
                } else {
                    throw new FileNotFoundException("No index filename for partition= " + this);
                }
            }
            return (GribCollectionImmutable)PartitionCollectionImmutable.partitionCollectionFactory.open(new DatasetUrl(null, path), -1, null, this);
        }

        @Nullable
        public GribCollectionMutable makeGribCollection() {
            GribCollectionMutable result = GribCdmIndex.openMutableGCFromIndex(this.dcm.getIndexFilename(".ncx4"), PartitionCollectionMutable.this.config, false, true, PartitionCollectionMutable.this.logger);
            if (result == null) {
                PartitionCollectionMutable.this.logger.error("Failed on openMutableGCFromIndex {}", (Object)this.dcm.getIndexFilename(".ncx4"));
                return null;
            }
            this.lastModified = result.lastModified;
            this.fileSize = result.fileSize;
            if (result.masterRuntime != null) {
                this.partitionDate = result.masterRuntime.getFirstDate();
            }
            return result;
        }

        @Override
        public int compareTo(@Nonnull Partition o) {
            if (this.partitionDate != null && o.partitionDate != null) {
                return this.partitionDate.compareTo(o.partitionDate);
            }
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{dcm=" + this.dcm + ", name='" + this.name + '\'' + ", directory='" + this.directory + '\'' + ", filename='" + this.filename + '\'' + ", partitionDate='" + this.partitionDate + '\'' + ", lastModified='" + CalendarDate.of(this.lastModified) + '\'' + '}';
        }

        public Partition(MCollection dcm) {
            FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
            if (config == null) {
                PartitionCollectionMutable.this.logger.warn("Partition missing FeatureCollectionConfig {}", (Object)dcm);
            }
            this.dcm = dcm;
            this.name = dcm.getCollectionName();
            this.lastModified = dcm.getLastModified();
            this.directory = StringUtil2.replace(dcm.getRoot(), '\\', "/");
            this.partitionDate = dcm.getPartitionDate();
            String indexFilename = StringUtil2.replace(dcm.getIndexFilename(".ncx4"), '\\', "/");
            if (this.partitionDate == null) {
                this.partitionDate = this.getDateExtractor().getCalendarDateFromPath(indexFilename);
            }
            if (indexFilename.startsWith(this.directory) && (indexFilename = indexFilename.substring(this.directory.length())).startsWith("/")) {
                indexFilename = indexFilename.substring(1);
            }
            this.filename = indexFilename;
        }
    }

    public class VariableIndexPartitioned
    extends GribCollectionMutable.VariableIndex {
        final int nparts;
        SmartArrayInt partnoSA;
        SmartArrayInt groupnoSA;
        SmartArrayInt varnoSA;
        List<PartitionForVariable2D> partList;

        VariableIndexPartitioned(GribCollectionMutable.GroupGC g2, GribCollectionMutable.VariableIndex other, int nparts) {
            super(g2, other);
            this.nparts = nparts;
        }

        public void setPartitions(List<GribCollectionProto.PartitionVariable> pvList) {
            int[] partno = new int[this.nparts];
            int[] groupno = new int[this.nparts];
            int[] varno = new int[this.nparts];
            int count = 0;
            for (GribCollectionProto.PartitionVariable part : pvList) {
                partno[count] = part.getPartno();
                groupno[count] = part.getGroupno();
                varno[count] = part.getVarno();
                ++count;
            }
            this.partnoSA = new SmartArrayInt(partno);
            this.groupnoSA = new SmartArrayInt(groupno);
            this.varnoSA = new SmartArrayInt(varno);
            this.partList = null;
        }

        public void finish() {
            if (this.partList == null) {
                return;
            }
            if (this.partList.size() > this.nparts) {
                PartitionCollectionMutable.this.logger.warn("PartitionCollectionMutable partList.size() > nparts");
            }
            int[] partno = new int[this.nparts];
            int[] groupno = new int[this.nparts];
            int[] varno = new int[this.nparts];
            int count = 0;
            for (PartitionForVariable2D part : this.partList) {
                partno[count] = part.partno;
                groupno[count] = part.groupno;
                varno[count] = part.varno;
                ++count;
            }
            this.partnoSA = new SmartArrayInt(partno);
            this.groupnoSA = new SmartArrayInt(groupno);
            this.varnoSA = new SmartArrayInt(varno);
            this.partList = null;
        }

        void addPartition(int partno, int groupno, int varno, int ndups, int nrecords, int nmissing, GribCollectionMutable.VariableIndex vi) {
            if (this.partList == null) {
                this.partList = new ArrayList<PartitionForVariable2D>(this.nparts);
            }
            this.partList.add(new PartitionForVariable2D(partno, groupno, varno));
            this.ndups += ndups;
            this.nrecords += nrecords;
            this.nmissing += nmissing;
        }

        @Override
        public String toStringComplete() {
            Formatter sb = new Formatter();
            sb.format("VariableIndexPartitioned%n", new Object[0]);
            sb.format(" partno=", new Object[0]);
            this.partnoSA.show(sb);
            sb.format("%n groupno=", new Object[0]);
            this.groupnoSA.show(sb);
            sb.format("%n varno=", new Object[0]);
            this.varnoSA.show(sb);
            sb.format("%n", new Object[0]);
            int count = 0;
            sb.format("     %7s %3s %3s %6s %3s%n", "N", "dups", "Miss", "density", "partition");
            for (int i = 0; i < this.nparts; ++i) {
                int partWant = this.partnoSA.get(i);
                Partition part = PartitionCollectionMutable.this.partitions.get(partWant);
                sb.format("   %2d: %7d %s%n", count++, partWant, part.getFilename());
            }
            sb.format("%n", new Object[0]);
            sb.format(super.toStringComplete(), new Object[0]);
            return sb.toString();
        }
    }

    static class PartitionForVariable2D {
        final int partno;
        final int groupno;
        final int varno;
        GribCollectionMutable.VariableIndex vi;

        PartitionForVariable2D(int partno, int groupno, int varno) {
            this.partno = partno;
            this.groupno = groupno;
            this.varno = varno;
        }
    }
}

