/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateEns;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.CoordinateVert;
import ucar.nc2.grib.coord.EnsCoordValue;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.coord.VertCoordValue;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.util.Parameter;

class GribIospBuilder {
    private final GribIosp iosp;
    private final boolean isGrib1;
    private final Logger logger;
    private final GribCollectionImmutable gribCollection;
    private final GribTables gribTable;

    GribIospBuilder(GribIosp iosp, boolean isGrib1, Logger logger, GribCollectionImmutable gribCollection, GribTables gribTable) {
        this.iosp = iosp;
        this.isGrib1 = isGrib1;
        this.logger = logger;
        this.gribCollection = gribCollection;
        this.gribTable = gribTable;
    }

    void addGroup(Group.Builder parent, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype, boolean useGroups) {
        Group.Builder g2;
        if (useGroups) {
            if (parent.findGroup(group.getId()).isPresent()) {
                this.logger.warn("Duplicate Group - skipping");
                return;
            }
            g2 = Group.builder(parent);
            g2.setName(group.getId());
            g2.addAttribute(new Attribute("long_name", group.getDescription()));
        } else {
            g2 = parent;
        }
        this.makeGroup(g2, group, gctype);
    }

    private void makeGroup(Group.Builder g2, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype) {
        String horizDims;
        Object hcsV;
        boolean isLatLon;
        GdsHorizCoordSys hcs = group.getGdsHorizCoordSys();
        String grid_mapping = hcs.getName() + "_Projection";
        boolean isRotatedLatLon = !this.isGrib1 && hcs.proj instanceof RotatedPole;
        boolean isLatLon2D = !this.isGrib1 && Grib2Utils.isCurvilinearOrthogonal(hcs.template, this.gribCollection.getCenter());
        boolean bl = isLatLon = this.isGrib1 ? hcs.isLatLon() : Grib2Utils.isLatLon(hcs.template, this.gribCollection.getCenter());
        if (isRotatedLatLon) {
            hcsV = ((Variable.Builder)Variable.builder().setName(grid_mapping)).setDataType(DataType.INT);
            g2.addVariable((Variable.Builder<?>)hcsV);
            ((Variable.Builder)hcsV).setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                ((Variable.Builder)hcsV).addAttribute(new Attribute(p));
            }
            horizDims = "rlat rlon";
            g2.addDimension(new Dimension("rlat", hcs.ny));
            g2.addDimension(new Dimension("rlon", hcs.nx));
            Iterator<Parameter> rlat = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("rlat")).setDataType(DataType.FLOAT)).setDimensionsByName("rlat");
            g2.addVariable((Variable.Builder<?>)((Object)rlat));
            ((Variable.Builder)((Object)rlat)).addAttribute(new Attribute("standard_name", "grid_latitude"));
            ((Variable.Builder)((Object)rlat)).addAttribute(new Attribute("units", "degrees"));
            ((Variable.Builder)((Object)rlat)).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy), false);
            Object rlon = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("rlon")).setDataType(DataType.FLOAT)).setDimensionsByName("rlon");
            g2.addVariable((Variable.Builder<?>)rlon);
            ((Variable.Builder)rlon).addAttribute(new Attribute("standard_name", "grid_longitude"));
            ((Variable.Builder)rlon).addAttribute(new Attribute("units", "degrees"));
            ((Variable.Builder)rlon).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx), false);
        } else if (isLatLon2D) {
            horizDims = "lat lon";
            g2.addDimension(new Dimension("lon", hcs.nx));
            g2.addDimension(new Dimension("lat", hcs.ny));
        } else if (isLatLon) {
            hcsV = ((Variable.Builder)Variable.builder().setName(grid_mapping)).setDataType(DataType.INT);
            g2.addVariable((Variable.Builder<?>)hcsV);
            ((Variable.Builder)hcsV).setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                ((Variable.Builder)hcsV).addAttribute(new Attribute(p));
            }
            horizDims = "lat lon";
            g2.addDimension(new Dimension("lon", hcs.nx));
            g2.addDimension(new Dimension("lat", hcs.ny));
            Iterator<Parameter> lat = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("lat")).setDataType(DataType.FLOAT)).setDimensionsByName("lat");
            g2.addVariable((Variable.Builder<?>)((Object)lat));
            ((Variable.Builder)((Object)lat)).addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.getGaussianLats() != null) {
                ((Variable.Builder)((Object)lat)).setCachedData(hcs.getGaussianLats(), false);
                ((Variable.Builder)((Object)lat)).addAttribute(new Attribute("gaussian_lats", "true"));
            } else {
                ((Variable.Builder)((Object)lat)).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy), false);
            }
            Object lon = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("lon")).setDataType(DataType.FLOAT)).setDimensionsByName("lon");
            g2.addVariable((Variable.Builder<?>)lon);
            ((Variable.Builder)lon).addAttribute(new Attribute("units", "degrees_east"));
            ((Variable.Builder)lon).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx), false);
        } else {
            hcsV = ((Variable.Builder)Variable.builder().setName(grid_mapping)).setDataType(DataType.INT);
            g2.addVariable((Variable.Builder<?>)hcsV);
            ((Variable.Builder)hcsV).setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}), false);
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                ((Variable.Builder)hcsV).addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            g2.addDimension(new Dimension("x", hcs.nx));
            g2.addDimension(new Dimension("y", hcs.ny));
            Object xcv = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("x")).setDataType(DataType.FLOAT)).setDimensionsByName("x");
            g2.addVariable((Variable.Builder<?>)xcv);
            ((Variable.Builder)xcv).addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            ((Variable.Builder)xcv).addAttribute(new Attribute("units", "km"));
            ((Variable.Builder)xcv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx), false);
            Object ycv = ((Variable.Builder)((Variable.Builder)Variable.builder().setName("y")).setDataType(DataType.FLOAT)).setDimensionsByName("y");
            g2.addVariable((Variable.Builder<?>)ycv);
            ((Variable.Builder)ycv).addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            ((Variable.Builder)ycv).addAttribute(new Attribute("units", "km"));
            ((Variable.Builder)ycv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy), false);
        }
        boolean singleRuntimeWasMade = false;
        for (Coordinate coord : group.coords) {
            Coordinate.Type ctype = coord.getType();
            switch (ctype) {
                case runtime: {
                    if (!gctype.isTwoD() && coord.getNCoords() != 1) break;
                    this.makeRuntimeCoordinate(g2, (CoordinateRuntime)coord);
                    break;
                }
                case timeIntv: {
                    this.makeTimeCoordinate1D(g2, (CoordinateTimeIntv)coord);
                    break;
                }
                case time: {
                    this.makeTimeCoordinate1D(g2, (CoordinateTime)coord);
                    break;
                }
                case vert: {
                    this.makeVerticalCoordinate(g2, (CoordinateVert)coord);
                    break;
                }
                case ens: {
                    this.makeEnsembleCoordinate(g2, (CoordinateEns)coord);
                    break;
                }
                case time2D: {
                    if (gctype.isUniqueTime()) {
                        this.makeUniqueTimeCoordinate2D(g2, (CoordinateTime2D)coord);
                        break;
                    }
                    this.makeTimeCoordinate2D(g2, (CoordinateTime2D)coord, gctype);
                }
            }
        }
        for (GribCollectionImmutable.VariableIndex vindex : group.variList) {
            Formatter dimNames = new Formatter();
            Throwable throwable = null;
            try {
                Formatter coordinateAtt = new Formatter();
                Throwable throwable2 = null;
                try {
                    Coordinate run = vindex.getCoordinate(Coordinate.Type.runtime);
                    CoordinateTimeAbstract time = vindex.getCoordinateTime();
                    if (time == null) {
                        throw new IllegalStateException("No time coordinate = " + vindex);
                    }
                    String timeDimName = time instanceof CoordinateTime2D ? this.make2dValidTimeDimensionName(time.getName()) : time.getName();
                    boolean isRunScaler = run != null && run.getSize() == 1;
                    switch (gctype) {
                        case SRC: {
                            assert (isRunScaler);
                            dimNames.format("%s ", timeDimName);
                            coordinateAtt.format("%s %s ", run.getName(), timeDimName);
                            break;
                        }
                        case MRUTP: 
                        case MRUTC: {
                            dimNames.format("%s ", timeDimName);
                            coordinateAtt.format("ref%s %s ", timeDimName, timeDimName);
                            break;
                        }
                        case MRC: 
                        case TwoD: {
                            assert (run != null) : "GRIB MRC or TWOD does not have run coordinate";
                            if (isRunScaler) {
                                dimNames.format("%s ", timeDimName);
                            } else {
                                dimNames.format("%s %s ", run.getName(), timeDimName);
                            }
                            coordinateAtt.format("%s %s ", run.getName(), timeDimName);
                            break;
                        }
                        case Best: 
                        case BestComplete: {
                            dimNames.format("%s ", timeDimName);
                            coordinateAtt.format("ref%s %s ", timeDimName, timeDimName);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Uknown GribCollection TYpe = " + (Object)((Object)gctype));
                        }
                    }
                    for (Coordinate coord : vindex.getCoordinates()) {
                        if (coord instanceof CoordinateTimeAbstract || coord instanceof CoordinateRuntime) continue;
                        String name = coord.getName().toLowerCase();
                        dimNames.format("%s ", name);
                        coordinateAtt.format("%s ", name);
                    }
                    dimNames.format("%s", horizDims);
                    coordinateAtt.format("%s ", horizDims);
                    String vname = this.iosp.makeVariableName(vindex);
                    Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(vname)).setDataType(DataType.FLOAT)).setDimensionsByName(dimNames.toString());
                    g2.addVariable((Variable.Builder<?>)v);
                    String desc = this.iosp.makeVariableLongName(vindex);
                    ((Variable.Builder)v).addAttribute(new Attribute("long_name", desc));
                    ((Variable.Builder)v).addAttribute(new Attribute("units", this.iosp.makeVariableUnits(vindex)));
                    GribTables.Parameter gp = this.iosp.getParameter(vindex);
                    if (gp != null) {
                        if (gp.getDescription() != null) {
                            ((Variable.Builder)v).addAttribute(new Attribute("description", gp.getDescription()));
                        }
                        if (gp.getAbbrev() != null) {
                            ((Variable.Builder)v).addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                        }
                        ((Variable.Builder)v).addAttribute(new Attribute("missing_value", gp.getMissing()));
                        if (gp.getFill() != null) {
                            ((Variable.Builder)v).addAttribute(new Attribute("_FillValue", gp.getFill()));
                        }
                    } else {
                        ((Variable.Builder)v).addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
                    }
                    if (isLatLon2D) {
                        String s2 = this.iosp.searchCoord(Grib2Utils.getLatLon2DcoordType(desc), group.variList);
                        if (s2 == null) {
                            ((Variable.Builder)v).setDimensionsByName(horizDims);
                            String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                            ((Variable.Builder)v).addAttribute(new Attribute("units", units));
                        } else {
                            coordinateAtt.format("%s ", s2);
                        }
                    } else {
                        ((Variable.Builder)v).addAttribute(new Attribute("grid_mapping", grid_mapping));
                    }
                    ((Variable.Builder)v).addAttribute(new Attribute("coordinates", coordinateAtt.toString()));
                    if (vindex.getIntvType() >= 0) {
                        GribStatType statType = this.gribTable.getStatType(vindex.getIntvType());
                        if (statType != null) {
                            ((Variable.Builder)v).addAttribute(new Attribute("Grib_Statistical_Interval_Type", statType.toString()));
                            CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                            Coordinate timeCoord = vindex.getCoordinate(Coordinate.Type.timeIntv);
                            if (cm != null && timeCoord != null) {
                                ((Variable.Builder)v).addAttribute(new Attribute("cell_methods", timeCoord.getName() + ": " + (Object)((Object)cm)));
                            }
                        } else {
                            ((Variable.Builder)v).addAttribute(new Attribute("Grib_Statistical_Interval_Type", vindex.getIntvType()));
                        }
                    }
                    this.gribCollection.addVariableAttributes(((Variable.Builder)v).getAttributeContainer(), vindex);
                    ((Variable.Builder)v).setSPobject(vindex);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (coordinateAtt == null) continue;
                    if (throwable2 != null) {
                        try {
                            coordinateAtt.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    coordinateAtt.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (dimNames == null) continue;
                if (throwable != null) {
                    try {
                        dimNames.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                dimNames.close();
            }
        }
    }

    private void makeRuntimeCoordinate(Group.Builder g2, CoordinateRuntime rtc) {
        String dims;
        int n = rtc.getSize();
        boolean isScalar = n == 1;
        String tcName = rtc.getName();
        String string = dims = isScalar ? null : rtc.getName();
        if (!isScalar) {
            g2.addDimension(new Dimension(tcName, n));
        }
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("units", rtc.getUnit()));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB reference time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.reftime, null, rtc));
    }

    private void makeUniqueTimeCoordinate2D(Group.Builder g2, CoordinateTime2D time2D) {
        String refName;
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int countU = 0;
        for (int run = 0; run < time2D.getNruns(); ++run) {
            CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
            countU += timeCoord.getSize();
        }
        int ntimes = countU;
        String tcName = time2D.getName();
        String timeDimName = this.make2dValidTimeDimensionName(tcName);
        g2.addDimension(new Dimension(timeDimName, ntimes));
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setDimensionsByName(timeDimName);
        g2.addVariable((Variable.Builder<?>)v);
        String units = runtime.getUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.offU, time2D, null));
        } else {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.intvU, time2D, null));
            String bounds_name = timeDimName + "_bounds";
            Object bounds = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(bounds_name)).setDataType(DataType.DOUBLE)).setDimensionsByName(timeDimName + " 2");
            g2.addVariable((Variable.Builder<?>)bounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", bounds_name));
            ((Variable.Builder)bounds).addAttribute(new Attribute("units", units));
            ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + tcName));
            ((Variable.Builder)bounds).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.boundsU, time2D, null));
        }
        if (runtime.getNCoords() != 1 && !g2.findVariable(refName = "ref" + tcName).isPresent()) {
            Object vref = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(refName)).setDataType(DataType.DOUBLE)).setDimensionsByName(timeDimName);
            g2.addVariable((Variable.Builder<?>)vref);
            ((Variable.Builder)vref).addAttribute(new Attribute("standard_name", "forecast_reference_time"));
            ((Variable.Builder)vref).addAttribute(new Attribute("long_name", "GRIB reference time"));
            ((Variable.Builder)vref).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
            ((Variable.Builder)vref).addAttribute(new Attribute("units", units));
            ((Variable.Builder)vref).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.isUniqueRuntime, time2D, null));
        }
    }

    private String make2dValidTimeDimensionName(String variableName) {
        return variableName.replaceFirst("valid", "");
    }

    private void makeTimeCoordinate2D(Group.Builder g2, CoordinateTime2D time2D, GribCollectionImmutable.Type gctype) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int ntimes = time2D.getNtimes();
        String tcName = time2D.getName();
        String timeDimName = this.make2dValidTimeDimensionName(tcName);
        String dims = runtime.getName() + " " + timeDimName;
        int dimLength = ntimes;
        g2.addDimension(new Dimension(timeDimName, dimLength));
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        String units = runtime.getUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!tcName.equalsIgnoreCase(timeDimName)) {
            ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        }
        if (!time2D.isTimeInterval()) {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.off, time2D, null));
        } else {
            ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.intv, time2D, null));
            String bounds_name = timeDimName + "_bounds";
            Object bounds = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(bounds_name)).setDataType(DataType.DOUBLE)).setDimensionsByName(dims + " 2");
            g2.addVariable((Variable.Builder<?>)bounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", bounds_name));
            ((Variable.Builder)bounds).addAttribute(new Attribute("units", units));
            ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + tcName));
            ((Variable.Builder)bounds).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.bounds, time2D, null));
        }
    }

    private Array makeLazyCoordinateData(Variable v2, GribIosp.Time2Dinfo info) {
        if (info.time2D != null) {
            return this.makeLazyTime2Darray(v2, info);
        }
        return this.makeLazyTime1Darray(v2, info);
    }

    private Array makeLazyTime1Darray(Variable v2, GribIosp.Time2Dinfo info) {
        int length = info.time1D.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case reftime: {
                CoordinateRuntime rtc = (CoordinateRuntime)info.time1D;
                int count = 0;
                for (double val : rtc.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
            case timeAuxRef: {
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)info.time1D;
                int count = 0;
                List<Double> masterOffsets = this.gribCollection.getMasterRuntime().getOffsetsInTimeUnits();
                for (int masterIdx : time.getTime2runtime()) {
                    data[count++] = masterOffsets.get(masterIdx - 1);
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
        }
        throw new IllegalStateException("makeLazyTime1Darray must be reftime or timeAuxRef");
    }

    private Array makeLazyTime2Darray(Variable coord, GribIosp.Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        CalendarPeriod timeUnit = time2D.getTimeUnit();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int length = (int)coord.getSize();
        if (info.which == GribIosp.Time2DinfoType.bounds) {
            length *= 2;
        }
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case offU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    for (int val : coordTime.getOffsetSorted()) {
                        data[count++] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case intv: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case intvU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case is1Dtime: {
                CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
                int count = 0;
                for (double val : runtime.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                break;
            }
            case isUniqueRuntime: {
                CoordinateRuntime runtimeU = time2D.getRuntimeCoordinate();
                List<Double> runOffsets = runtimeU.getOffsetsInTimeUnits();
                int count = 0;
                for (int run = 0; run < time2D.getNruns(); ++run) {
                    CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
                    for (int time = 0; time < timeCoord.getNCoords(); ++time) {
                        data[count++] = runOffsets.get(run);
                    }
                }
                break;
            }
            case bounds: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                break;
            }
            case boundsU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Array.factory(DataType.DOUBLE, coord.getShape(), (Object)data);
    }

    private void makeTimeCoordinate1D(Group.Builder g2, CoordinateTime coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        g2.addDimension(new Dimension(tcName, ntimes));
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        String units = coordTime.getTimeUdUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (int val : coordTime.getOffsetSorted()) {
            data[count++] = val;
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data), false);
        this.makeTimeAuxReference(g2, tcName, units, coordTime);
    }

    private void makeTimeAuxReference(Group.Builder g2, String timeName, String units, CoordinateTimeAbstract time) {
        if (time.getTime2runtime() == null) {
            return;
        }
        String tcName = "ref" + timeName;
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setDimensionsByName(timeName);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB reference time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).setSPobject(new GribIosp.Time2Dinfo(GribIosp.Time2DinfoType.timeAuxRef, null, time));
    }

    private void makeTimeCoordinate1D(Group.Builder g2, CoordinateTimeIntv coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        g2.addDimension(new Dimension(tcName, ntimes));
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(tcName)).setDataType(DataType.DOUBLE)).setDimensionsByName(dims);
        g2.addVariable((Variable.Builder<?>)v);
        String units = coordTime.getTimeUdUnit();
        ((Variable.Builder)v).addAttribute(new Attribute("units", units));
        ((Variable.Builder)v).addAttribute(new Attribute("standard_name", "time"));
        ((Variable.Builder)v).addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        ((Variable.Builder)v).addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds2();
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data), false);
        String bounds_name = tcName + "_bounds";
        Object bounds = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(bounds_name)).setDataType(DataType.DOUBLE)).setDimensionsByName(dims + " 2");
        g2.addVariable((Variable.Builder<?>)bounds);
        ((Variable.Builder)v).addAttribute(new Attribute("bounds", bounds_name));
        ((Variable.Builder)bounds).addAttribute(new Attribute("units", units));
        ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + tcName));
        data = new double[ntimes * 2];
        count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds1();
            data[count++] = tinv.getBounds2();
        }
        ((Variable.Builder)bounds).setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes, 2}, (Object)data), false);
        this.makeTimeAuxReference(g2, tcName, units, coordTime);
    }

    private void makeVerticalCoordinate(Group.Builder g2, CoordinateVert vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        g2.addDimension(new Dimension(vcName, n));
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(vcName)).setDataType(DataType.FLOAT)).setDimensionsByName(vcName);
        g2.addVariable((Variable.Builder<?>)v);
        if (vc.getUnit() != null) {
            ((Variable.Builder)v).addAttribute(new Attribute("units", vc.getUnit()));
            String desc = this.iosp.getVerticalCoordDesc(vc.getCode());
            if (desc != null) {
                ((Variable.Builder)v).addAttribute(new Attribute("long_name", desc));
            }
            ((Variable.Builder)v).addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        ((Variable.Builder)v).addAttribute(new Attribute("Grib_level_type", vc.getCode()));
        VertCoordType vu = vc.getVertUnit();
        if (vu != null && vu.getDatum() != null) {
            ((Variable.Builder)v).addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            ((Variable.Builder)v).setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data), false);
            Object bounds = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(vcName + "_bounds")).setDataType(DataType.FLOAT)).setDimensionsByName(vcName + " 2");
            g2.addVariable((Variable.Builder<?>)bounds);
            ((Variable.Builder)v).addAttribute(new Attribute("bounds", vcName + "_bounds"));
            String vcUnit = vc.getUnit();
            if (vcUnit != null) {
                ((Variable.Builder)bounds).addAttribute(new Attribute("units", vcUnit));
            }
            ((Variable.Builder)bounds).addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoordValue level : vc.getLevelSorted()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            ((Variable.Builder)bounds).setCachedData(Array.factory(DataType.FLOAT, new int[]{n, 2}, (Object)data), false);
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)val.getValue1();
            }
            ((Variable.Builder)v).setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data), false);
        }
    }

    private void makeEnsembleCoordinate(Group.Builder g2, CoordinateEns ec) {
        int n = ec.getSize();
        String ecName = ec.getName().toLowerCase();
        g2.addDimension(new Dimension(ecName, n));
        Object v = ((Variable.Builder)((Variable.Builder)Variable.builder().setName(ecName)).setDataType(DataType.INT)).setDimensionsByName(ecName);
        g2.addVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        int[] data = new int[n];
        int count = 0;
        for (EnsCoordValue ecc : ec.getEnsSorted()) {
            data[count++] = ecc.getEnsMember();
        }
        ((Variable.Builder)v).setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data), false);
    }
}

