/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.StringLocker;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3headerNew;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.iosp.netcdf3.SPFactory;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.IO;
import ucar.nc2.util.Indent;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.rc.RC;
import ucar.unidata.io.InMemoryRandomAccessFile;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.http.HTTPRandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class NetcdfFile
implements FileCacheable,
Closeable {
    private static final Logger log;
    public static final String IOSP_MESSAGE_ADD_RECORD_STRUCTURE = "AddRecordStructure";
    public static final String IOSP_MESSAGE_CONVERT_RECORD_STRUCTURE = "ConvertRecordStructure";
    public static final String IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE = "RemoveRecordStructure";
    public static final String IOSP_MESSAGE_RANDOM_ACCESS_FILE = "RandomAccessFile";
    private static final int default_buffersize = 8092;
    private static final List<IOServiceProvider> registeredProviders;
    private static final StringLocker stringLocker;
    protected static boolean debugSPI;
    protected static boolean debugCompress;
    protected static boolean showRequest;
    static boolean debugStructureIterator;
    static boolean loadWarnings;
    private static boolean userLoads;
    private static final String reservedFullName = ".\\";
    private static final String reservedSectionSpec = "();,.\\";
    private static final String reservedCdl = "[ !\"#$%&'()*,:;<=>?[]^`{|}~\\";
    protected String location;
    protected String id;
    protected String title;
    protected Group rootGroup = this.makeRootGroup();
    protected IOServiceProvider iosp;
    private boolean immutable;
    private String cacheName;
    protected FileCacheIF cache;
    protected List<Variable> variables;
    protected List<Dimension> dimensions;
    protected List<Attribute> gattributes;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugSPI = debugFlag.isSet("NetcdfFile/debugSPI");
        debugCompress = debugFlag.isSet("NetcdfFile/debugCompress");
        debugStructureIterator = debugFlag.isSet("NetcdfFile/structureIterator");
        N3header.disallowFileTruncation = debugFlag.isSet("NetcdfFile/disallowFileTruncation");
        N3headerNew.disallowFileTruncation = debugFlag.isSet("NetcdfFile/disallowFileTruncation");
        N3header.debugHeaderSize = debugFlag.isSet("NetcdfFile/debugHeaderSize");
        N3headerNew.debugHeaderSize = debugFlag.isSet("NetcdfFile/debugHeaderSize");
        showRequest = debugFlag.isSet("NetcdfFile/showRequest");
    }

    @Deprecated
    public static void registerIOProvider(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> ioClass = NetcdfFile.class.getClassLoader().loadClass(className);
        NetcdfFile.registerIOProvider(ioClass);
    }

    @Deprecated
    public static void registerIOProvider(Class iospClass) throws IllegalAccessException, InstantiationException {
        NetcdfFile.registerIOProvider(iospClass, false);
    }

    @Deprecated
    public static void registerIOProvider(Class iospClass, boolean last) throws IllegalAccessException, InstantiationException {
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (userLoads && !last) {
            registeredProviders.add(0, spi);
        } else {
            registeredProviders.add(spi);
        }
    }

    @Deprecated
    public static void registerIOProviderPreferred(Class iospClass, Class target) throws IllegalAccessException, InstantiationException {
        NetcdfFile.iospDeRegister(iospClass);
        int pos = -1;
        for (int i = 0; i < registeredProviders.size(); ++i) {
            IOServiceProvider candidate = registeredProviders.get(i);
            if (candidate.getClass() != target) continue;
            if (pos >= i) break;
            pos = i;
            break;
        }
        if (pos < 0) {
            pos = 0;
        }
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        registeredProviders.add(pos, spi);
    }

    @Deprecated
    public static boolean iospRegistered(Class iospClass) {
        for (IOServiceProvider spi : registeredProviders) {
            if (spi.getClass() != iospClass) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean iospDeRegister(Class iospClass) {
        for (int i = 0; i < registeredProviders.size(); ++i) {
            IOServiceProvider spi = registeredProviders.get(i);
            if (spi.getClass() != iospClass) continue;
            registeredProviders.remove(i);
            return true;
        }
        return false;
    }

    @Deprecated
    public static void setProperty(String name, String value) {
        N3iosp.setProperty(name, value);
    }

    @Deprecated
    public static NetcdfFile open(String location) throws IOException {
        return NetcdfFile.open(location, null);
    }

    @Deprecated
    public static NetcdfFile open(String location, CancelTask cancelTask) throws IOException {
        return NetcdfFile.open(location, -1, cancelTask);
    }

    @Deprecated
    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask) throws IOException {
        return NetcdfFile.open(location, buffer_size, cancelTask, null);
    }

    @Deprecated
    public static NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        RandomAccessFile raf = NetcdfFile.getRaf(location, buffer_size);
        try {
            return NetcdfFile.open(raf, location, cancelTask, iospMessage);
        }
        catch (Throwable t) {
            raf.close();
            throw new IOException(t);
        }
    }

    @Deprecated
    public static boolean canOpen(String location) throws IOException {
        try (RandomAccessFile raf = NetcdfFile.getRaf(location, -1);){
            boolean bl = raf != null && NetcdfFile.canOpen(raf);
            return bl;
        }
    }

    private static boolean canOpen(RandomAccessFile raf) throws IOException {
        if (N3header.isValidFile(raf)) {
            return true;
        }
        for (IOServiceProvider iosp : ServiceLoader.load(IOServiceProvider.class)) {
            log.info("ServiceLoader IOServiceProvider {}", (Object)iosp.getClass().getName());
            System.out.printf("ServiceLoader IOServiceProvider found %s%n", iosp.getClass().getName());
            if (!iosp.isValidFile(raf)) continue;
            return true;
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (!registeredSpi.isValidFile(raf)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static NetcdfFile open(String location, String iospClassName, int bufferSize, CancelTask cancelTask, Object iospMessage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (bufferSize <= 0) {
            bufferSize = 8092;
        }
        RandomAccessFile raf = RandomAccessFile.acquire(NetcdfFile.canonicalizeUriString(location), bufferSize);
        NetcdfFile result = new NetcdfFile(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    @Deprecated
    public static String canonicalizeUriString(String location) {
        String uriString = location.trim();
        if (uriString.startsWith("file://")) {
            uriString = uriString.substring(7);
        } else if (uriString.startsWith("file:")) {
            uriString = uriString.substring(5);
        }
        return StringUtil2.replace(uriString, '\\', "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RandomAccessFile getRaf(String location, int buffer_size) throws IOException {
        RandomAccessFile raf;
        String uriString = location.trim();
        if (buffer_size <= 0) {
            buffer_size = 8092;
        }
        if (uriString.startsWith("http:") || uriString.startsWith("https:")) {
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("nodods:")) {
            uriString = "http" + uriString.substring(6);
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("httpserver:")) {
            uriString = "http" + uriString.substring(10);
            raf = new HTTPRandomAccessFile(uriString);
        } else if (uriString.startsWith("slurp:")) {
            uriString = "http" + uriString.substring(5);
            byte[] contents = IO.readURLContentsToByteArray(uriString);
            raf = new InMemoryRandomAccessFile(uriString, contents);
        } else {
            if ((uriString = StringUtil2.replace(uriString, '\\', "/")).startsWith("file:")) {
                uriString = StringUtil2.unescape(uriString.substring(5));
            }
            String uncompressedFileName = null;
            try {
                stringLocker.control(uriString);
                uncompressedFileName = NetcdfFile.makeUncompressed(uriString);
            }
            catch (Exception e) {
                log.warn("Failed to uncompress {}, err= {}; try as a regular file.", (Object)uriString, (Object)e.getMessage());
            }
            finally {
                stringLocker.release(uriString);
            }
            raf = uncompressedFileName != null ? RandomAccessFile.acquire(uncompressedFileName, buffer_size) : RandomAccessFile.acquire(uriString, buffer_size);
        }
        return raf;
    }

    /*
     * Exception decompiling
     */
    private static String makeUncompressed(String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [72[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    @Deprecated
    public static NetcdfFile openInMemory(String name, byte[] data, String iospClassName) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        Class<?> iospClass = NetcdfFile.class.getClassLoader().loadClass(iospClassName);
        IOServiceProvider spi = (IOServiceProvider)iospClass.newInstance();
        return new NetcdfFile(spi, raf, name, null);
    }

    @Deprecated
    public static NetcdfFile openInMemory(String name, byte[] data) throws IOException {
        InMemoryRandomAccessFile raf = new InMemoryRandomAccessFile(name, data);
        return NetcdfFile.open(raf, name, null, null);
    }

    @Deprecated
    public static NetcdfFile openInMemory(String filename) throws IOException {
        File file = new File(filename);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));){
            IO.copy(in, bos);
        }
        return NetcdfFile.openInMemory(filename, bos.toByteArray());
    }

    @Deprecated
    public static NetcdfFile openInMemory(URI uri) throws IOException {
        byte[] contents;
        URL url = uri.toURL();
        try (InputStream in = url.openStream();){
            contents = IO.readContentsToByteArray(in);
        }
        return NetcdfFile.openInMemory(uri.toString(), contents);
    }

    @Deprecated
    public static NetcdfFile open(RandomAccessFile raf, String location, CancelTask cancelTask, Object iospMessage) throws IOException {
        IOServiceProvider spi = NetcdfFile.getIosp(raf);
        if (spi == null) {
            raf.close();
            throw new IOException("Cant read " + location + ": not a valid CDM file.");
        }
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        if (log.isDebugEnabled()) {
            log.debug("Using IOSP {}", (Object)spi.getClass().getName());
        }
        NetcdfFile result = new NetcdfFile(spi, raf, location, cancelTask);
        if (iospMessage != null) {
            spi.sendIospMessage(iospMessage);
        }
        return result;
    }

    private static IOServiceProvider getIosp(RandomAccessFile raf) throws IOException {
        if (debugSPI) {
            log.info("NetcdfFile try to open = {}", (Object)raf.getLocation());
        }
        for (IOServiceProvider registeredSpi : registeredProviders) {
            if (debugSPI) {
                log.info(" try iosp = {}", (Object)registeredSpi.getClass().getName());
            }
            if (!registeredSpi.isValidFile(raf)) continue;
            Class<?> c = registeredSpi.getClass();
            try {
                return (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        if (N3header.isValidFile(raf)) {
            return SPFactory.getServiceProvider();
        }
        if (H5header.isValidFile(raf)) {
            return new H5iosp();
        }
        for (IOServiceProvider loadedSpi : ServiceLoader.load(IOServiceProvider.class)) {
            if (!loadedSpi.isValidFile(raf)) continue;
            Class<?> c = loadedSpi.getClass();
            try {
                return (IOServiceProvider)c.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
            }
            catch (IllegalAccessException e) {
                throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cache != null && this.cache.release(this)) {
            return;
        }
        try {
            if (null != this.iosp) {
                this.iosp.close();
            }
        }
        finally {
            this.iosp = null;
        }
    }

    @Override
    public void release() throws IOException {
        if (this.iosp != null) {
            this.iosp.release();
        }
    }

    @Override
    public void reacquire() throws IOException {
        if (this.iosp != null) {
            this.iosp.reacquire();
        }
    }

    @Override
    @Deprecated
    public synchronized void setFileCache(FileCacheIF cache) {
        this.cache = cache;
    }

    @Deprecated
    public String getCacheName() {
        return this.cacheName;
    }

    @Deprecated
    protected void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public Group getRootGroup() {
        return this.rootGroup;
    }

    @Nullable
    public Group findGroup(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return this.rootGroup;
        }
        Group g2 = this.rootGroup;
        StringTokenizer stoke = new StringTokenizer(fullName, "/");
        while (stoke.hasMoreTokens()) {
            String groupName = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
            if ((g2 = g2.findGroup(groupName)) != null) continue;
            return null;
        }
        return g2;
    }

    @Nullable
    public Variable findVariable(Group g2, String shortName) {
        if (g2 == null) {
            return this.findVariable(shortName);
        }
        return g2.findVariable(shortName);
    }

    @Nullable
    public Variable findVariable(String fullNameEscaped) {
        List<String> snames;
        if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
            return null;
        }
        Group g2 = this.rootGroup;
        String vars = fullNameEscaped;
        int pos = fullNameEscaped.lastIndexOf(47);
        if (pos >= 0) {
            String groups = fullNameEscaped.substring(0, pos);
            vars = fullNameEscaped.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                if ((g2 = g2.findGroup(token)) != null) continue;
                return null;
            }
        }
        if ((snames = EscapeStrings.tokenizeEscapedName(vars)).isEmpty()) {
            return null;
        }
        String varShortName = NetcdfFiles.makeNameUnescaped(snames.get(0));
        Variable v = g2.findVariable(varShortName);
        if (v == null) {
            return null;
        }
        int memberCount = 1;
        while (memberCount < snames.size()) {
            String name;
            if (!(v instanceof Structure)) {
                return null;
            }
            if ((v = ((Structure)v).findVariable(name = NetcdfFiles.makeNameUnescaped(snames.get(memberCount++)))) != null) continue;
            return null;
        }
        return v;
    }

    @Nullable
    public Variable findVariableByAttribute(Group g2, String attName, String attValue) {
        if (g2 == null) {
            g2 = this.getRootGroup();
        }
        for (Variable v : g2.getVariables()) {
            for (Attribute att : v.attributes()) {
                if (!attName.equals(att.getShortName()) || !attValue.equals(att.getStringValue())) continue;
                return v;
            }
        }
        for (Group nested : g2.getGroups()) {
            Variable v = this.findVariableByAttribute(nested, attName, attValue);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public Dimension findDimension(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        Group group = this.rootGroup;
        String dimShortName = fullName;
        int pos = fullName.lastIndexOf(47);
        if (pos >= 0) {
            String groups = fullName.substring(0, pos);
            dimShortName = fullName.substring(pos + 1);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                if ((group = group.findGroup(token)) != null) continue;
                return null;
            }
        }
        return group.findDimensionLocal(dimShortName);
    }

    public boolean hasUnlimitedDimension() {
        return this.getUnlimitedDimension() != null;
    }

    @Nullable
    public Dimension getUnlimitedDimension() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return d;
        }
        return null;
    }

    public List<Dimension> getDimensions() {
        return this.immutable ? this.dimensions : new ArrayList<Dimension>(this.dimensions);
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    @Deprecated
    public List<Attribute> getGlobalAttributes() {
        return this.immutable ? this.gattributes : new ArrayList<Attribute>(this.gattributes);
    }

    @Nullable
    public Attribute findGlobalAttribute(String name) {
        for (Attribute a : this.gattributes) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        for (Attribute a : this.gattributes) {
            if (!name.equalsIgnoreCase(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public Attribute findAttribute(String fullNameEscaped) {
        String varName;
        if (fullNameEscaped == null || fullNameEscaped.isEmpty()) {
            return null;
        }
        int posAtt = fullNameEscaped.indexOf(64);
        if (posAtt < 0 || posAtt >= fullNameEscaped.length() - 1) {
            return null;
        }
        if (posAtt == 0) {
            return this.findGlobalAttribute(fullNameEscaped.substring(1));
        }
        String path = fullNameEscaped.substring(0, posAtt);
        String attName = fullNameEscaped.substring(posAtt + 1);
        Group g2 = this.rootGroup;
        int pos = path.lastIndexOf(47);
        String string = varName = pos > 0 && pos < path.length() - 1 ? path.substring(pos + 1) : null;
        if (pos >= 0) {
            String groups = path.substring(0, pos);
            StringTokenizer stoke = new StringTokenizer(groups, "/");
            while (stoke.hasMoreTokens()) {
                String token = NetcdfFiles.makeNameUnescaped(stoke.nextToken());
                if ((g2 = g2.findGroup(token)) != null) continue;
                return null;
            }
        }
        if (varName == null) {
            return g2.findAttribute(attName);
        }
        List<String> snames = EscapeStrings.tokenizeEscapedName(varName);
        if (snames.isEmpty()) {
            return null;
        }
        String varShortName = NetcdfFiles.makeNameUnescaped(snames.get(0));
        Variable v = g2.findVariable(varShortName);
        if (v == null) {
            return null;
        }
        int memberCount = 1;
        while (memberCount < snames.size()) {
            String name;
            if (!(v instanceof Structure)) {
                return null;
            }
            if ((v = ((Structure)v).findVariable(name = NetcdfFiles.makeNameUnescaped(snames.get(memberCount++)))) != null) continue;
            return null;
        }
        return v.findAttribute(attName);
    }

    @Deprecated
    public String findAttValueIgnoreCase(Variable v, String attName, String defaultValue) {
        if (v == null) {
            return this.rootGroup.attributes().findAttValueIgnoreCase(attName, defaultValue);
        }
        return v.attributes().findAttValueIgnoreCase(attName, defaultValue);
    }

    @Deprecated
    public double readAttributeDouble(Variable v, String attName, double defValue) {
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    @Deprecated
    public int readAttributeInteger(Variable v, String attName, int defValue) {
        Attribute att = v == null ? this.rootGroup.findAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Integer.parseInt(att.getStringValue());
        }
        return att.getNumericValue().intValue();
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), false);
        return f.toString();
    }

    @Deprecated
    public String toNcML(String url) {
        NcMLWriter ncmlWriter = new NcMLWriter();
        ncmlWriter.setWriteVariablesPredicate(NcMLWriter.writeNoVariablesPredicate);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(this, url);
        return ncmlWriter.writeToString(netcdfElement);
    }

    @Deprecated
    public void writeCDL(OutputStream out, boolean strict) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.toStringStart(pw, strict);
        this.toStringEnd(pw);
        pw.flush();
    }

    @Deprecated
    public void writeCDL(PrintWriter pw, boolean strict) {
        this.toStringStart(pw, strict);
        this.toStringEnd(pw);
        pw.flush();
    }

    void toStringStart(PrintWriter pw, boolean strict) {
        Formatter f = new Formatter();
        this.toStringStart(f, new Indent(2), strict);
        pw.write(f.toString());
    }

    void toStringEnd(PrintWriter pw) {
        pw.print("}\n");
    }

    protected void writeCDL(Formatter f, Indent indent, boolean strict) {
        this.toStringStart(f, indent, strict);
        f.format("%s}%n", indent);
    }

    private void toStringStart(Formatter f, Indent indent, boolean strict) {
        String name = this.getLocation();
        if (strict) {
            if (name.endsWith(".nc")) {
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(".cdl")) {
                name = name.substring(0, name.length() - 4);
            }
            name = NetcdfFile.makeValidCDLName(name);
        }
        f.format("%snetcdf %s {%n", indent, name);
        indent.incr();
        this.rootGroup.writeCDL(f, indent, strict);
        indent.decr();
    }

    @Deprecated
    public void writeNcML(OutputStream os, String uri) throws IOException {
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element netcdfElem = ncmlWriter.makeNetcdfElement(this, uri);
        ncmlWriter.writeToStream(netcdfElem, os);
    }

    @Deprecated
    public void writeNcML(Writer writer, String uri) throws IOException {
        NcMLWriter ncmlWriter = new NcMLWriter();
        Element netcdfElem = ncmlWriter.makeNetcdfElement(this, uri);
        ncmlWriter.writeToWriter(netcdfElem, writer);
    }

    @Deprecated
    public boolean syncExtend() throws IOException {
        return this.iosp != null && this.iosp.syncExtend();
    }

    @Override
    @Deprecated
    public long getLastModified() {
        if (this.iosp != null && this.iosp instanceof AbstractIOServiceProvider) {
            AbstractIOServiceProvider aspi = (AbstractIOServiceProvider)this.iosp;
            return aspi.getLastModified();
        }
        return 0L;
    }

    @Deprecated
    public NetcdfFile(String filename) throws IOException {
        this.location = filename;
        RandomAccessFile raf = RandomAccessFile.acquire(filename);
        this.iosp = SPFactory.getServiceProvider();
        this.iosp.open(raf, this, null);
        this.finish();
    }

    @Deprecated
    public NetcdfFile(URL url) throws IOException {
        this.location = url.toString();
        HTTPRandomAccessFile raf = new HTTPRandomAccessFile(this.location);
        this.iosp = SPFactory.getServiceProvider();
        this.iosp.open(raf, this, null);
        this.finish();
    }

    @Deprecated
    protected NetcdfFile(String iospClassName, Object iospParam, String location, int buffer_size, CancelTask cancelTask) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> iospClass = this.getClass().getClassLoader().loadClass(iospClassName);
        this.iosp = (IOServiceProvider)iospClass.newInstance();
        if (debugSPI) {
            log.info("NetcdfFile uses iosp = {}", (Object)this.iosp.getClass().getName());
        }
        if (iospParam != null) {
            this.iosp.sendIospMessage(iospParam);
        }
        this.location = location;
        RandomAccessFile raf = NetcdfFile.getRaf(location, buffer_size);
        try {
            this.iosp.open(raf, this, cancelTask);
            this.finish();
        }
        catch (IOException | RuntimeException e) {
            try {
                this.iosp.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.iosp = null;
            throw e;
        }
        catch (Throwable t) {
            try {
                this.iosp.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.iosp = null;
            throw new RuntimeException(t);
        }
        if (this.id == null) {
            this.setId(this.rootGroup.findAttValueIgnoreCase("_Id", null));
        }
        if (this.title == null) {
            this.setTitle(this.rootGroup.findAttValueIgnoreCase("_Title", null));
        }
    }

    @Deprecated
    protected NetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
        this.iosp = spi;
        this.location = location;
        if (debugSPI) {
            log.info("NetcdfFile uses iosp = {}", (Object)spi.getClass().getName());
        }
        try {
            spi.open(raf, this, cancelTask);
        }
        catch (IOException | RuntimeException e) {
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.iosp = null;
            throw e;
        }
        catch (Throwable t) {
            try {
                spi.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.iosp = null;
            throw new RuntimeException(t);
        }
        if (this.id == null) {
            this.setId(this.rootGroup.findAttValueIgnoreCase("_Id", null));
        }
        if (this.title == null) {
            this.setTitle(this.rootGroup.findAttValueIgnoreCase("_Title", null));
        }
        this.finish();
    }

    @Deprecated
    protected NetcdfFile(IOServiceProvider spi, String location) {
        this.iosp = spi;
        this.location = location;
    }

    @Deprecated
    protected NetcdfFile() {
    }

    @Deprecated
    protected NetcdfFile(NetcdfFile ncfile) {
        this.location = ncfile.getLocation();
        this.id = ncfile.getId();
        this.title = ncfile.getTitle();
        this.iosp = ncfile.iosp;
    }

    @Deprecated
    public Attribute addAttribute(Group parent, Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addAttribute(att);
        return att;
    }

    @Deprecated
    public Attribute addAttribute(Group parent, String name, String value) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (value == null) {
            return null;
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        Attribute att = new Attribute(name, value);
        parent.addAttribute(att);
        return att;
    }

    @Deprecated
    public Group addGroup(Group parent, Group g2) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addGroup(g2);
        return g2;
    }

    @Deprecated
    public void setRootGroup(Group rootGroup) {
        this.rootGroup = rootGroup;
    }

    @Deprecated
    public Dimension addDimension(Group parent, Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (parent == null) {
            parent = this.rootGroup;
        }
        parent.addDimension(d);
        return d;
    }

    @Deprecated
    public boolean removeDimension(Group g2, String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g2 == null) {
            g2 = this.rootGroup;
        }
        return g2.removeDimension(dimName);
    }

    @Deprecated
    public Variable addVariable(Group g2, Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g2 == null) {
            g2 = this.rootGroup;
        }
        if (v != null) {
            g2.addVariable(v);
        }
        return v;
    }

    @Deprecated
    public Variable addVariable(Group g2, String shortName, DataType dtype, String dims) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g2 == null) {
            g2 = this.rootGroup;
        }
        Variable v = new Variable(this, g2, null, shortName);
        v.setDataType(dtype);
        v.setDimensions(dims);
        g2.addVariable(v);
        return v;
    }

    @Deprecated
    public Variable addStringVariable(Group g2, String shortName, String dims, int strlen) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g2 == null) {
            g2 = this.rootGroup;
        }
        String dimName = shortName + "_strlen";
        this.addDimension(g2, new Dimension(dimName, strlen));
        Variable v = new Variable(this, g2, null, shortName);
        v.setDataType(DataType.CHAR);
        v.setDimensions(dims + " " + dimName);
        g2.addVariable(v);
        return v;
    }

    @Deprecated
    public boolean removeVariable(Group g2, String varName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (g2 == null) {
            g2 = this.rootGroup;
        }
        return g2.removeVariable(varName);
    }

    @Deprecated
    public Attribute addVariableAttribute(Variable v, Attribute att) {
        return v.addAttribute(att);
    }

    @Deprecated
    public Object sendIospMessage(Object message) {
        if (null == message) {
            return null;
        }
        if (message == IOSP_MESSAGE_ADD_RECORD_STRUCTURE) {
            Variable v = this.rootGroup.findVariable("record");
            boolean gotit = v instanceof Structure;
            return gotit || this.makeRecordStructure() != false;
        }
        if (message == IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE) {
            Variable v = this.rootGroup.findVariable("record");
            boolean gotit = v instanceof Structure;
            if (gotit) {
                this.rootGroup.remove(v);
                this.variables.remove(v);
                this.removeRecordStructure();
            }
            return gotit;
        }
        if (this.iosp != null) {
            return this.iosp.sendIospMessage(message);
        }
        return null;
    }

    @Deprecated
    protected Boolean makeRecordStructure() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Boolean didit = false;
        if (this.iosp != null && this.iosp instanceof N3iosp && this.hasUnlimitedDimension()) {
            didit = (Boolean)this.iosp.sendIospMessage(IOSP_MESSAGE_ADD_RECORD_STRUCTURE);
        }
        return didit;
    }

    @Deprecated
    protected Boolean removeRecordStructure() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        Boolean didit = false;
        if (this.iosp != null && this.iosp instanceof N3iosp) {
            didit = (Boolean)this.iosp.sendIospMessage(IOSP_MESSAGE_REMOVE_RECORD_STRUCTURE);
        }
        return didit;
    }

    @Deprecated
    public void setId(String id) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.id = id;
    }

    @Deprecated
    public void setTitle(String title) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.title = title;
    }

    @Deprecated
    public void setLocation(String location) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.location = location;
    }

    @Deprecated
    public NetcdfFile setImmutable() {
        if (this.immutable) {
            return this;
        }
        this.immutable = true;
        this.setImmutable(this.rootGroup);
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.gattributes = Collections.unmodifiableList(this.gattributes);
        return this;
    }

    private void setImmutable(Group g2) {
        for (Variable v : g2.variables) {
            v.setImmutable();
        }
        for (Dimension d : g2.dimensions) {
            d.setImmutable();
        }
        for (Group nested : g2.getGroups()) {
            this.setImmutable(nested);
        }
        g2.setImmutable();
    }

    @Deprecated
    public void empty() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.variables = new ArrayList<Variable>();
        this.gattributes = new ArrayList<Attribute>();
        this.dimensions = new ArrayList<Dimension>();
        this.rootGroup = this.makeRootGroup();
    }

    private Group makeRootGroup() {
        return Group.builder(null).setNcfile(this).setName("").build(null);
    }

    @Deprecated
    public void finish() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.variables = new ArrayList<Variable>();
        this.dimensions = new ArrayList<Dimension>();
        this.gattributes = new ArrayList<Attribute>();
        this.finishGroup(this.rootGroup);
    }

    private void finishGroup(Group g2) {
        String newName;
        this.variables.addAll(g2.variables);
        for (Attribute oldAtt : g2.attributes()) {
            if (g2 == this.rootGroup) {
                this.gattributes.add(oldAtt);
                continue;
            }
            newName = this.makeFullNameWithString(g2, oldAtt.getShortName());
            this.gattributes.add(oldAtt.toBuilder().setName(newName).build());
        }
        for (Dimension oldDim : g2.dimensions) {
            if (!oldDim.isShared()) continue;
            if (g2 == this.rootGroup) {
                this.dimensions.add(oldDim);
                continue;
            }
            newName = this.makeFullNameWithString(g2, oldDim.getShortName());
            this.dimensions.add(oldDim.toBuilder().setName(newName).build());
        }
        List<Group> groups = g2.getGroups();
        for (Group nested : groups) {
            this.finishGroup(nested);
        }
    }

    protected Array readData(Variable v, Section ranges) throws IOException, InvalidRangeException {
        long start = 0L;
        if (showRequest) {
            log.info("Data request for variable: {} section {}...", (Object)v.getFullName(), (Object)ranges);
            start = System.currentTimeMillis();
        }
        if (this.iosp == null) {
            throw new IOException("iosp is null, perhaps file has been closed. Trying to read variable " + v.getFullName());
        }
        Array result = this.iosp.readData(v, ranges);
        if (showRequest) {
            long took = System.currentTimeMillis() - start;
            log.info(" ...took= {} msecs", (Object)took);
        }
        return result;
    }

    public Array readSection(String variableSection) throws IOException, InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection(this, variableSection);
        if (cer.child == null) {
            return cer.v.read(cer.section);
        }
        if (this.iosp == null) {
            return IospHelper.readSection(cer);
        }
        return this.iosp.readSection(cer);
    }

    @Deprecated
    protected long readToByteChannel(Variable v, Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        if (this.iosp == null || v.hasCachedData()) {
            return IospHelper.copyToByteChannel(v.read(section), wbc);
        }
        return this.iosp.readToByteChannel(v, section, wbc);
    }

    protected long readToOutputStream(Variable v, Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.iosp == null || v.hasCachedData()) {
            return IospHelper.copyToOutputStream(v.read(section), out);
        }
        return this.iosp.readToOutputStream(v, section, out);
    }

    protected StructureDataIterator getStructureIterator(Structure s2, int bufferSize) throws IOException {
        return this.iosp.getStructureIterator(s2, bufferSize);
    }

    @Deprecated
    public List<Array> readArrays(List<Variable> variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (Variable variable : variables) {
            result.add(variable.read());
        }
        return result;
    }

    @Deprecated
    public Array read(String variableSection, boolean flatten) throws IOException, InvalidRangeException {
        if (!flatten) {
            throw new UnsupportedOperationException("NetdfFile.read(String variableSection, boolean flatten=false)");
        }
        return this.readSection(variableSection);
    }

    protected String toStringDebug(Object o) {
        return this.iosp == null ? "" : this.iosp.toStringDebug(o);
    }

    @Deprecated
    public String getDetailInfo() {
        Formatter f = new Formatter();
        this.getDetailInfo(f);
        return f.toString();
    }

    @Deprecated
    public void getDetailInfo(Formatter f) {
        f.format("NetcdfFile location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  fileVersion= %s%n", this.getFileTypeVersion());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.iosp == null) {
            f.format("  has no IOSP%n", new Object[0]);
        } else {
            f.format("  iosp= %s%n%n", this.iosp.getClass());
            f.format("%s", this.iosp.getDetailInfo());
        }
        this.showCached(f);
        this.showProxies(f);
    }

    @Deprecated
    protected void showCached(Formatter f) {
        int maxNameLen = 8;
        for (Variable v : this.getVariables()) {
            maxNameLen = Math.max(maxNameLen, v.getShortName().length());
        }
        long total = 0L;
        long totalCached = 0L;
        f.format("%n%-" + maxNameLen + "s isCaching  size     cachedSize (bytes) %n", "Variable");
        for (Variable v : this.getVariables()) {
            long vtotal = v.getSize() * (long)v.getElementSize();
            total += vtotal;
            f.format(" %-" + maxNameLen + "s %5s %8d ", v.getShortName(), v.isCaching(), vtotal);
            if (v.hasCachedData()) {
                Array data;
                try {
                    data = v.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                long size = data.getSizeBytes();
                f.format(" %8d", size);
                totalCached += size;
            }
            f.format("%n", new Object[0]);
        }
        f.format(" %" + maxNameLen + "s                  --------%n", " ");
        f.format(" %" + maxNameLen + "s total %8d Mb cached= %8d Kb%n", " ", total / 1000L / 1000L, totalCached / 1000L);
    }

    protected void showProxies(Formatter f) {
        int maxNameLen = 8;
        boolean hasProxy = false;
        for (Variable v : this.getVariables()) {
            if (v.proxyReader != v) {
                hasProxy = true;
            }
            maxNameLen = Math.max(maxNameLen, v.getShortName().length());
        }
        if (!hasProxy) {
            return;
        }
        f.format("%n%-" + maxNameLen + "s  proxyReader   Variable.Class %n", "Variable");
        for (Variable v : this.getVariables()) {
            if (v.proxyReader == v) continue;
            f.format(" %-" + maxNameLen + "s  %s %s%n", v.getShortName(), v.proxyReader.getClass().getName(), v.getClass().getName());
        }
        f.format("%n", new Object[0]);
    }

    @Deprecated
    public IOServiceProvider getIosp() {
        return this.iosp;
    }

    public String getFileTypeId() {
        if (this.iosp != null) {
            return this.iosp.getFileTypeId();
        }
        return "N/A";
    }

    public String getFileTypeDescription() {
        if (this.iosp != null) {
            return this.iosp.getFileTypeDescription();
        }
        return "N/A";
    }

    public String getFileTypeVersion() {
        if (this.iosp != null) {
            return this.iosp.getFileTypeVersion();
        }
        return "N/A";
    }

    @Deprecated
    public static String makeValidCdmObjectName(String shortName) {
        if (shortName == null) {
            return null;
        }
        return StringUtil2.makeValidCdmObjectName(shortName);
    }

    @Deprecated
    public static String makeValidCDLName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedCdl);
    }

    @Deprecated
    public static String makeValidPathName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedFullName);
    }

    @Deprecated
    public static String makeValidSectionSpecName(String vname) {
        return EscapeStrings.backslashEscape(vname, reservedSectionSpec);
    }

    @Deprecated
    public static String makeNameUnescaped(String vname) {
        return EscapeStrings.backslashUnescape(vname);
    }

    @Deprecated
    protected static String makeFullName(CDMNode v) {
        return NetcdfFile.makeFullName(v, reservedFullName);
    }

    @Deprecated
    protected static String makeFullNameSectionSpec(CDMNode v) {
        return NetcdfFile.makeFullName(v, reservedSectionSpec);
    }

    @Deprecated
    protected static String makeFullName(CDMNode node, String reservedChars) {
        Group parent = node.getParentGroup();
        if ((parent == null || parent.isRoot()) && !node.isMemberOfStructure()) {
            return EscapeStrings.backslashEscape(node.getShortName(), reservedChars);
        }
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupName(sbuff, parent, reservedChars);
        NetcdfFile.appendStructureName(sbuff, node, reservedChars);
        return sbuff.toString();
    }

    private static void appendGroupName(StringBuilder sbuff, Group g2, String reserved) {
        if (g2 == null) {
            return;
        }
        if (g2.getParentGroup() == null) {
            return;
        }
        NetcdfFile.appendGroupName(sbuff, g2.getParentGroup(), reserved);
        sbuff.append(EscapeStrings.backslashEscape(g2.getShortName(), reserved));
        sbuff.append("/");
    }

    private static void appendStructureName(StringBuilder sbuff, CDMNode n, String reserved) {
        if (n.isMemberOfStructure()) {
            NetcdfFile.appendStructureName(sbuff, n.getParentStructure(), reserved);
            sbuff.append(".");
        }
        sbuff.append(EscapeStrings.backslashEscape(n.getShortName(), reserved));
    }

    @Deprecated
    protected String makeFullNameWithString(Group parent, String name) {
        name = NetcdfFile.makeValidPathName(name);
        StringBuilder sbuff = new StringBuilder();
        NetcdfFile.appendGroupName(sbuff, parent, null);
        sbuff.append(name);
        return sbuff.toString();
    }

    protected NetcdfFile(Builder<?> builder) {
        this.location = builder.location;
        this.id = ((Builder)builder).id;
        this.title = ((Builder)builder).title;
        this.iosp = builder.iosp;
        if (builder.rootGroup != null) {
            builder.rootGroup.setNcfile(this);
            this.rootGroup = builder.rootGroup.build(null);
        }
        if (builder.iosp != null) {
            builder.iosp.setNetcdfFile(this);
            this.iosp = builder.iosp;
        }
        this.finish();
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(NetcdfFile.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return ((Builder)((Builder)((Builder)b.setLocation(this.location).setId(this.id)).setTitle(this.title)).setRootGroup(this.rootGroup.toBuilder())).setIosp((AbstractIOServiceProvider)this.iosp);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    static {
        block5: {
            block4: {
                log = LoggerFactory.getLogger(NetcdfFile.class);
                registeredProviders = new ArrayList<IOServiceProvider>();
                stringLocker = new StringLocker();
                RC.initialize();
                try {
                    NetcdfFile.registerIOProvider("ucar.nc2.stream.NcStreamIosp");
                }
                catch (Throwable e) {
                    if (!loadWarnings) break block4;
                    log.info("Cant load class NcStreamIosp", e);
                }
            }
            try {
                NetcdfFile.registerIOProvider("ucar.nc2.iosp.hdf4.H4iosp");
            }
            catch (Throwable e) {
                if (!loadWarnings) break block5;
                log.info("Cant load class H4iosp", e);
            }
        }
        userLoads = true;
    }

    public static abstract class Builder<T extends Builder<T>> {
        public Group.Builder rootGroup = Group.builder(null).setName("");
        private String id;
        private String title;
        public String location;
        protected AbstractIOServiceProvider iosp;
        private boolean built;

        protected abstract T self();

        public T setRootGroup(Group.Builder rootGroup) {
            this.rootGroup = rootGroup;
            return this.self();
        }

        public T setIosp(AbstractIOServiceProvider iosp) {
            this.iosp = iosp;
            return this.self();
        }

        public T setId(String id) {
            this.id = id;
            return this.self();
        }

        public T setTitle(String title) {
            this.title = title;
            return this.self();
        }

        public T setLocation(String location) {
            this.location = location;
            return this.self();
        }

        public NetcdfFile build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new NetcdfFile(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

