/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import ucar.mcidas.AREAnav;

public final class TANCnav
extends AREAnav {
    int iwest;
    int ihem;
    double lin0;
    double ele0;
    double scale;
    double lon0;
    double lat0;
    double coscl;
    double tancl;
    double tancl2;
    double mxtheta;
    private static double Erad = 6371.2;

    public TANCnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1413566019) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.lin0 = (double)iparms[1] / 10000.0;
        this.ele0 = (double)iparms[2] / 10000.0;
        this.scale = (double)iparms[3] / 10000.0;
        this.lat0 = (double)iparms[4] / 10000.0;
        this.lon0 = (double)iparms[5] / 10000.0;
        if (this.scale <= 0.0 || this.lat0 <= -90.0 || this.lat0 >= 90.0 || this.lat0 == 0.0 || this.lon0 <= -180.0 || this.lon0 >= 180.0) {
            throw new IllegalArgumentException("Invalid nav parameters");
        }
        this.lon0 = -this.lon0 * (Math.PI / 180);
        double colat0 = this.lat0 < 0.0 ? 1.5707963267948966 + this.lat0 * (Math.PI / 180) : 1.5707963267948966 - this.lat0 * (Math.PI / 180);
        this.coscl = Math.cos(colat0);
        this.tancl = Math.tan(colat0);
        this.tancl2 = Math.tan(colat0 / 2.0);
        this.mxtheta = Math.PI * this.coscl;
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double theta_rh;
            double radius;
            double d_lin = imglinele[1][point] - this.lin0;
            double d_ele = imglinele[0][point] - this.ele0;
            if (Math.abs(d_lin) < 0.01 && Math.abs(d_ele) < 0.01) {
                radius = 0.0;
                theta_rh = 0.0;
            } else {
                double dx = this.scale * d_lin;
                double dy = this.scale * d_ele;
                radius = Math.sqrt(dx * dx + dy * dy);
                theta_rh = Math.atan2(dy, dx);
            }
            double theta = this.lat0 < 0.0 ? (theta_rh <= 0.0 ? Math.PI - Math.abs(theta_rh) : -1.0 * (Math.PI - Math.abs(theta_rh))) : theta_rh;
            if (theta <= -this.mxtheta || theta > this.mxtheta) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            double lon = this.lon0 + theta / this.coscl;
            if (lon <= -Math.PI) {
                lon += Math.PI * 2;
            }
            if (lon > Math.PI) {
                lon -= Math.PI * 2;
            }
            double colat = 2.0 * Math.atan(this.tancl2 * Math.pow(radius / (Erad * this.tancl), 1.0 / this.coscl));
            double lat = 90.0 - colat / (Math.PI / 180);
            latlon[0][point] = this.lat0 < 0.0 ? -1.0 * lat : lat;
            latlon[1][point] = lon /= Math.PI / 180;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double lat = latlon[0][point];
            double lon = latlon[1][point];
            if (lat <= -90.0 || lat >= 90.0 || lon <= -360.0 || lon > 360.0) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double colat = this.lat0 < 0.0 ? 1.5707963267948966 + Math.PI / 180 * lat : 1.5707963267948966 - Math.PI / 180 * lat;
            double in_lon = Math.PI / 180 * lon;
            if (in_lon <= -Math.PI) {
                in_lon += Math.PI * 2;
            }
            if (in_lon > Math.PI) {
                in_lon -= Math.PI * 2;
            }
            if (colat == Math.PI) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double radius = Erad * this.tancl * Math.pow(Math.tan(colat / 2.0) / this.tancl2, this.coscl);
            double theta = in_lon - this.lon0;
            if (theta <= -Math.PI) {
                theta += Math.PI * 2;
            }
            if (theta > Math.PI) {
                theta -= Math.PI * 2;
            }
            theta = this.coscl * theta;
            if (this.lat0 < 0.0) {
                theta = Math.PI + theta;
            }
            linele[1][point] = this.lin0 + radius * Math.cos(theta) / this.scale;
            linele[0][point] = this.ele0 + radius * Math.sin(theta) / this.scale;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

