/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.DataInputStream;
import java.io.IOException;
import ucar.mcidas.ConversionUtility;

public class AncillaryData {
    private static final int DIR_SIZE = 64;
    private int numLines = 0;
    private int numElems = 0;
    private int firstImageLine = 0;
    private int firstImageElem = 0;
    private int lineResolution = 0;
    private int elemResolution = 0;
    private int imageDate = 0;
    private int imageTime = 0;
    private int creationDate = 0;
    private int creationTime = 0;
    private int bandCount = 0;
    private int sensorId = 0;
    private int status = 0;
    private int version = 0;
    private int dataWidth = 0;
    private int numBands = 0;
    private int prefixSize = 0;
    private int projectNum = 0;
    private int bandMap = 0;
    private int calType = 0;
    private int navOffset = 0;
    private int calOffset = 0;
    private int datOffset = 0;
    private boolean swapWords = false;

    public AncillaryData(DataInputStream dis) throws IOException {
        int[] directory = new int[64];
        for (int i = 0; i < 64; ++i) {
            directory[i] = dis.readInt();
        }
        if (directory[1] > 255) {
            ConversionUtility.swap(directory, 0, 19);
            if ((directory[20] & 0xFFFF) == 0) {
                ConversionUtility.swap(directory, 20, 20);
            }
            ConversionUtility.swap(directory, 21, 23);
            ConversionUtility.swap(directory, 32, 50);
            ConversionUtility.swap(directory, 53, 55);
            ConversionUtility.swap(directory, 57, 63);
            this.swapWords = true;
        }
        this.numLines = directory[8];
        this.numElems = directory[9];
        this.firstImageLine = directory[5];
        this.firstImageElem = directory[6];
        this.lineResolution = directory[11];
        this.elemResolution = directory[12];
        this.imageDate = directory[3];
        this.imageTime = directory[4];
        this.bandCount = directory[13];
        this.sensorId = directory[2];
        this.creationDate = directory[16];
        this.creationTime = directory[17];
        this.status = directory[0];
        this.version = directory[1];
        this.dataWidth = directory[10];
        this.numBands = directory[13];
        this.prefixSize = directory[14];
        this.projectNum = directory[15];
        this.bandMap = directory[18];
        this.calType = directory[52];
        this.navOffset = directory[34];
        this.calOffset = directory[62];
        this.datOffset = directory[33];
    }

    public int getCalType() {
        char[] calBuf = new char[]{(char)(this.calType >> 24 & 0xFF), (char)(this.calType >> 16 & 0xFF), (char)(this.calType >> 8 & 0xFF), (char)(this.calType & 0xFF)};
        if (String.valueOf(calBuf).equals("RAW ")) {
            System.out.println("determined input cal type is RAW");
            return 1;
        }
        if (String.valueOf(calBuf).equals("BRIT")) {
            System.out.println("determined input cal type is BRIT");
            return 5;
        }
        if (String.valueOf(calBuf).equals("TEMP")) {
            System.out.println("determined input cal type is TEMP");
            return 4;
        }
        if (String.valueOf(calBuf).equals("RAD ")) {
            System.out.println("determined input cal type is RAD");
            return 2;
        }
        if (String.valueOf(calBuf).equals("ALB")) {
            System.out.println("determined input cal type is ALB");
            return 3;
        }
        return -1;
    }

    public int getSensorId() {
        return this.sensorId;
    }

    public int getNumElements() {
        return this.numElems;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public int getStartLine() {
        return this.firstImageLine;
    }

    public int getStartElem() {
        return this.firstImageElem;
    }

    public int getLineRes() {
        return this.lineResolution;
    }

    public int getElemRes() {
        return this.elemResolution;
    }

    public int getImageDate() {
        return this.imageDate;
    }

    public int getImageTime() {
        return this.imageTime;
    }

    public int getCreationDate() {
        return this.creationDate;
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public int getStatus() {
        return this.status;
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int getPrefixSize() {
        return this.prefixSize;
    }

    public int getProjectNum() {
        return this.projectNum;
    }

    public int getBandMap() {
        return this.bandMap;
    }

    public int getNavOffset() {
        return this.navOffset;
    }

    public int getCalOffset() {
        return this.calOffset;
    }

    public int getDataOffset() {
        return this.datOffset;
    }

    public boolean isSwapped() {
        return this.swapWords;
    }
}

