/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.entropy.encoder;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import ucar.jpeg.jj2000.j2k.codestream.writer.CodestreamWriter;
import ucar.jpeg.jj2000.j2k.codestream.writer.HeaderEncoder;
import ucar.jpeg.jj2000.j2k.encoder.EncoderSpecs;
import ucar.jpeg.jj2000.j2k.entropy.ProgressionSpec;
import ucar.jpeg.jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import ucar.jpeg.jj2000.j2k.entropy.encoder.EBCOTRateAllocator;
import ucar.jpeg.jj2000.j2k.entropy.encoder.LayersInfo;
import ucar.jpeg.jj2000.j2k.image.ImgDataAdapter;
import ucar.jpeg.jj2000.j2k.util.ParameterList;

public abstract class PostCompRateAllocator
extends ImgDataAdapter {
    public static final char OPT_PREFIX = 'A';
    private static final String[][] pinfo = new String[][]{{"Aptype", "[<tile idx>] res|layer|res-pos|pos-comp|comp-pos [res_start comp_start layer_end res_end comp_end prog] [[res_start comp_start ly_end res_end comp_end prog] ...] [[<tile-component idx>] ...]", "Specifies which type of progression should be used when generating the codestream. The 'res' value generates a resolution progressive codestream with the number of layers specified by 'Alayers' option. The 'layer' value generates a layer progressive codestream with multiple layers. In any case the rate-allocation algorithm optimizes for best quality in each layer. The quality measure is mean squared error (MSE) or a weighted version of it (WMSE). If no progression type is specified or imposed by other modules, the default value is 'layer'.\nIt is also possible to describe progression order changes. In this case, 'res_start' is the index (from 0) of the first resolution level, 'comp_start' is the index (from 0) of the first component, 'ly_end' is the index (from 0) of the first layer not included, 'res_end' is the index (from 0) of the first resolution level not included, 'comp_end' is index (from 0) of the first component not included and 'prog' is the progression type to be used for the rest of the tile/image. Several progression order changes can be specified, one after the other.", null}, {"Alayers", "[<rate> [+<layers>] [<rate [+<layers>] [...]] | sl]", "Explicitly specifies the codestream layer formation parameters. The <rate> parameter specifies the bitrate to which the first layer should be optimized. The <layers> parameter, if present, specifies the number of extra layers that should be added for scalability. These extra layers are not optimized. Any extra <rate> and <layers> parameters add more layers, in the same way. An additional layer is always added at the end, which is optimized to the overall target bitrate of the bit stream. Any layers (optimized or not) whose target bitrate is higher that the overall target bitrate are silently ignored. The bitrates of the extra layers that are added through the <layers> parameter are approximately log-spaced between the other target bitrates. If several <rate> [+<layers>] constructs appear the <rate> parameters must appear in increasing order. The rate allocation algorithm ensures that all coded layers have a minimal reasonable size, if not these layers are silently ignored.\nIf the 'sl' (i.e. 'single layer') argument is specified, the generated codestream will only contain one layer (with a bit rate specified thanks to the '-rate' or 'nbytes' options).", "0.015 +20 2.0 +10"}};
    protected CodedCBlkDataSrcEnc src;
    protected EncoderSpecs encSpec;
    protected int numLayers;
    CodestreamWriter bsWriter;
    HeaderEncoder headEnc;

    public PostCompRateAllocator(CodedCBlkDataSrcEnc src, int nl, CodestreamWriter bw, EncoderSpecs encSpec) {
        super(src);
        this.src = src;
        this.encSpec = encSpec;
        this.numLayers = nl;
        this.bsWriter = bw;
    }

    public void setHeaderEncoder(HeaderEncoder headEnc) {
        this.headEnc = headEnc;
    }

    public abstract void initialize() throws IOException;

    public abstract void runAndWrite() throws IOException;

    public int getNumLayers() {
        return this.numLayers;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public static PostCompRateAllocator createInstance(CodedCBlkDataSrcEnc src, ParameterList pl, float rate, CodestreamWriter bw, EncoderSpecs encSpec) {
        pl.checkList('A', ParameterList.toNameArray(pinfo));
        LayersInfo lyrs = PostCompRateAllocator.parseAlayers(pl.getParameter("Alayers"), rate);
        int nTiles = encSpec.nTiles;
        int nComp = encSpec.nComp;
        int numLayers = lyrs.getTotNumLayers();
        encSpec.pocs = new ProgressionSpec(nTiles, nComp, numLayers, encSpec.dls, 2, pl);
        return new EBCOTRateAllocator(src, lyrs, bw, encSpec, pl);
    }

    private static LayersInfo parseAlayers(String params, float rate) {
        LayersInfo lyrs = new LayersInfo(rate);
        StreamTokenizer stok = new StreamTokenizer(new StringReader(params));
        stok.eolIsSignificant(false);
        try {
            stok.nextToken();
        }
        catch (IOException e) {
            throw new Error("An IOException has occurred where it should never occur");
        }
        boolean ratepending = false;
        boolean islayer = false;
        float r = 0.0f;
        while (true) {
            if (stok.ttype == -1) break;
            switch (stok.ttype) {
                case -2: {
                    if (islayer) {
                        try {
                            lyrs.addOptPoint(r, (int)stok.nval);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Error in 'Alayers' option: " + e.getMessage());
                        }
                        ratepending = false;
                        islayer = false;
                        break;
                    }
                    if (ratepending) {
                        try {
                            lyrs.addOptPoint(r, 0);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Error in 'Alayers' option: " + e.getMessage());
                        }
                    }
                    r = (float)stok.nval;
                    ratepending = true;
                    break;
                }
                case 43: {
                    if (!ratepending || islayer) {
                        throw new IllegalArgumentException("Layer parameter without previous rate parameter in 'Alayers' option");
                    }
                    islayer = true;
                    break;
                }
                case -3: {
                    try {
                        stok.nextToken();
                    }
                    catch (IOException e) {
                        throw new Error("An IOException has occurred where it should never occur");
                    }
                    if (stok.ttype == -1) break;
                    throw new IllegalArgumentException("'sl' argument of '-Alayers' option must be used alone.");
                }
                default: {
                    throw new IllegalArgumentException("Error parsing 'Alayers' option");
                }
            }
            try {
                stok.nextToken();
            }
            catch (IOException e) {
                throw new Error("An IOException has occurred where it should never occur");
            }
        }
        if (islayer) {
            throw new IllegalArgumentException("Error parsing 'Alayers' option");
        }
        if (ratepending) {
            try {
                lyrs.addOptPoint(r, 0);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error in 'Alayers' option: " + e.getMessage());
            }
        }
        return lyrs;
    }
}

