/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.rewrite;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class Rewrite {
    static final boolean NETCDF4 = true;
    NetcdfFile ncIn;
    NetcdfFileWriter ncOut;
    NetcdfFileWriter.Version version;
    boolean isRadial;
    private int anon;

    public Rewrite(NetcdfFile ncIn, NetcdfFileWriter ncOut) {
        this.ncIn = ncIn;
        this.ncOut = ncOut;
        this.version = ncOut.getVersion();
    }

    public void rewrite() throws IOException, InvalidRangeException {
        Attribute attr = this.ncIn.getRootGroup().findAttribute("featureType");
        if (attr.getStringValue().contains("RADIAL")) {
            this.isRadial = true;
        }
        this.createGroup(null, this.ncIn.getRootGroup());
        this.ncOut.create();
        this.transferData(this.ncIn.getRootGroup());
        this.ncOut.close();
    }

    void createGroup(Group newParent, Group oldGroup) throws IOException, InvalidRangeException {
        Group newGroup = this.ncOut.addGroup(newParent, oldGroup.getShortName());
        for (Attribute att : oldGroup.attributes()) {
            newGroup.addAttribute(att);
        }
        for (Dimension dim : oldGroup.getDimensions()) {
            this.ncOut.addDimension(newGroup, dim.getShortName(), dim.getLength(), dim.isUnlimited(), dim.isVariableLength());
        }
        for (Variable v : oldGroup.getVariables()) {
            Variable nv;
            List dims = v.getDimensions();
            for (Dimension dim : dims) {
                if (dim.isShared()) continue;
                dim.setName("anon" + this.anon);
                dim.setShared(true);
                ++this.anon;
                this.ncOut.addDimension(newGroup, dim.getShortName(), dim.getLength(), dim.isUnlimited(), dim.isVariableLength());
            }
            if (!this.isRadial && v.getRank() >= 3) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i < dims.size(); ++i) {
                    sb.append(((Dimension)dims.get(i)).getShortName()).append(" ");
                }
                sb.append(((Dimension)dims.get(0)).getShortName());
                nv = this.ncOut.addVariable(null, v.getShortName(), v.getDataType(), sb.toString());
            } else {
                nv = this.ncOut.addVariable(null, v.getShortName(), v.getDataType(), v.getDimensionsString());
            }
            for (Attribute att : v.attributes()) {
                this.ncOut.addVariableAttribute(nv, att);
            }
        }
        for (Group g : oldGroup.getGroups()) {
            this.createGroup(newGroup, g);
        }
    }

    void transferData(Group oldGroup) throws IOException, InvalidRangeException {
        for (Variable v : oldGroup.getVariables()) {
            if (!this.isRadial && v.getRank() >= 3) {
                this.invertOneVar(v);
                continue;
            }
            System.out.printf("write %s%n", v.getNameAndDimensions());
            Array data = v.read();
            Variable nv = this.ncOut.findVariable(v.getFullName());
            this.ncOut.write(nv, data);
        }
        for (Group g : oldGroup.getGroups()) {
            this.transferData(g);
        }
    }

    void invertOneVar(Variable oldVar) throws IOException, InvalidRangeException {
        System.out.printf("invertOneVar %s  ", oldVar.getNameAndDimensions());
        int rank = oldVar.getRank();
        int[] origin = new int[rank];
        int[] shape = oldVar.getShape();
        Variable nv = this.ncOut.findVariable(oldVar.getFullName());
        Cache cache = new Cache(shape, nv.getShape(), oldVar.getDataType());
        System.out.printf(" read slice", new Object[0]);
        int nt = shape[0];
        for (int k = 0; k < nt; ++k) {
            shape[0] = 1;
            origin[0] = k;
            Array data = oldVar.read(origin, shape);
            System.out.printf(" %d", k);
            cache.transfer(data.reduce(), k);
        }
        System.out.printf(" %n", new Object[0]);
        cache.write(nv);
    }

    private class Cache {
        int[] shape;
        int[] newshape;
        int nt;
        int chunksize;
        Array result;
        Array work;
        int counter;

        Cache(int[] shape, int[] newshape, DataType dataType) {
            System.out.printf("shape = %d, ", new Section(shape).computeSize() / 1000L);
            System.out.printf("newshape = %d, ", new Section(newshape).computeSize() / 1000L);
            this.nt = shape[0];
            Section s = new Section(shape);
            long totalSize = s.computeSize();
            this.chunksize = (int)(totalSize / (long)this.nt);
            System.out.printf("chunksize = %d (Kb)%n", this.chunksize / 1000);
            this.shape = shape;
            this.newshape = newshape;
            this.result = Array.factory((DataType)dataType, (int[])this.newshape);
            int[] reshape = new int[]{this.chunksize, this.nt};
            this.work = this.result.reshapeNoCopy(reshape);
        }

        void transfer(Array slice, int k) {
            Index ima = this.work.getIndex();
            ima.set1(k);
            int count = 0;
            IndexIterator ii = slice.getIndexIterator();
            while (ii.hasNext()) {
                this.work.setDouble(ima.set0(count), ii.getDoubleNext());
                ++count;
            }
        }

        void write(Variable newVar) throws IOException, InvalidRangeException {
            int[] resultShape;
            System.out.printf("  write slice (", new Object[0]);
            for (int k : resultShape = this.result.getShape()) {
                System.out.printf("%d,", k);
            }
            System.out.printf(")%n", new Object[0]);
            Rewrite.this.ncOut.write(newVar, this.result);
        }
    }
}

