/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.lang.reflect.Constructor;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.message.BasicHttpResponse;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;

public class HTTPFactory {
    public static Class MOCKMETHODCLASS = null;

    public static HTTPSession newSession(String host, int port) throws HTTPException {
        return new HTTPSession(host, port);
    }

    public static HTTPSession newSession(String url) throws HTTPException {
        return new HTTPSession(url);
    }

    public static HTTPSession newSession(HttpHost target) throws HTTPException {
        return new HTTPSession(target);
    }

    @Deprecated
    public static HTTPSession newSession(AuthScope scope) throws HTTPException {
        HttpHost hh = new HttpHost(scope.getHost(), scope.getPort(), null);
        return new HTTPSession(hh);
    }

    public static HTTPMethod Get(HTTPSession session, String legalurl) throws HTTPException {
        return HTTPFactory.makemethod(HTTPSession.Methods.Get, session, legalurl);
    }

    public static HTTPMethod Head(HTTPSession session, String legalurl) throws HTTPException {
        return HTTPFactory.makemethod(HTTPSession.Methods.Head, session, legalurl);
    }

    public static HTTPMethod Put(HTTPSession session, String legalurl) throws HTTPException {
        return HTTPFactory.makemethod(HTTPSession.Methods.Put, session, legalurl);
    }

    public static HTTPMethod Post(HTTPSession session, String legalurl) throws HTTPException {
        return HTTPFactory.makemethod(HTTPSession.Methods.Post, session, legalurl);
    }

    public static HTTPMethod Options(HTTPSession session, String legalurl) throws HTTPException {
        return HTTPFactory.makemethod(HTTPSession.Methods.Options, session, legalurl);
    }

    public static HTTPMethod Get(HTTPSession session) throws HTTPException {
        return HTTPFactory.Get(session, null);
    }

    public static HTTPMethod Head(HTTPSession session) throws HTTPException {
        return HTTPFactory.Head(session, null);
    }

    public static HTTPMethod Put(HTTPSession session) throws HTTPException {
        return HTTPFactory.Put(session, null);
    }

    public static HTTPMethod Post(HTTPSession session) throws HTTPException {
        return HTTPFactory.Post(session, null);
    }

    public static HTTPMethod Options(HTTPSession session) throws HTTPException {
        return HTTPFactory.Options(session, null);
    }

    public static HTTPMethod Get(String legalurl) throws HTTPException {
        return HTTPFactory.Get(null, legalurl);
    }

    public static HTTPMethod Head(String legalurl) throws HTTPException {
        return HTTPFactory.Head(null, legalurl);
    }

    public static HTTPMethod Put(String legalurl) throws HTTPException {
        return HTTPFactory.Put(null, legalurl);
    }

    public static HTTPMethod Post(String legalurl) throws HTTPException {
        return HTTPFactory.Post(null, legalurl);
    }

    public static HTTPMethod Options(String legalurl) throws HTTPException {
        return HTTPFactory.Options(null, legalurl);
    }

    protected static HTTPMethod makemethod(HTTPSession.Methods m, HTTPSession session, String url) throws HTTPException {
        HTTPMethod meth = null;
        if (MOCKMETHODCLASS == null) {
            meth = new HTTPMethod(m, session, url);
        } else {
            Class methodcl = MOCKMETHODCLASS;
            Constructor cons = null;
            try {
                cons = methodcl.getConstructor(HTTPSession.Methods.class, HTTPSession.class, String.class);
            }
            catch (Exception e) {
                throw new HTTPException("HTTPFactory: no proper HTTPMethod constructor available", e);
            }
            try {
                meth = (HTTPMethod)cons.newInstance(new Object[]{m, session, url});
            }
            catch (Exception e) {
                throw new HTTPException("HTTPFactory: HTTPMethod constructor failed", e);
            }
        }
        return meth;
    }

    public static Set<String> getAllowedMethods() {
        BasicHttpResponse rs = new BasicHttpResponse(new ProtocolVersion("http", 1, 1), 0, "");
        Set set = new HttpOptions().getAllowedMethods((HttpResponse)rs);
        return set;
    }
}

