/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.jdom2.Element;
import org.slf4j.Logger;
import thredds.client.catalog.Catalog;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.SectionIterable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribDataReader;
import ucar.nc2.grib.collection.GribIospBuilder;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.coord.Coordinate;
import ucar.nc2.grib.coord.CoordinateEns;
import ucar.nc2.grib.coord.CoordinateRuntime;
import ucar.nc2.grib.coord.CoordinateTime;
import ucar.nc2.grib.coord.CoordinateTime2D;
import ucar.nc2.grib.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.coord.CoordinateTimeIntv;
import ucar.nc2.grib.coord.CoordinateVert;
import ucar.nc2.grib.coord.EnsCoordValue;
import ucar.nc2.grib.coord.TimeCoordIntvValue;
import ucar.nc2.grib.coord.VertCoordType;
import ucar.nc2.grib.coord.VertCoordValue;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public abstract class GribIosp
extends AbstractIOServiceProvider {
    public static int debugIndexOnlyCount;
    protected final FeatureCollectionConfig config = new FeatureCollectionConfig();
    protected final boolean isGrib1;
    protected final Logger logger;
    protected GribCollectionImmutable gribCollection;
    protected GribCollectionImmutable.GroupGC gHcs;
    protected GribCollectionImmutable.Type gtype;
    protected boolean isPartitioned;
    protected boolean owned;
    protected GribTables gribTable;

    public void setParamTable(Element paramTable) {
        this.config.gribConfig.paramTable = paramTable;
    }

    public void setLookupTablePath(String lookupTablePath) {
        this.config.gribConfig.lookupTablePath = lookupTablePath;
    }

    public void setParamTablePath(String paramTablePath) {
        this.config.gribConfig.paramTablePath = paramTablePath;
    }

    @Nullable
    public Object sendIospMessage(Object special) {
        if (special instanceof String) {
            int pos;
            String s = (String)special;
            if (s.startsWith("gribParameterTableLookup")) {
                int pos2 = s.indexOf("=");
                if (pos2 > 0) {
                    this.config.gribConfig.lookupTablePath = s.substring(pos2 + 1).trim();
                }
            } else if (s.startsWith("gribParameterTable") && (pos = s.indexOf("=")) > 0) {
                this.config.gribConfig.paramTablePath = s.substring(pos + 1).trim();
            }
            return null;
        }
        if (special instanceof Element) {
            Element root = (Element)special;
            this.config.gribConfig.configFromXml(root, Catalog.ncmlNS);
            return null;
        }
        return super.sendIospMessage(special);
    }

    public GribIosp(boolean isGrib1, Logger logger) {
        this.isGrib1 = isGrib1;
        this.logger = logger;
    }

    protected abstract GribTables createCustomizer() throws IOException;

    protected abstract String makeVariableName(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableLongName(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableUnits(GribCollectionImmutable.VariableIndex var1);

    protected abstract String getVerticalCoordDesc(int var1);

    protected abstract GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex var1);

    public boolean isBuilder() {
        return true;
    }

    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        GribIospBuilder helper;
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof PartitionCollectionImmutable) {
                this.isPartitioned = true;
            }
            this.gribTable = this.createCustomizer();
            helper = new GribIospBuilder(this, this.isGrib1, this.logger, this.gribCollection, this.gribTable);
            helper.addGroup(rootGroup, this.gHcs, this.gtype, false);
        } else if (this.gribCollection == null) {
            this.gribCollection = GribCdmIndex.openGribCollectionFromRaf(raf, this.config, CollectionUpdateType.testIndexOnly, this.logger);
            if (this.gribCollection == null) {
                throw new IllegalStateException("Not a GRIB data file or index file " + raf.getLocation());
            }
            this.isPartitioned = this.gribCollection instanceof PartitionCollectionImmutable;
            this.gribTable = this.createCustomizer();
            helper = new GribIospBuilder(this, this.isGrib1, this.logger, this.gribCollection, this.gribTable);
            boolean useDatasetGroup = this.gribCollection.getDatasets().size() > 1;
            for (GribCollectionImmutable.Dataset ds : this.gribCollection.getDatasets()) {
                Group.Builder topGroup;
                if (useDatasetGroup) {
                    topGroup = Group.builder().setName(ds.getType().toString());
                    rootGroup.addGroup(topGroup);
                } else {
                    topGroup = rootGroup;
                }
                Iterable<GribCollectionImmutable.GroupGC> groups = ds.getGroups();
                boolean useGroups = ds.getGroupsSize() > 1;
                for (GribCollectionImmutable.GroupGC g : groups) {
                    helper.addGroup(topGroup, g, ds.getType(), useGroups);
                }
            }
        }
        for (Attribute att : this.gribCollection.getGlobalAttributes()) {
            rootGroup.addAttribute(att);
        }
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof PartitionCollectionImmutable) {
                this.isPartitioned = true;
            }
            this.gribTable = this.createCustomizer();
            this.addGroup(ncfile, ncfile.getRootGroup(), this.gHcs, this.gtype, false);
        } else if (this.gribCollection == null) {
            this.gribCollection = GribCdmIndex.openGribCollectionFromRaf(raf, this.config, CollectionUpdateType.testIndexOnly, this.logger);
            if (this.gribCollection == null) {
                throw new IllegalStateException("Not a GRIB data file or index file " + raf.getLocation());
            }
            this.isPartitioned = this.gribCollection instanceof PartitionCollectionImmutable;
            this.gribTable = this.createCustomizer();
            boolean useDatasetGroup = this.gribCollection.getDatasets().size() > 1;
            for (GribCollectionImmutable.Dataset ds : this.gribCollection.getDatasets()) {
                Group topGroup;
                if (useDatasetGroup) {
                    topGroup = new Group(ncfile, null, ds.getType().toString());
                    ncfile.addGroup(null, topGroup);
                } else {
                    topGroup = ncfile.getRootGroup();
                }
                Iterable<GribCollectionImmutable.GroupGC> groups = ds.getGroups();
                boolean useGroups = ds.getGroupsSize() > 1;
                for (GribCollectionImmutable.GroupGC g : groups) {
                    this.addGroup(ncfile, topGroup, g, ds.getType(), useGroups);
                }
            }
        }
        for (Attribute att : this.gribCollection.getGlobalAttributes()) {
            ncfile.addAttribute(null, att);
        }
    }

    private void addGroup(NetcdfFile ncfile, Group parent, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype, boolean useGroups) {
        Group g;
        if (useGroups) {
            g = new Group(ncfile, parent, group.getId());
            g.addAttribute(new Attribute("long_name", group.getDescription()));
            try {
                ncfile.addGroup(parent, g);
            }
            catch (Exception e) {
                this.logger.warn("Duplicate Group - skipping");
                return;
            }
        } else {
            g = parent;
        }
        this.makeGroup(ncfile, g, group, gctype);
    }

    private void makeGroup(NetcdfFile ncfile, Group g, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype) {
        Variable cv;
        String horizDims;
        Variable hcsV;
        boolean isLatLon;
        GdsHorizCoordSys hcs = group.getGdsHorizCoordSys();
        String grid_mapping = hcs.getName() + "_Projection";
        boolean isRotatedLatLon = !this.isGrib1 && hcs.proj instanceof RotatedPole;
        boolean isLatLon2D = !this.isGrib1 && Grib2Utils.isCurvilinearOrthogonal(hcs.template, this.gribCollection.getCenter());
        boolean bl = isLatLon = this.isGrib1 ? hcs.isLatLon() : Grib2Utils.isLatLon(hcs.template, this.gribCollection.getCenter());
        if (isRotatedLatLon) {
            hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "rlat rlon";
            ncfile.addDimension(g, new Dimension("rlat", hcs.ny));
            ncfile.addDimension(g, new Dimension("rlon", hcs.nx));
            Variable rlat = ncfile.addVariable(g, new Variable(ncfile, g, null, "rlat", DataType.FLOAT, "rlat"));
            rlat.addAttribute(new Attribute("standard_name", "grid_latitude"));
            rlat.addAttribute(new Attribute("units", "degrees"));
            rlat.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy));
            Variable rlon = ncfile.addVariable(g, new Variable(ncfile, g, null, "rlon", DataType.FLOAT, "rlon"));
            rlon.addAttribute(new Attribute("standard_name", "grid_longitude"));
            rlon.addAttribute(new Attribute("units", "degrees"));
            rlon.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx));
        } else if (isLatLon2D) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
        } else if (isLatLon) {
            hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lat", DataType.FLOAT, "lat"));
            cv.addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.getGaussianLats() != null) {
                cv.setCachedData(hcs.getGaussianLats());
                cv.addAttribute(new Attribute("gaussian_lats", "true"));
            } else {
                cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy));
            }
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lon", DataType.FLOAT, "lon"));
            cv.addAttribute(new Attribute("units", "degrees_east"));
            cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx));
        } else {
            hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            ncfile.addDimension(g, new Dimension("x", hcs.nx));
            ncfile.addDimension(g, new Dimension("y", hcs.ny));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "x", DataType.FLOAT, "x"));
            cv.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.nx, (double)hcs.startx, (double)hcs.dx));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "y", DataType.FLOAT, "y"));
            cv.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray((DataType)DataType.FLOAT, (int)hcs.ny, (double)hcs.starty, (double)hcs.dy));
        }
        boolean singleRuntimeWasMade = false;
        for (Coordinate coord : group.coords) {
            Coordinate.Type ctype = coord.getType();
            switch (ctype) {
                case runtime: {
                    if (!gctype.isTwoD() && coord.getNCoords() != 1) break;
                    this.makeRuntimeCoordinate(ncfile, g, (CoordinateRuntime)coord);
                    break;
                }
                case timeIntv: {
                    this.makeTimeCoordinate1D(ncfile, g, (CoordinateTimeIntv)coord);
                    break;
                }
                case time: {
                    this.makeTimeCoordinate1D(ncfile, g, (CoordinateTime)coord);
                    break;
                }
                case vert: {
                    this.makeVerticalCoordinate(ncfile, g, (CoordinateVert)coord);
                    break;
                }
                case ens: {
                    this.makeEnsembleCoordinate(ncfile, g, (CoordinateEns)coord);
                    break;
                }
                case time2D: {
                    String timeDimName;
                    if (gctype.isUniqueTime()) {
                        this.makeUniqueTimeCoordinate2D(ncfile, g, (CoordinateTime2D)coord);
                        break;
                    }
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    if (time2D.isOrthogonal()) {
                        timeDimName = this.makeTimeOffsetOrthogonal(g, time2D);
                        this.makeTimeCoordinate2D(ncfile, g, time2D, timeDimName);
                        break;
                    }
                    if (time2D.isRegular()) {
                        timeDimName = this.makeTimeOffsetRegular(g, time2D);
                        this.makeTimeCoordinate2D(ncfile, g, time2D, timeDimName);
                        break;
                    }
                    this.makeTimeCoordinate2D(ncfile, g, time2D, this.make2dValidTimeDimensionName(time2D.getName()));
                }
            }
        }
        for (GribCollectionImmutable.VariableIndex vindex : group.variList) {
            try (Formatter dimNames = new Formatter();
                 Formatter coordinateAtt = new Formatter();){
                Coordinate run = vindex.getCoordinate(Coordinate.Type.runtime);
                CoordinateTimeAbstract time = vindex.getCoordinateTime();
                if (time == null) {
                    throw new IllegalStateException("No time coordinate = " + vindex);
                }
                String timeDimName = time.getName();
                String timeCoordName = time.getName();
                if (time instanceof CoordinateTime2D) {
                    CoordinateTime2D time2D = (CoordinateTime2D)time;
                    if (!gctype.isUniqueTime() && (time2D.isOrthogonal() || time2D.isRegular())) {
                        timeDimName = this.makeTimeOffsetName(time.getName());
                    } else {
                        timeDimName = this.make2dValidTimeDimensionName(time.getName());
                        timeCoordName = this.make2dValidTimeCoordName(timeDimName);
                    }
                }
                boolean isRunScaler = run != null && run.getSize() == 1;
                switch (gctype) {
                    case SRC: {
                        assert (isRunScaler);
                        dimNames.format("%s ", timeDimName);
                        coordinateAtt.format("%s %s ", run.getName(), timeDimName);
                        break;
                    }
                    case MRUTP: 
                    case MRUTC: {
                        dimNames.format("%s ", timeDimName);
                        coordinateAtt.format("ref%s %s ", timeDimName, timeDimName);
                        break;
                    }
                    case MRC: 
                    case TwoD: {
                        assert (run != null) : "GRIB MRC or TWOD does not have run coordinate";
                        if (isRunScaler) {
                            dimNames.format("%s ", timeDimName);
                        } else {
                            dimNames.format("%s %s ", run.getName(), timeDimName);
                        }
                        coordinateAtt.format("%s %s ", run.getName(), timeCoordName);
                        if (timeDimName == timeCoordName) break;
                        coordinateAtt.format("%s ", timeDimName);
                        break;
                    }
                    case Best: 
                    case BestComplete: {
                        dimNames.format("%s ", timeDimName);
                        coordinateAtt.format("ref%s %s ", timeDimName, timeDimName);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Uknown GribCollection TYpe = " + (Object)((Object)gctype));
                    }
                }
                for (Coordinate coord : vindex.getCoordinates()) {
                    if (coord instanceof CoordinateTimeAbstract || coord instanceof CoordinateRuntime) continue;
                    String name = coord.getName().toLowerCase();
                    dimNames.format("%s ", name);
                    coordinateAtt.format("%s ", name);
                }
                dimNames.format("%s", horizDims);
                coordinateAtt.format("%s ", horizDims);
                String vname = this.makeVariableName(vindex);
                Variable v = new Variable(ncfile, g, null, vname, DataType.FLOAT, dimNames.toString());
                ncfile.addVariable(g, v);
                String desc = this.makeVariableLongName(vindex);
                v.addAttribute(new Attribute("long_name", desc));
                v.addAttribute(new Attribute("units", this.makeVariableUnits(vindex)));
                GribTables.Parameter gp = this.getParameter(vindex);
                if (gp != null) {
                    if (gp.getDescription() != null) {
                        v.addAttribute(new Attribute("description", gp.getDescription()));
                    }
                    if (gp.getAbbrev() != null) {
                        v.addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                    }
                    v.addAttribute(new Attribute("missing_value", (Number)gp.getMissing()));
                    if (gp.getFill() != null) {
                        v.addAttribute(new Attribute("_FillValue", (Number)gp.getFill()));
                    }
                } else {
                    v.addAttribute(new Attribute("missing_value", (Number)Float.valueOf(Float.NaN)));
                }
                if (isLatLon2D) {
                    String s = this.searchCoord(Grib2Utils.getLatLon2DcoordType(desc), group.variList);
                    if (s == null) {
                        v.setDimensions(horizDims);
                        String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                        v.addAttribute(new Attribute("units", units));
                    } else {
                        coordinateAtt.format("%s ", s);
                    }
                } else {
                    v.addAttribute(new Attribute("grid_mapping", grid_mapping));
                }
                v.addAttribute(new Attribute("coordinates", coordinateAtt.toString()));
                if (vindex.getIntvType() >= 0) {
                    GribStatType statType = this.gribTable.getStatType(vindex.getIntvType());
                    if (statType != null) {
                        v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", statType.toString()));
                        CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                        Coordinate timeCoord = vindex.getCoordinate(Coordinate.Type.timeIntv);
                        if (cm != null && timeCoord != null) {
                            v.addAttribute(new Attribute("cell_methods", timeCoord.getName() + ": " + cm));
                        }
                    } else {
                        v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", (Number)vindex.getIntvType()));
                    }
                }
                this.gribCollection.addVariableAttributes((AttributeContainer)v, vindex);
                v.setSPobject((Object)vindex);
            }
        }
    }

    private void makeRuntimeCoordinate(NetcdfFile ncfile, Group g, CoordinateRuntime rtc) {
        int n = rtc.getSize();
        boolean isScalar = n == 1;
        String tcName = rtc.getName();
        String dims = isScalar ? null : rtc.getName();
        ncfile.addDimension(g, new Dimension(tcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        v.addAttribute(new Attribute("units", rtc.getUnit()));
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        v.setSPobject((Object)new Time2Dinfo(Time2DinfoType.reftime, null, rtc));
    }

    private void makeUniqueTimeCoordinate2D(NetcdfFile ncfile, Group g, CoordinateTime2D time2D) {
        String refName;
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int countU = 0;
        for (int run = 0; run < time2D.getNruns(); ++run) {
            CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
            countU += timeCoord.getSize();
        }
        int ntimes = countU;
        String tcName = time2D.getName();
        String timeDimName = this.make2dValidTimeDimensionName(tcName);
        ncfile.addDimension(g, new Dimension(timeDimName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, timeDimName));
        String units = runtime.getUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            v.setSPobject((Object)new Time2Dinfo(Time2DinfoType.offU, time2D, null));
        } else {
            v.setSPobject((Object)new Time2Dinfo(Time2DinfoType.intvU, time2D, null));
            String bounds_name = timeDimName + "_bounds";
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, timeDimName + " 2"));
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            bounds.setSPobject((Object)new Time2Dinfo(Time2DinfoType.boundsU, time2D, null));
        }
        if (runtime.getNCoords() != 1 && g.findVariableLocal(refName = "ref" + tcName) == null) {
            Variable vref = ncfile.addVariable(g, new Variable(ncfile, g, null, refName, DataType.DOUBLE, timeDimName));
            vref.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
            vref.addAttribute(new Attribute("long_name", "GRIB reference time"));
            vref.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
            vref.addAttribute(new Attribute("units", units));
            vref.setSPobject((Object)new Time2Dinfo(Time2DinfoType.isUniqueRuntime, time2D, null));
        }
    }

    private String make2dValidTimeDimensionName(String variableName) {
        return variableName.replaceFirst("valid", "");
    }

    private String make2dValidTimeCoordName(String dimName) {
        return "valid" + dimName;
    }

    private String makeTimeOffsetName(String timeName) {
        return timeName.toLowerCase() + "Offset";
    }

    private void makeTimeCoordinate2D(NetcdfFile ncfile, Group g, CoordinateTime2D time2D, String timeDimName) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int ntimes = time2D.getNtimes();
        String tcName = time2D.getName();
        String dims = runtime.getName() + " " + timeDimName;
        int dimLength = ntimes;
        if (g.findDimension(timeDimName) == null) {
            ncfile.addDimension(g, new Dimension(timeDimName, dimLength));
        }
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = runtime.getUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!tcName.equalsIgnoreCase(timeDimName)) {
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        }
        if (!time2D.isTimeInterval()) {
            v.setSPobject((Object)new Time2Dinfo(Time2DinfoType.off, time2D, null));
        } else {
            v.setSPobject((Object)new Time2Dinfo(Time2DinfoType.intv, time2D, null));
            String bounds_name = tcName + "_bounds";
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            bounds.setSPobject((Object)new Time2Dinfo(Time2DinfoType.bounds, time2D, null));
        }
    }

    private Array makeLazyCoordinateData(Variable v2, Time2Dinfo info) {
        if (info.time2D != null) {
            return this.makeLazyTime2Darray(v2, info);
        }
        return this.makeLazyTime1Darray(v2, info);
    }

    private Array makeLazyTime1Darray(Variable v2, Time2Dinfo info) {
        int length = info.time1D.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case reftime: {
                CoordinateRuntime rtc = (CoordinateRuntime)info.time1D;
                int count = 0;
                for (double val : rtc.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return Array.factory((DataType)DataType.DOUBLE, (int[])v2.getShape(), (Object)data);
            }
            case timeAuxRef: {
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)info.time1D;
                int count = 0;
                List<Double> masterOffsets = this.gribCollection.getMasterRuntime().getOffsetsInTimeUnits();
                for (int masterIdx : time.getTime2runtime()) {
                    data[count++] = masterOffsets.get(masterIdx - 1);
                }
                return Array.factory((DataType)DataType.DOUBLE, (int[])v2.getShape(), (Object)data);
            }
        }
        throw new IllegalStateException("makeLazyTime1Darray must be reftime or timeAuxRef");
    }

    private Array makeLazyTime2Darray(Variable coord, Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        CalendarPeriod timeUnit = time2D.getTimeUnit();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int length = (int)coord.getSize();
        if (info.which == Time2DinfoType.bounds) {
            length *= 2;
        }
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case offU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    for (int val : coordTime.getOffsetSorted()) {
                        data[count++] = timeUnit.getValue() * val + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case intv: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                break;
            }
            case intvU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            case is1Dtime: {
                CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
                int count = 0;
                for (double val : runtime.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                break;
            }
            case isUniqueRuntime: {
                CoordinateRuntime runtimeU = time2D.getRuntimeCoordinate();
                List<Double> runOffsets = runtimeU.getOffsetsInTimeUnits();
                int count = 0;
                for (int run = 0; run < time2D.getNruns(); ++run) {
                    CoordinateTimeAbstract timeCoord = time2D.getTimeCoordinate(run);
                    for (int time = 0; time < timeCoord.getNCoords(); ++time) {
                        data[count++] = runOffsets.get(run);
                    }
                }
                break;
            }
            case bounds: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                break;
            }
            case boundsU: {
                int count = 0;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    for (TimeCoordIntvValue tinv : timeIntv.getTimeIntervals()) {
                        data[count++] = timeUnit.getValue() * tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[count++] = timeUnit.getValue() * tinv.getBounds2() + time2D.getOffset(runIdx);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Array.factory((DataType)DataType.DOUBLE, (int[])coord.getShape(), (Object)data);
    }

    private void makeTimeCoordinate1D(NetcdfFile ncfile, Group g, CoordinateTime coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = coordTime.getTimeUdUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (int val : coordTime.getOffsetSorted()) {
            data[count++] = val;
        }
        v.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ntimes}, (Object)data));
        this.makeTimeAuxReference(ncfile, g, tcName, units, coordTime);
    }

    private void makeTimeAuxReference(NetcdfFile ncfile, Group g, String timeName, String units, CoordinateTimeAbstract time) {
        if (time.getTime2runtime() == null) {
            return;
        }
        String tcName = "ref" + timeName;
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, timeName));
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        v.addAttribute(new Attribute("units", units));
        v.setSPobject((Object)new Time2Dinfo(Time2DinfoType.timeAuxRef, null, time));
    }

    private void makeTimeCoordinate1D(NetcdfFile ncfile, Group g, CoordinateTimeIntv coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = coordTime.getTimeUdUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", "GRIB forecast or observation time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds2();
        }
        v.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ntimes}, (Object)data));
        String bounds_name = tcName + "_bounds";
        Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
        v.addAttribute(new Attribute("bounds", bounds_name));
        bounds.addAttribute(new Attribute("units", units));
        bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
        data = new double[ntimes * 2];
        count = 0;
        for (TimeCoordIntvValue tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds1();
            data[count++] = tinv.getBounds2();
        }
        bounds.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ntimes, 2}, (Object)data));
        this.makeTimeAuxReference(ncfile, g, tcName, units, coordTime);
    }

    private void makeVerticalCoordinate(NetcdfFile ncfile, Group g, CoordinateVert vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(vcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName, DataType.FLOAT, vcName));
        if (vc.getUnit() != null) {
            v.addAttribute(new Attribute("units", vc.getUnit()));
            String desc = this.getVerticalCoordDesc(vc.getCode());
            if (desc != null) {
                v.addAttribute(new Attribute("long_name", desc));
            }
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        v.addAttribute(new Attribute("Grib_level_type", (Number)vc.getCode()));
        VertCoordType vu = vc.getVertUnit();
        if (vu != null && vu.getDatum() != null) {
            v.addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            v.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n}, (Object)data));
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName + "_bounds", DataType.FLOAT, vcName + " 2"));
            v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
            String vcUnit = vc.getUnit();
            if (vcUnit != null) {
                bounds.addAttribute(new Attribute("units", vcUnit));
            }
            bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoordValue level : vc.getLevelSorted()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            bounds.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n, 2}, (Object)data));
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoordValue val : vc.getLevelSorted()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory((DataType)DataType.FLOAT, (int[])new int[]{n}, (Object)data));
        }
    }

    private void makeEnsembleCoordinate(NetcdfFile ncfile, Group g, CoordinateEns ec) {
        int n = ec.getSize();
        String ecName = ec.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(ecName, n));
        Variable v = new Variable(ncfile, g, null, ecName, DataType.INT, ecName);
        ncfile.addVariable(g, v);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        int[] data = new int[n];
        int count = 0;
        for (EnsCoordValue ecc : ec.getEnsSorted()) {
            data[count++] = ecc.getEnsMember();
        }
        v.setCachedData(Array.factory((DataType)DataType.INT, (int[])new int[]{n}, (Object)data));
    }

    @Nullable
    String searchCoord(Grib2Utils.LatLonCoordType type, List<GribCollectionImmutable.VariableIndex> list) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case U: {
                GribCollectionImmutable.VariableIndex lat = this.findParameter(list, 198);
                GribCollectionImmutable.VariableIndex lon = this.findParameter(list, 199);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case V: {
                GribCollectionImmutable.VariableIndex lat = this.findParameter(list, 200);
                GribCollectionImmutable.VariableIndex lon = this.findParameter(list, 201);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case P: {
                GribCollectionImmutable.VariableIndex lat = this.findParameter(list, 202);
                GribCollectionImmutable.VariableIndex lon = this.findParameter(list, 203);
                return lat != null && lon != null ? this.makeVariableName(lat) + "  " + this.makeVariableName(lon) : null;
            }
        }
        return null;
    }

    @Nullable
    private GribCollectionImmutable.VariableIndex findParameter(List<GribCollectionImmutable.VariableIndex> list, int p) {
        for (GribCollectionImmutable.VariableIndex vindex : list) {
            if (vindex.getDiscipline() != 0 || vindex.getCategory() != 2 || vindex.getParameter() != p) continue;
            return vindex;
        }
        return null;
    }

    public void close() throws IOException {
        if (!this.owned && this.gribCollection != null) {
            this.gribCollection.close();
        }
        this.gribCollection = null;
        super.close();
    }

    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        if (v2.getSPobject() instanceof Time2Dinfo) {
            Time2Dinfo info = (Time2Dinfo)v2.getSPobject();
            Array data = this.makeLazyCoordinateData(v2, info);
            Section sectionFilled = Section.fill((Section)section, (int[])v2.getShape());
            return data.sectionNoReduce(sectionFilled.getRanges());
        }
        try {
            GribCollectionImmutable.VariableIndex vindex = (GribCollectionImmutable.VariableIndex)v2.getSPobject();
            GribDataReader dataReader = GribDataReader.factory(this.gribCollection, vindex);
            SectionIterable sectionIter = new SectionIterable(section, v2.getShape());
            Array result = dataReader.readData(sectionIter);
            long took = System.currentTimeMillis() - start;
            return result;
        }
        catch (IOException ioe) {
            this.logger.error("Failed to readData ", (Throwable)ioe);
            throw ioe;
        }
    }

    private String makeTimeOffsetOrthogonal(Group g, CoordinateTime2D time2D) {
        int count;
        List<?> offsets = time2D.getOffsetsSorted();
        int n = offsets.size();
        String toName = this.makeTimeOffsetName(time2D.getName());
        g.addDimension(new Dimension(toName, n));
        Variable v = new Variable(this.ncfile, g, null, toName, DataType.DOUBLE, toName);
        g.addVariable(v);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
        v.addAttribute(new Attribute("units", time2D.getUnit()));
        v.addAttribute(new Attribute("standard_name", "forecast_period"));
        v.addAttribute(new Attribute("long_name", "time offset from runtime"));
        v.addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
        double[] midpoints = new double[n];
        double[] bounds = null;
        if (time2D.isTimeInterval()) {
            bounds = new double[2 * n];
            count = 0;
            int countb = 0;
            for (Object offset : offsets) {
                TimeCoordIntvValue tinv = (TimeCoordIntvValue)offset;
                midpoints[count++] = (double)(tinv.getBounds1() + tinv.getBounds2()) / 2.0;
                bounds[countb++] = tinv.getBounds1();
                bounds[countb++] = tinv.getBounds2();
            }
        } else {
            count = 0;
            for (Object val : offsets) {
                Integer off = (Integer)val;
                midpoints[count++] = off.intValue();
            }
        }
        v.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n}, (Object)midpoints), false);
        if (time2D.isTimeInterval()) {
            String boundsName = toName + "_bounds";
            Variable varBounds = new Variable(this.ncfile, g, null, boundsName, DataType.DOUBLE, toName + " 2");
            varBounds.addAttribute(new Attribute("long_name", "TimeOffset coord bounds"));
            VariableDS coordVarBounds = new VariableDS(g, varBounds, true);
            coordVarBounds.setUnitsString(time2D.getTimeUdUnit());
            coordVarBounds.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n, 2}, (Object)bounds), false);
            g.addVariable((Variable)coordVarBounds);
            v.addAttribute(new Attribute("bounds", boundsName));
        }
        return toName;
    }

    private String makeTimeOffsetRegular(Group g, CoordinateTime2D time2D) {
        try {
            int houridx;
            ImmutableList hourFrom0z = ImmutableList.copyOf(time2D.getRegularHourOffsets());
            int nhours = hourFrom0z.size();
            int noffsets = time2D.getNtimes();
            String toName = this.makeTimeOffsetName(time2D.getName());
            if (g.findDimension(toName) == null) {
                g.addDimension(new Dimension(toName, noffsets));
            }
            String dimNames = nhours + " " + toName;
            Variable v = new Variable(this.ncfile, g, null, toName, DataType.DOUBLE, dimNames);
            g.addVariable(v);
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
            v.addAttribute(new Attribute("units", time2D.getUnit()));
            v.addAttribute(new Attribute("standard_name", "forecast_period"));
            v.addAttribute(new Attribute("long_name", "time offset from runtime"));
            v.addAttribute(new Attribute("udunits", time2D.getTimeUdUnit()));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.TimeOffset.toString()));
            v.addAttribute(new Attribute("runtimeCoordinate", g.getFullName() + time2D.getRuntimeCoordinate().getName()));
            Attribute.Builder attb = Attribute.builder((String)"hoursFrom0z").setDataType(DataType.INT).setValues((List)hourFrom0z, false);
            v.addAttribute(attb.build());
            double[] midpoints = new double[nhours * noffsets];
            Arrays.fill(midpoints, Double.NaN);
            double[] bounds = null;
            if (time2D.isTimeInterval()) {
                bounds = new double[2 * nhours * noffsets];
                Arrays.fill(bounds, Double.NaN);
                houridx = 0;
                for (int hour : time2D.getRegularHourOffsets()) {
                    CoordinateTimeIntv timeCoord = (CoordinateTimeIntv)time2D.getTimeCoordinate(houridx);
                    int count = houridx * noffsets;
                    int countb = 2 * houridx * noffsets;
                    for (TimeCoordIntvValue tinv : timeCoord.getTimeIntervals()) {
                        midpoints[count++] = (double)(tinv.getBounds1() + tinv.getBounds2()) / 2.0;
                        bounds[countb++] = tinv.getBounds1();
                        bounds[countb++] = tinv.getBounds2();
                    }
                    ++houridx;
                }
            } else {
                Arrays.fill(midpoints, Double.NaN);
                houridx = 0;
                for (int hour : time2D.getRegularHourOffsets()) {
                    CoordinateTime timeCoord = (CoordinateTime)time2D.getRegularTimeCoordinate(hour);
                    int count = houridx * noffsets;
                    for (Integer offset : timeCoord.getOffsetSorted()) {
                        midpoints[count++] = offset.intValue();
                    }
                    ++houridx;
                }
            }
            v.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nhours, noffsets}, (Object)midpoints), false);
            if (time2D.isTimeInterval()) {
                String boundsName = toName + "_bounds";
                Variable varBounds = new Variable(this.ncfile, g, null, boundsName, DataType.DOUBLE, toName + " 2");
                varBounds.addAttribute(new Attribute("long_name", "time offset coord bounds"));
                VariableDS coordVarBounds = new VariableDS(g, varBounds, true);
                coordVarBounds.setUnitsString(time2D.getTimeUdUnit());
                coordVarBounds.setCachedData(Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nhours, noffsets, 2}, (Object)bounds), false);
                v.addAttribute(new Attribute("bounds", boundsName));
            }
            return toName;
        }
        catch (Throwable t) {
            this.logger.error("Error in makeTimeOffsetRegular variable {}", (Object)this.makeTimeOffsetName(time2D.getName()), (Object)t);
            throw new RuntimeException(t);
        }
    }

    public abstract Object getLastRecordRead();

    public abstract void clearLastRecordRead();

    public abstract Object getGribCustomizer();

    static class Time2Dinfo {
        final Time2DinfoType which;
        final CoordinateTime2D time2D;
        final Coordinate time1D;

        Time2Dinfo(Time2DinfoType which, CoordinateTime2D time2D, Coordinate time1D) {
            this.which = which;
            this.time2D = time2D;
            this.time1D = time1D;
        }
    }

    static enum Time2DinfoType {
        off,
        offU,
        intv,
        intvU,
        bounds,
        boundsU,
        is1Dtime,
        isUniqueRuntime,
        reftime,
        timeAuxRef;

    }
}

