/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import javax.annotation.Nullable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.table.Grib2ParamTableInterface;
import ucar.nc2.grib.grib2.table.WmoCodeFlagTables;

public class WmoParamTable
implements Grib2ParamTableInterface {
    private final WmoCodeFlagTables.WmoTable wmoTable;
    private final ImmutableMap<Integer, GribTables.Parameter> entryMap;

    @Nullable
    public static GribTables.Parameter getParameter(int discipline, int category, int number) {
        WmoParamTable paramTable = WmoCodeFlagTables.getInstance().getParamTable(discipline, category);
        return paramTable == null ? null : paramTable.getParameter(number);
    }

    @Nullable
    public static String getParameterName(int discipline, int category, int number) {
        WmoParamTable paramTable = WmoCodeFlagTables.getInstance().getParamTable(discipline, category);
        GribTables.Parameter param = paramTable == null ? null : paramTable.getParameter(number);
        return param == null ? null : param.getName();
    }

    WmoParamTable(WmoCodeFlagTables.WmoTable wmoTable) {
        Preconditions.checkNotNull((Object)wmoTable);
        Preconditions.checkArgument((wmoTable.getType() == WmoCodeFlagTables.TableType.param ? 1 : 0) != 0);
        this.wmoTable = wmoTable;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        wmoTable.getEntries().forEach(entry -> builder.put((Object)entry.getNumber(), (Object)new WmoParamEntry((WmoCodeFlagTables.WmoTable.WmoEntry)entry)));
        this.entryMap = builder.build();
    }

    @Override
    public String getName() {
        return this.wmoTable.getName();
    }

    @Override
    public String getShortName() {
        return this.wmoTable.getName();
    }

    @Override
    public ImmutableList<GribTables.Parameter> getParameters() {
        return ImmutableList.copyOf((Collection)this.entryMap.values());
    }

    @Override
    @Nullable
    public GribTables.Parameter getParameter(int number) {
        return (GribTables.Parameter)this.entryMap.get((Object)number);
    }

    private class WmoParamEntry
    implements GribTables.Parameter {
        private WmoCodeFlagTables.WmoTable.WmoEntry entry;

        public WmoParamEntry(WmoCodeFlagTables.WmoTable.WmoEntry entry) {
            this.entry = entry;
        }

        @Override
        public int getDiscipline() {
            return this.entry.getDiscipline();
        }

        @Override
        public int getCategory() {
            return this.entry.getCategory();
        }

        @Override
        public int getNumber() {
            return this.entry.getNumber();
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String getUnit() {
            return this.entry.getUnit();
        }

        @Override
        @Nullable
        public String getAbbrev() {
            return null;
        }

        @Override
        public String getDescription() {
            return this.entry.getName();
        }

        @Override
        public String getId() {
            return this.entry.getId();
        }

        @Override
        @Nullable
        public Float getFill() {
            return null;
        }

        @Override
        public Float getMissing() {
            return Float.valueOf(Float.NaN);
        }

        @Override
        public String getOperationalStatus() {
            return this.entry.getStatus();
        }
    }
}

