/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Tables;

public class Grib2Variable {
    private final Grib2Tables cust;
    private final int discipline;
    private final int center;
    private final int subcenter;
    private final int gdsHash;
    private final Grib2Gds gds;
    private final Grib2Pds pds;
    private final boolean intvMerge;
    private final boolean useGenType;

    public static int cdmVariableHash(Grib2Tables cust, Grib2Record gr, int gdsHashOverride, boolean intvMerge, boolean useGenType) {
        Grib2Variable gv = new Grib2Variable(cust, gr, gdsHashOverride, intvMerge, useGenType);
        return gv.hashCode();
    }

    public Grib2Variable(Grib2Tables cust, Grib2Record gr, int gdsHashOverride, boolean intvMerge, boolean useGenType) {
        this.cust = cust;
        this.discipline = gr.getDiscipline();
        this.center = gr.getId().getCenter_id();
        this.subcenter = gr.getId().getSubcenter_id();
        this.gds = gr.getGDS();
        this.gdsHash = gdsHashOverride != 0 ? gdsHashOverride : gr.getGDS().hashCode();
        this.pds = gr.getPDS();
        this.intvMerge = intvMerge;
        this.useGenType = useGenType;
    }

    public Grib2Variable(Grib2Tables cust, int discipline, int center, int subcenter, Grib2Gds gds, Grib2Pds pds, boolean intvMerge, boolean useGenType) {
        this.cust = cust;
        this.discipline = discipline;
        this.center = center;
        this.subcenter = subcenter;
        this.gds = gds;
        this.gdsHash = gds.hashCode;
        this.pds = pds;
        this.intvMerge = intvMerge;
        this.useGenType = useGenType;
    }

    public boolean equals(Object o) {
        boolean error2;
        Grib2Pds.PdsSpatialInterval pdsSpatial;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2Variable var2 = (Grib2Variable)o;
        if (this.gdsHash != var2.gdsHash) {
            return false;
        }
        if (!this.gds.equals(var2.gds)) {
            return false;
        }
        Grib2Pds pds2 = var2.pds;
        if (this.pds.getParameterNumber() != pds2.getParameterNumber()) {
            return false;
        }
        if (this.pds.getParameterCategory() != pds2.getParameterCategory()) {
            return false;
        }
        if (this.pds.getTemplateNumber() != pds2.getTemplateNumber()) {
            return false;
        }
        if (this.discipline != var2.discipline) {
            return false;
        }
        if (Grib2Utils.isLayer(this.pds) != Grib2Utils.isLayer(pds2)) {
            return false;
        }
        if (this.pds.getLevelType1() != pds2.getLevelType1()) {
            return false;
        }
        if (this.pds.isTimeInterval() != pds2.isTimeInterval()) {
            return false;
        }
        if (this.pds.isTimeInterval()) {
            double size2;
            double size;
            if (!this.intvMerge && (size = this.cust.getForecastTimeIntervalSizeInHours(this.pds)) != (size2 = this.cust.getForecastTimeIntervalSizeInHours(pds2))) {
                return false;
            }
            if (this.pds.getStatisticalProcessType() != pds2.getStatisticalProcessType()) {
                return false;
            }
        }
        if (this.pds.isSpatialInterval() != pds2.isSpatialInterval()) {
            return false;
        }
        if (this.pds.isSpatialInterval() && (pdsSpatial = (Grib2Pds.PdsSpatialInterval)((Object)this.pds)).getSpatialStatisticalProcessType() != pdsSpatial.getSpatialStatisticalProcessType()) {
            return false;
        }
        int ensDerivedType = -1;
        if (this.pds.isEnsembleDerived() != pds2.isEnsembleDerived()) {
            return false;
        }
        if (this.pds.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)this.pds);
            Grib2Pds.PdsEnsembleDerived pdsDerived2 = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
            if (pdsDerived.getDerivedForecastType() != pdsDerived2.getDerivedForecastType()) {
                return false;
            }
            ensDerivedType = pdsDerived.getDerivedForecastType();
        } else if (this.pds.isEnsemble() != pds2.isEnsemble()) {
            return false;
        }
        int probType = -1;
        if (this.pds.isProbability() != pds2.isProbability()) {
            return false;
        }
        if (this.pds.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)this.pds);
            Grib2Pds.PdsProbability pdsProb2 = (Grib2Pds.PdsProbability)((Object)pds2);
            if (pdsProb.getProbabilityHashcode() != pdsProb2.getProbabilityHashcode()) {
                return false;
            }
            probType = pdsProb.getProbabilityType();
        }
        if (this.pds.isPercentile() != pds2.isPercentile()) {
            return false;
        }
        if (this.pds.isPercentile()) {
            Grib2Pds.PdsPercentile pdsPctl = (Grib2Pds.PdsPercentile)((Object)this.pds);
            Grib2Pds.PdsPercentile pdsPctl2 = (Grib2Pds.PdsPercentile)((Object)pds2);
            if (pdsPctl.getPercentileValue() != pdsPctl2.getPercentileValue()) {
                return false;
            }
        }
        if (pds2.getParameterCategory() > 191 || pds2.getParameterNumber() > 191 || pds2.getLevelType1() > 191 || pds2.isTimeInterval() && pds2.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
            if (this.center != var2.center) {
                return false;
            }
            if (this.subcenter != var2.subcenter) {
                return false;
            }
        }
        int genType = this.pds.getGenProcessType();
        int genType2 = pds2.getGenProcessType();
        boolean error = genType == 6 || genType == 7;
        boolean bl = error2 = genType2 == 6 || genType2 == 7;
        if (error != error2) {
            return false;
        }
        return !this.useGenType || genType == genType2;
    }

    public int hashCode() {
        int genType;
        int result = 17;
        result += result * 31 + this.discipline;
        result += result * 31 + this.pds.getLevelType1();
        if (Grib2Utils.isLayer(this.pds)) {
            result += result * 31 + 1;
        }
        result += result * 31 + this.gdsHash;
        result += result * 31 + this.pds.getParameterCategory();
        result += result * 31 + this.pds.getTemplateNumber();
        if (this.pds.isTimeInterval()) {
            if (!this.intvMerge) {
                double size = this.cust.getForecastTimeIntervalSizeInHours(this.pds);
                result += result * (int)(31.0 + 1000.0 * size);
            }
            result += result * 31 + this.pds.getStatisticalProcessType();
        }
        if (this.pds.isSpatialInterval()) {
            Grib2Pds.PdsSpatialInterval pdsSpatial = (Grib2Pds.PdsSpatialInterval)((Object)this.pds);
            result += result * 31 + pdsSpatial.getSpatialStatisticalProcessType();
        }
        result += result * 31 + this.pds.getParameterNumber();
        int ensDerivedType = -1;
        if (this.pds.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)this.pds);
            ensDerivedType = pdsDerived.getDerivedForecastType();
            result += result * 31 + ensDerivedType;
        } else if (this.pds.isEnsemble()) {
            result += result * 31 + 1;
        }
        int probType = -1;
        if (this.pds.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)this.pds);
            probType = pdsProb.getProbabilityType();
            result += result * 31 + pdsProb.getProbabilityHashcode();
        }
        if (this.pds.isPercentile()) {
            Grib2Pds.PdsPercentile pdsPerc = (Grib2Pds.PdsPercentile)((Object)this.pds);
            result += result * 31 + pdsPerc.getPercentileValue();
        }
        if (this.pds.getParameterCategory() > 191 || this.pds.getParameterNumber() > 191 || this.pds.getLevelType1() > 191 || this.pds.isTimeInterval() && this.pds.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
            result += result * 31 + this.center;
            if (this.subcenter > 0) {
                result += result * 31 + this.subcenter;
            }
        }
        if ((genType = this.pds.getGenProcessType()) == 6 || genType == 7 || this.useGenType && genType > 0) {
            result += result * 31 + genType;
        }
        return result;
    }
}

