/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.wmo.Util;

@Immutable
public class Grib2Parameter
implements GribTables.Parameter,
Comparable<Grib2Parameter> {
    public final int discipline;
    public final int category;
    public final int number;
    public final String name;
    public final String unit;
    public final String abbrev;
    public final String desc;
    public final Float fill;
    public final Float missing;

    public Grib2Parameter(int discipline, int category, int number, String name, String unit, String abbrev, String desc, float fill, float missing) {
        this.discipline = discipline;
        this.category = category;
        this.number = number;
        this.name = name.trim();
        this.abbrev = abbrev;
        this.unit = Util.cleanUnit((String)unit);
        this.desc = desc;
        this.fill = Float.valueOf(fill);
        this.missing = Float.valueOf(missing);
    }

    public Grib2Parameter(int discipline, int category, int number, String name, String unit, String abbrev, String desc) {
        this.discipline = discipline;
        this.category = category;
        this.number = number;
        this.name = name.trim();
        this.abbrev = abbrev;
        this.unit = Util.cleanUnit((String)unit);
        this.desc = desc;
        this.fill = null;
        this.missing = Float.valueOf(Float.NaN);
    }

    public Grib2Parameter(Grib2Parameter from, String name, String unit) {
        this.discipline = from.discipline;
        this.category = from.category;
        this.number = from.number;
        this.desc = from.desc;
        this.abbrev = from.abbrev;
        this.name = name.trim();
        this.unit = Util.cleanUnit((String)unit);
        this.fill = null;
        this.missing = Float.valueOf(Float.NaN);
    }

    @Override
    public String getId() {
        return this.discipline + "." + this.category + "." + this.number;
    }

    @Override
    public int compareTo(@Nonnull Grib2Parameter o) {
        int c = this.discipline - o.discipline;
        if (c != 0) {
            return c;
        }
        c = this.category - o.category;
        if (c != 0) {
            return c;
        }
        return this.number - o.number;
    }

    @Override
    public int getDiscipline() {
        return this.discipline;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getAbbrev() {
        return this.abbrev;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public Float getMissing() {
        return this.missing;
    }

    @Override
    public String getOperationalStatus() {
        return null;
    }

    @Override
    public Float getFill() {
        return this.fill;
    }

    public String toString() {
        return "Grib2Parameter{discipline=" + this.discipline + ", category=" + this.category + ", number=" + this.number + ", name='" + this.name + '\'' + ", unit='" + this.unit + '\'' + ", abbrev='" + this.abbrev + '\'' + ", desc='" + this.desc + '\'' + ", fill='" + this.fill + '\'' + ", missing='" + this.missing + '\'' + '}';
    }
}

