/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.coord;

import java.util.Formatter;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.util.Misc;

@Immutable
public class VertCoordValue
implements Comparable<VertCoordValue> {
    private final double value1;
    private final double value2;
    private final double mid;
    private final boolean isLayer;

    public VertCoordValue(double value1) {
        this.value1 = value1;
        this.value2 = -9999.0;
        this.mid = value1;
        this.isLayer = false;
    }

    public VertCoordValue(double value1, double value2) {
        this.value1 = value1;
        this.value2 = value2;
        this.mid = Double.compare(value2, 0.0) == 0 || GribNumbers.isUndefined(value2) ? value1 : (value1 + value2) / 2.0;
        this.isLayer = true;
    }

    public double getValue1() {
        return this.value1;
    }

    public double getValue2() {
        return this.value2;
    }

    public double getMid() {
        return this.mid;
    }

    public boolean isLayer() {
        return this.isLayer;
    }

    @Override
    public int compareTo(@Nonnull VertCoordValue o) {
        return Double.compare(this.mid, o.mid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertCoordValue that = (VertCoordValue)o;
        return Double.compare(that.value1, this.value1) == 0 && Double.compare(that.value2, this.value2) == 0 && Double.compare(that.mid, this.mid) == 0 && this.isLayer == that.isLayer;
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2, this.mid, this.isLayer);
    }

    public boolean nearlyEquals(VertCoordValue other) {
        return Misc.nearlyEquals((double)this.value1, (double)other.value1) && Misc.nearlyEquals((double)this.value2, (double)other.value2);
    }

    public String toString() {
        try (Formatter out = new Formatter();){
            if (this.isLayer) {
                out.format("(%f,%f)", this.value1, this.value2);
            } else {
                out.format("%f", this.value1);
            }
            String string = out.toString();
            return string;
        }
    }

    public String toString(boolean isLayer) {
        try (Formatter out = new Formatter();){
            if (isLayer) {
                out.format("(%f,%f)", this.value1, this.value2);
            } else {
                out.format("%f", this.value1);
            }
            String string = out.toString();
            return string;
        }
    }
}

